/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.StopWatch;

public class EventNotifierCallback
implements AsyncCallback {
    private final AsyncCallback originalCallback;
    private final StopWatch watch;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final boolean sending;

    public EventNotifierCallback(AsyncCallback originalCallback, Exchange exchange, Endpoint endpoint) {
        this.originalCallback = originalCallback;
        this.exchange = exchange;
        this.endpoint = endpoint;
        this.sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint);
        this.watch = this.sending ? new StopWatch() : null;
    }

    @Override
    public void done(boolean doneSync) {
        if (this.watch != null) {
            long timeTaken = this.watch.taken();
            EventHelper.notifyExchangeSent(this.exchange.getContext(), this.exchange, this.endpoint, timeTaken);
        }
        this.originalCallback.done(doneSync);
    }
}

