/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.coordinator.QueueAndPriority;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionQueueSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueSummaries {
    private static final Logger log = LoggerFactory.getLogger(QueueSummaries.class);
    final Map<String, PrioTserver> LAST = new HashMap<String, PrioTserver>();
    final Map<String, TreeMap<Short, TreeSet<TServerInstance>>> QUEUES = new HashMap<String, TreeMap<Short, TreeSet<TServerInstance>>>();
    final Map<TServerInstance, Set<QueueAndPriority>> INDEX = new HashMap<TServerInstance, Set<QueueAndPriority>>();

    private Map.Entry<Short, TreeSet<TServerInstance>> getNextTserverEntry(String queue) {
        TreeMap<Short, TreeSet<TServerInstance>> m = this.QUEUES.get(queue);
        if (m == null) {
            return null;
        }
        Iterator<Map.Entry<Short, TreeSet<TServerInstance>>> iter = m.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<Short, TreeSet<TServerInstance>> next = iter.next();
            if (next.getValue().isEmpty()) {
                throw new IllegalStateException("Unexpected empty tserver set for queue " + queue + " and prio " + next.getKey());
            }
            return next;
        }
        throw new IllegalStateException("Unexpected empty map for queue " + queue);
    }

    synchronized boolean isCompactionsQueued(String queue) {
        TreeMap<Short, TreeSet<TServerInstance>> q = this.QUEUES.get(queue);
        if (q == null) {
            return false;
        }
        return !q.isEmpty();
    }

    synchronized PrioTserver getNextTserver(String queue) {
        TServerInstance higher;
        Map.Entry<Short, TreeSet<TServerInstance>> entry = this.getNextTserverEntry(queue);
        if (entry == null) {
            this.LAST.remove(queue);
            return null;
        }
        Short priority = entry.getKey();
        TreeSet<TServerInstance> tservers = entry.getValue();
        PrioTserver last = this.LAST.get(queue);
        TServerInstance nextTserver = null;
        nextTserver = last != null && last.prio == priority ? ((higher = tservers.higher(last.tserver)) == null ? tservers.first() : higher) : tservers.first();
        PrioTserver result = new PrioTserver(nextTserver, priority);
        this.LAST.put(queue, result);
        return result;
    }

    synchronized void update(TServerInstance tsi, List<TCompactionQueueSummary> summaries) {
        if (log.isTraceEnabled()) {
            TreeMap summariesToLog = new TreeMap();
            summaries.forEach(summary -> summariesToLog.computeIfAbsent(summary.getQueue(), k -> new ArrayList()).add(summary.getPriority()));
            log.trace("Adding summaries from {} : {}", (Object)tsi, summariesToLog);
        }
        HashSet newQP = new HashSet();
        summaries.forEach(summary -> {
            QueueAndPriority qp = QueueAndPriority.get(summary.getQueue().intern(), summary.getPriority());
            newQP.add(qp);
        });
        Set currentQP = this.INDEX.getOrDefault(tsi, Set.of());
        for (QueueAndPriority qp2 : List.copyOf(Sets.difference(currentQP, newQP))) {
            this.removeSummary(tsi, qp2.getQueue(), qp2.getPriority());
        }
        this.INDEX.put(tsi, newQP);
        newQP.forEach(qp -> this.QUEUES.computeIfAbsent(qp.getQueue(), k -> new TreeMap(Comparator.reverseOrder())).computeIfAbsent(qp.getPriority(), k -> new TreeSet()).add(tsi));
    }

    synchronized void removeSummary(TServerInstance tsi, String queue, short priority) {
        Set<QueueAndPriority> qaps;
        log.trace("Removing summary {} {} {}", new Object[]{tsi, queue, priority});
        TreeMap<Short, TreeSet<TServerInstance>> m = this.QUEUES.get(queue);
        if (m != null) {
            TreeSet<TServerInstance> s = m.get(priority);
            if (s != null && s.remove(tsi) && s.isEmpty()) {
                m.remove(priority);
            }
            if (m.isEmpty()) {
                this.QUEUES.remove(queue);
            }
        }
        if ((qaps = this.INDEX.get(tsi)) != null && qaps.remove(QueueAndPriority.get(queue, priority)) && qaps.isEmpty()) {
            this.INDEX.remove(tsi);
        }
    }

    synchronized void remove(Set<TServerInstance> deleted) {
        if (!deleted.isEmpty()) {
            log.trace("Removing all summaries to tservers {}", deleted);
        }
        deleted.forEach(tsi -> {
            this.INDEX.getOrDefault(tsi, Set.of()).forEach(qp -> {
                TreeSet<TServerInstance> tservers;
                TreeMap<Short, TreeSet<TServerInstance>> m = this.QUEUES.get(qp.getQueue());
                if (null != m && null != (tservers = m.get(qp.getPriority()))) {
                    if (tservers.remove(tsi) && tservers.isEmpty()) {
                        m.remove(qp.getPriority());
                    }
                    if (m.isEmpty()) {
                        this.QUEUES.remove(qp.getQueue());
                    }
                }
            });
            this.INDEX.remove(tsi);
        });
    }

    static class PrioTserver {
        TServerInstance tserver;
        final short prio;

        public PrioTserver(TServerInstance t, short p) {
            this.tserver = t;
            this.prio = p;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PrioTserver) {
                PrioTserver opt = (PrioTserver)obj;
                return this.tserver.equals((Object)opt.tserver) && this.prio == opt.prio;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.tserver, this.prio);
        }

        public String toString() {
            return this.tserver + " " + this.prio;
        }
    }
}

