/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import java.io.DataInputStream;
import java.util.Set;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.accumulo.tserver.replication.ReplicationStats;
import org.apache.accumulo.tserver.replication.WalReplication;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class WalClientExecReturn
implements ThriftClientTypes.Exec<ReplicationStats, ReplicationServicer.Client> {
    private static final Logger log = LoggerFactory.getLogger(WalClientExecReturn.class);
    private final AccumuloReplicaSystem ars;
    private ReplicationTarget target;
    private DataInputStream input;
    private Path p;
    private Replication.Status status;
    private long sizeLimit;
    private String remoteTableId;
    private TCredentials tcreds;
    private Set<Integer> tids;

    public WalClientExecReturn(AccumuloReplicaSystem ars, ReplicationTarget target, DataInputStream input, Path p, Replication.Status status, long sizeLimit, String remoteTableId, TCredentials tcreds, Set<Integer> tids) {
        this.ars = ars;
        this.target = target;
        this.input = input;
        this.p = p;
        this.status = status;
        this.sizeLimit = sizeLimit;
        this.remoteTableId = remoteTableId;
        this.tcreds = tcreds;
        this.tids = tids;
    }

    public ReplicationStats execute(ReplicationServicer.Client client) throws TException {
        WalReplication edits = this.ars.getWalEdits(this.target, this.input, this.p, this.status, this.sizeLimit, this.tids);
        log.debug("Read {} WAL entries and retained {} bytes of WAL entries for replication to peer '{}'", new Object[]{edits.entriesConsumed == Long.MAX_VALUE ? "all remaining" : Long.valueOf(edits.entriesConsumed), edits.sizeInBytes, this.p});
        if (edits.walEdits.getEditsSize() > 0) {
            log.debug("Sending {} edits", (Object)edits.walEdits.getEditsSize());
            long entriesReplicated = client.replicateLog(this.remoteTableId, edits.walEdits, this.tcreds);
            if (entriesReplicated == edits.numUpdates) {
                log.debug("Replicated {} edits", (Object)entriesReplicated);
            } else {
                log.warn("Sent {} WAL entries for replication but {} were reported as replicated", (Object)edits.numUpdates, (Object)entriesReplicated);
            }
            return edits;
        }
        if (edits.entriesConsumed > 0L) {
            return edits;
        }
        return new ReplicationStats(0L, 0L, 0L);
    }
}

