/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.jline.reader.LineReader;

public class ConfigCommand
extends Shell.Command {
    private Option tableOpt;
    private Option deleteOpt;
    private Option setOpt;
    private Option forceOpt;
    private Option filterOpt;
    private Option filterWithValuesOpt;
    private Option disablePaginationOpt;
    private Option outputFileOpt;
    private Option namespaceOpt;
    private int COL1 = 10;
    private int COL2 = 7;
    private LineReader reader;

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        Token cmd = new Token(this.getName());
        Token sub = new Token("-" + this.setOpt.getOpt());
        for (Property p : Property.values()) {
            if (p.getKey().endsWith(".") || p.isExperimental()) continue;
            sub.addSubcommand(new Token(p.toString()));
        }
        cmd.addSubcommand(sub);
        root.addSubcommand(cmd);
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, NamespaceNotFoundException {
        this.reader = shellState.getReader();
        boolean force = cl.hasOption(this.forceOpt);
        String tableName = cl.getOptionValue(this.tableOpt.getOpt());
        if (tableName != null && !shellState.getAccumuloClient().tableOperations().exists(tableName)) {
            throw new TableNotFoundException(null, tableName, null);
        }
        String namespace = cl.getOptionValue(this.namespaceOpt.getOpt());
        if (namespace != null && !shellState.getAccumuloClient().namespaceOperations().exists(namespace)) {
            throw new NamespaceNotFoundException(null, namespace, null);
        }
        if (cl.hasOption(this.deleteOpt.getOpt())) {
            String property = cl.getOptionValue(this.deleteOpt.getOpt());
            if (property.contains("=")) {
                throw new BadArgumentException("Invalid '=' operator in delete operation.", fullCommand, fullCommand.indexOf(61));
            }
            String invalidTablePropFormatString = "Invalid per-table property : {}, still removing from zookeeper if it's there.";
            if (tableName != null) {
                if (!Property.isValidTablePropertyKey((String)property)) {
                    Shell.log.warn(invalidTablePropFormatString, (Object)property);
                }
                shellState.getAccumuloClient().tableOperations().removeProperty(tableName, property);
                Shell.log.debug("Successfully deleted table configuration option.");
            } else if (namespace != null) {
                if (!Property.isValidTablePropertyKey((String)property)) {
                    Shell.log.warn(invalidTablePropFormatString, (Object)property);
                }
                shellState.getAccumuloClient().namespaceOperations().removeProperty(namespace, property);
                Shell.log.debug("Successfully deleted namespace configuration option.");
            } else {
                if (!Property.isValidZooPropertyKey((String)property)) {
                    Shell.log.warn(invalidTablePropFormatString, (Object)property);
                }
                shellState.getAccumuloClient().instanceOperations().removeProperty(property);
                Shell.log.debug("Successfully deleted system configuration option.");
            }
        } else if (cl.hasOption(this.setOpt.getOpt())) {
            String property = cl.getOptionValue(this.setOpt.getOpt());
            if (!property.contains("=")) {
                throw new BadArgumentException("Missing '=' operator in set operation.", fullCommand, fullCommand.indexOf(property));
            }
            String[] pair = property.split("=", 2);
            property = pair[0];
            String value = pair[1];
            Property theProp = Property.getPropertyByKey((String)property);
            if (theProp != null && theProp.isDeprecated() && !force && !shellState.confirm("Trying to set deprecated property `" + property + "` continue").orElse(false).booleanValue()) {
                throw new BadArgumentException("Tried to set deprecated property and force not specified.", fullCommand, fullCommand.indexOf(property));
            }
            if (tableName != null) {
                if (!Property.isValidTablePropertyKey((String)property)) {
                    throw new BadArgumentException("Invalid per-table property.", fullCommand, fullCommand.indexOf(property));
                }
                if (property.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    new ColumnVisibility(value);
                }
                shellState.getAccumuloClient().tableOperations().setProperty(tableName, property, value);
                Shell.log.debug("Successfully set table configuration option.");
            } else if (namespace != null) {
                if (!Property.isValidTablePropertyKey((String)property)) {
                    throw new BadArgumentException("Invalid per-table property.", fullCommand, fullCommand.indexOf(property));
                }
                if (property.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    new ColumnVisibility(value);
                }
                shellState.getAccumuloClient().namespaceOperations().setProperty(namespace, property, value);
                Shell.log.debug("Successfully set table configuration option.");
            } else {
                if (!Property.isValidZooPropertyKey((String)property)) {
                    throw new BadArgumentException("Property cannot be modified in zookeeper", fullCommand, fullCommand.indexOf(property));
                }
                shellState.getAccumuloClient().instanceOperations().setProperty(property, value);
                Shell.log.debug("Successfully set system configuration option.");
            }
        } else {
            Map acuconf;
            boolean warned = false;
            TreeMap systemConfig = new TreeMap();
            try {
                systemConfig.putAll(shellState.getAccumuloClient().instanceOperations().getSystemConfiguration());
            }
            catch (AccumuloSecurityException e) {
                if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) {
                    Shell.log.warn("User unable to retrieve system configuration (requires System.SYSTEM permission)");
                    warned = true;
                }
                throw e;
            }
            String outputFile = cl.getOptionValue(this.outputFileOpt.getOpt());
            Shell.PrintFile printFile = outputFile == null ? null : new Shell.PrintFile(outputFile);
            TreeMap siteConfig = new TreeMap();
            try {
                siteConfig.putAll(shellState.getAccumuloClient().instanceOperations().getSiteConfiguration());
            }
            catch (AccumuloSecurityException e) {
                if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) {
                    Shell.log.warn("User unable to retrieve site configuration (requires System.SYSTEM permission)");
                    warned = true;
                }
                throw e;
            }
            TreeMap<String, String> defaults = new TreeMap<String, String>();
            for (Map.Entry defaultEntry : DefaultConfiguration.getInstance()) {
                defaults.put((String)defaultEntry.getKey(), (String)defaultEntry.getValue());
            }
            TreeMap namespaceConfig = new TreeMap();
            if (tableName != null) {
                String n = Namespaces.getNamespaceName((ClientContext)shellState.getContext(), (NamespaceId)shellState.getContext().getNamespaceId(shellState.getContext().getTableId(tableName)));
                try {
                    namespaceConfig.putAll(shellState.getAccumuloClient().namespaceOperations().getConfiguration(n));
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) {
                        Shell.log.warn("User unable to retrieve {} namespace configuration (requires Namespace.ALTER_NAMESPACE permission)", (Object)(StringUtils.isEmpty((CharSequence)n) ? "default" : n));
                        warned = true;
                    }
                    throw e;
                }
            }
            if ((acuconf = systemConfig).isEmpty()) {
                acuconf = defaults;
            }
            if (tableName != null) {
                if (warned) {
                    Shell.log.warn("User does not have permission to see entire configuration heirarchy. Property values shown below may be set above the table level.");
                }
                try {
                    acuconf = shellState.getAccumuloClient().tableOperations().getConfiguration(tableName);
                }
                catch (AccumuloException e) {
                    AccumuloSecurityException ase;
                    if (e.getCause() != null && e.getCause() instanceof AccumuloSecurityException && (ase = (AccumuloSecurityException)e.getCause()).getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) {
                        Shell.log.error("User unable to retrieve {} table configuration (requires Table.ALTER_TABLE permission)", (Object)tableName);
                    }
                    throw e;
                }
            }
            if (namespace != null) {
                if (warned) {
                    Shell.log.warn("User does not have permission to see entire configuration heirarchy. Property values shown below may be set above the namespace level.");
                }
                try {
                    acuconf = shellState.getAccumuloClient().namespaceOperations().getConfiguration(namespace);
                }
                catch (AccumuloSecurityException e) {
                    Shell.log.error("User unable to retrieve {} namespace configuration (requires Namespace.ALTER_NAMESPACE permission)", (Object)(StringUtils.isEmpty((CharSequence)namespace) ? "default" : namespace));
                    throw e;
                }
            }
            ImmutableSortedMap sortedConf = ImmutableSortedMap.copyOf(acuconf);
            for (Map.Entry propEntry : acuconf.entrySet()) {
                String value;
                String key = (String)propEntry.getKey();
                if (this.matchTheFilterText(cl, key, value = (String)propEntry.getValue()) || (tableName != null || namespace != null) && !Property.isValidTablePropertyKey((String)key)) continue;
                this.COL2 = Math.max(this.COL2, ((String)propEntry.getKey()).length() + 3);
            }
            ArrayList<String> output = new ArrayList<String>();
            this.printConfHeader(output);
            for (Map.Entry propEntry : sortedConf.entrySet()) {
                String value;
                String key = (String)propEntry.getKey();
                if (this.matchTheFilterText(cl, key, value = (String)propEntry.getValue()) || (tableName != null || namespace != null) && !Property.isValidTablePropertyKey((String)key)) continue;
                String siteVal = (String)siteConfig.get(key);
                String sysVal = (String)systemConfig.get(key);
                String curVal = (String)propEntry.getValue();
                String dfault = (String)defaults.get(key);
                String nspVal = (String)namespaceConfig.get(key);
                boolean printed = false;
                if (sysVal != null) {
                    if (dfault != null && key.toLowerCase().contains("password")) {
                        dfault = curVal = curVal.replaceAll(".", "*");
                        sysVal = curVal;
                        siteVal = curVal;
                    }
                    if (defaults.containsKey(key) && !Property.getPropertyByKey((String)key).isExperimental()) {
                        this.printConfLine(output, "default", key, dfault);
                        printed = true;
                    }
                    if (!defaults.containsKey(key) || !((String)defaults.get(key)).equals(siteVal)) {
                        this.printConfLine(output, "site", printed ? "   @override" : key, siteVal == null ? "" : siteVal);
                        printed = true;
                    }
                    if (!siteConfig.containsKey(key) || !Objects.equals(siteVal, sysVal)) {
                        this.printConfLine(output, "system", printed ? "   @override" : key, sysVal);
                        printed = true;
                    }
                }
                if (nspVal != null) {
                    if (sysVal == null && dfault != null && !dfault.equals(nspVal) && !Property.getPropertyByKey((String)key).isExperimental()) {
                        this.printConfLine(output, "default", key, dfault);
                        printed = true;
                    }
                    if (!systemConfig.containsKey(key) || !Objects.equals(sysVal, nspVal)) {
                        this.printConfLine(output, "namespace", printed ? "   @override" : key, nspVal);
                        printed = true;
                    }
                }
                if (tableName != null && !curVal.equals(nspVal)) {
                    if (nspVal == null && dfault != null && !dfault.equals(curVal) && !Property.getPropertyByKey((String)key).isExperimental()) {
                        this.printConfLine(output, "default", key, dfault);
                        printed = true;
                    }
                    this.printConfLine(output, "table", printed ? "   @override" : key, curVal);
                    continue;
                }
                if (namespace == null || curVal.equals(sysVal)) continue;
                if (sysVal == null && dfault != null && !dfault.equals(curVal) && !Property.getPropertyByKey((String)key).isExperimental()) {
                    this.printConfLine(output, "default", key, dfault);
                    printed = true;
                }
                this.printConfLine(output, "namespace", printed ? "   @override" : key, curVal);
            }
            this.printConfFooter(output);
            shellState.printLines(output.iterator(), !cl.hasOption(this.disablePaginationOpt.getOpt()), printFile);
            if (printFile != null) {
                printFile.close();
            }
        }
        return 0;
    }

    private boolean matchTheFilterText(CommandLine cl, String key, String value) {
        if (cl.hasOption(this.filterOpt.getOpt()) && !key.contains(cl.getOptionValue(this.filterOpt.getOpt()))) {
            return true;
        }
        return cl.hasOption(this.filterWithValuesOpt.getOpt()) && !key.contains(cl.getOptionValue(this.filterWithValuesOpt.getOpt())) && !value.contains(cl.getOptionValue(this.filterWithValuesOpt.getOpt()));
    }

    private void printConfHeader(List<String> output) {
        this.printConfFooter(output);
        output.add(String.format("%-" + this.COL1 + "s | %-" + this.COL2 + "s | %s", "SCOPE", "NAME", "VALUE"));
        this.printConfFooter(output);
    }

    private void printConfLine(List<String> output, String s1, String s2, String s3) {
        if (((String)s2).length() < this.COL2) {
            s2 = (String)s2 + " " + Shell.repeat(".", this.COL2 - ((String)s2).length() - 1);
        }
        output.add(String.format("%-" + this.COL1 + "s | %-" + this.COL2 + "s | %s", s1, s2, s3.replace("\n", "\n" + Shell.repeat(" ", this.COL1 + 1) + "|" + Shell.repeat(" ", this.COL2 + 2) + "| ")));
    }

    private void printConfFooter(List<String> output) {
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.reader.getTerminal().getWidth() - this.COL1 - this.COL2 - 6));
        output.add(String.format("%" + this.COL1 + "s-+-%" + this.COL2 + "s-+-%-" + col3 + "s", Shell.repeat("-", this.COL1), Shell.repeat("-", this.COL2), Shell.repeat("-", col3)));
    }

    @Override
    public String description() {
        return "prints system properties and table specific properties";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup og = new OptionGroup();
        OptionGroup tgroup = new OptionGroup();
        this.tableOpt = new Option("t", "table", true, "table to display/set/delete properties for");
        this.deleteOpt = new Option("d", "delete", true, "delete a per-table property");
        this.setOpt = new Option("s", "set", true, "set a per-table property");
        this.forceOpt = new Option("force", "force", false, "used with set to set a deprecated property without asking");
        this.filterOpt = new Option("f", "filter", true, "show only properties that contain this string in their name.");
        this.filterWithValuesOpt = new Option("fv", "filter-with-values", true, "show only properties that contain this string in their name or value");
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disables pagination of output");
        this.outputFileOpt = new Option("o", "output", true, "local file to write the scan output to");
        this.namespaceOpt = new Option("ns", "namespace", true, "namespace to display/set/delete properties for");
        this.tableOpt.setArgName("table");
        this.deleteOpt.setArgName("property");
        this.setOpt.setArgName("property=value");
        this.filterOpt.setArgName("string");
        this.filterWithValuesOpt.setArgName("string");
        this.outputFileOpt.setArgName("file");
        this.namespaceOpt.setArgName("namespace");
        og.addOption(this.deleteOpt);
        og.addOption(this.setOpt);
        og.addOption(this.filterOpt);
        og.addOption(this.filterWithValuesOpt);
        tgroup.addOption(this.tableOpt);
        tgroup.addOption(this.namespaceOpt);
        o.addOptionGroup(tgroup);
        o.addOptionGroup(og);
        o.addOption(this.disablePaginationOpt);
        o.addOption(this.outputFileOpt);
        o.addOption(this.forceOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

