/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.TConstraintViolationSummary;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.format.FormatterFactory;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.shell.ShellCompletor;
import org.apache.accumulo.shell.ShellOptions;
import org.apache.accumulo.shell.ShellOptionsJC;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.AboutCommand;
import org.apache.accumulo.shell.commands.AddAuthsCommand;
import org.apache.accumulo.shell.commands.AddSplitsCommand;
import org.apache.accumulo.shell.commands.AuthenticateCommand;
import org.apache.accumulo.shell.commands.ByeCommand;
import org.apache.accumulo.shell.commands.ClasspathCommand;
import org.apache.accumulo.shell.commands.ClearCommand;
import org.apache.accumulo.shell.commands.CloneTableCommand;
import org.apache.accumulo.shell.commands.ClsCommand;
import org.apache.accumulo.shell.commands.CompactCommand;
import org.apache.accumulo.shell.commands.ConfigCommand;
import org.apache.accumulo.shell.commands.ConstraintCommand;
import org.apache.accumulo.shell.commands.CreateNamespaceCommand;
import org.apache.accumulo.shell.commands.CreateTableCommand;
import org.apache.accumulo.shell.commands.CreateUserCommand;
import org.apache.accumulo.shell.commands.DUCommand;
import org.apache.accumulo.shell.commands.DebugCommand;
import org.apache.accumulo.shell.commands.DeleteAuthsCommand;
import org.apache.accumulo.shell.commands.DeleteCommand;
import org.apache.accumulo.shell.commands.DeleteIterCommand;
import org.apache.accumulo.shell.commands.DeleteManyCommand;
import org.apache.accumulo.shell.commands.DeleteNamespaceCommand;
import org.apache.accumulo.shell.commands.DeleteRowsCommand;
import org.apache.accumulo.shell.commands.DeleteScanIterCommand;
import org.apache.accumulo.shell.commands.DeleteShellIterCommand;
import org.apache.accumulo.shell.commands.DeleteTableCommand;
import org.apache.accumulo.shell.commands.DeleteUserCommand;
import org.apache.accumulo.shell.commands.DropTableCommand;
import org.apache.accumulo.shell.commands.DropUserCommand;
import org.apache.accumulo.shell.commands.EGrepCommand;
import org.apache.accumulo.shell.commands.ExecfileCommand;
import org.apache.accumulo.shell.commands.ExitCommand;
import org.apache.accumulo.shell.commands.ExportTableCommand;
import org.apache.accumulo.shell.commands.ExtensionCommand;
import org.apache.accumulo.shell.commands.FateCommand;
import org.apache.accumulo.shell.commands.FlushCommand;
import org.apache.accumulo.shell.commands.FormatterCommand;
import org.apache.accumulo.shell.commands.GetAuthsCommand;
import org.apache.accumulo.shell.commands.GetGroupsCommand;
import org.apache.accumulo.shell.commands.GetSplitsCommand;
import org.apache.accumulo.shell.commands.GrantCommand;
import org.apache.accumulo.shell.commands.GrepCommand;
import org.apache.accumulo.shell.commands.HelpCommand;
import org.apache.accumulo.shell.commands.HiddenCommand;
import org.apache.accumulo.shell.commands.HistoryCommand;
import org.apache.accumulo.shell.commands.ImportDirectoryCommand;
import org.apache.accumulo.shell.commands.ImportTableCommand;
import org.apache.accumulo.shell.commands.InfoCommand;
import org.apache.accumulo.shell.commands.InsertCommand;
import org.apache.accumulo.shell.commands.InterpreterCommand;
import org.apache.accumulo.shell.commands.ListBulkCommand;
import org.apache.accumulo.shell.commands.ListCompactionsCommand;
import org.apache.accumulo.shell.commands.ListIterCommand;
import org.apache.accumulo.shell.commands.ListScansCommand;
import org.apache.accumulo.shell.commands.ListShellIterCommand;
import org.apache.accumulo.shell.commands.ListTabletsCommand;
import org.apache.accumulo.shell.commands.MaxRowCommand;
import org.apache.accumulo.shell.commands.MergeCommand;
import org.apache.accumulo.shell.commands.NamespacePermissionsCommand;
import org.apache.accumulo.shell.commands.NamespacesCommand;
import org.apache.accumulo.shell.commands.NoTableCommand;
import org.apache.accumulo.shell.commands.OfflineCommand;
import org.apache.accumulo.shell.commands.OnlineCommand;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.PasswdCommand;
import org.apache.accumulo.shell.commands.PingCommand;
import org.apache.accumulo.shell.commands.QuestionCommand;
import org.apache.accumulo.shell.commands.QuitCommand;
import org.apache.accumulo.shell.commands.QuotedStringTokenizer;
import org.apache.accumulo.shell.commands.RenameNamespaceCommand;
import org.apache.accumulo.shell.commands.RenameTableCommand;
import org.apache.accumulo.shell.commands.RevokeCommand;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.accumulo.shell.commands.ScriptCommand;
import org.apache.accumulo.shell.commands.SetAuthsCommand;
import org.apache.accumulo.shell.commands.SetGroupsCommand;
import org.apache.accumulo.shell.commands.SetIterCommand;
import org.apache.accumulo.shell.commands.SetScanIterCommand;
import org.apache.accumulo.shell.commands.SetShellIterCommand;
import org.apache.accumulo.shell.commands.SleepCommand;
import org.apache.accumulo.shell.commands.SummariesCommand;
import org.apache.accumulo.shell.commands.SystemPermissionsCommand;
import org.apache.accumulo.shell.commands.TableCommand;
import org.apache.accumulo.shell.commands.TablePermissionsCommand;
import org.apache.accumulo.shell.commands.TablesCommand;
import org.apache.accumulo.shell.commands.TraceCommand;
import org.apache.accumulo.shell.commands.UserCommand;
import org.apache.accumulo.shell.commands.UserPermissionsCommand;
import org.apache.accumulo.shell.commands.UsersCommand;
import org.apache.accumulo.shell.commands.WhoAmICommand;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class Shell
extends ShellOptions
implements KeywordExecutable {
    public static final Logger log = LoggerFactory.getLogger(Shell.class);
    private static final Logger audit = LoggerFactory.getLogger((String)(Shell.class.getName() + ".audit"));
    private static final Predicate<String> IS_HELP_OPT = s -> s != null && (s.equals("-?") || s.equals("--help"));
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    public static final int NO_FIXED_ARG_LENGTH_CHECK = -1;
    public static final String COMMENT_PREFIX = "#";
    public static final String HISTORY_DIR_NAME = ".accumulo";
    public static final String HISTORY_FILE_NAME = "shell_history.txt";
    private static final String SHELL_DESCRIPTION = "Shell - Apache Accumulo Interactive Shell";
    protected int exitCode = 0;
    private String tableName;
    private AccumuloClient accumuloClient;
    private Properties clientProperties = new Properties();
    private ClientContext context;
    protected LineReader reader;
    protected Terminal terminal;
    protected PrintWriter writer;
    private final Class<? extends Formatter> defaultFormatterClass = DefaultFormatter.class;
    public Map<String, List<IteratorSetting>> scanIteratorOptions = new HashMap<String, List<IteratorSetting>>();
    public Map<String, List<IteratorSetting>> iteratorProfiles = new HashMap<String, List<IteratorSetting>>();
    private Token rootToken;
    public final Map<String, Command> commandFactory = new TreeMap<String, Command>();
    public final Map<String, Command[]> commandGrouping = new TreeMap<String, Command[]>();
    private boolean exit = false;
    protected File execFile = null;
    protected String execCommand = null;
    protected boolean verbose = true;
    private boolean tabCompletion;
    private boolean disableAuthTimeout;
    private long authTimeout;
    private long lastUserActivity = System.nanoTime();
    private boolean logErrorsToConsole = false;
    private boolean askAgain = false;
    private boolean usedClientProps = false;

    public Shell() {
    }

    public Shell(LineReader reader) {
        this.reader = reader;
        this.terminal = reader.getTerminal();
        this.writer = this.terminal.writer();
    }

    protected boolean authenticateUser(AccumuloClient client, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return client.securityOperations().authenticateUser(client.whoami(), token);
    }

    private AuthenticationToken getAuthenticationToken(String principal, String authenticationString, String passwordPrompt) {
        AuthenticationToken token = null;
        if (authenticationString == null && this.clientProperties.containsKey(ClientProperty.AUTH_TOKEN.getKey()) && principal.equals(ClientProperty.AUTH_PRINCIPAL.getValue(this.clientProperties))) {
            token = ClientProperty.getAuthenticationToken((Properties)this.clientProperties);
            this.usedClientProps = true;
        }
        if (token == null || this.askAgain) {
            this.usedClientProps = false;
            if ("stdin".equals(authenticationString) || authenticationString == null) {
                authenticationString = this.reader.readLine(passwordPrompt, Character.valueOf('*'));
            }
            if (authenticationString == null) {
                throw new ParameterException("No password or token option supplied");
            }
            token = new PasswordToken((CharSequence)authenticationString);
        }
        return token;
    }

    public boolean config(String ... args) throws IOException {
        if (this.terminal == null) {
            this.terminal = TerminalBuilder.builder().jansi(false).build();
        }
        if (this.reader == null) {
            this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        }
        this.writer = this.terminal.writer();
        ShellOptionsJC options = new ShellOptionsJC();
        JCommander jc = new JCommander();
        jc.setProgramName("accumulo shell");
        jc.addObject((Object)options);
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            jc.usage();
            this.exitCode = 1;
            return false;
        }
        if (options.isHelpEnabled()) {
            jc.usage();
            this.exitCode = 0;
            return false;
        }
        if (options.getUnrecognizedOptions() != null) {
            this.logError("Unrecognized Options: " + options.getUnrecognizedOptions());
            jc.usage();
            this.exitCode = 1;
            return false;
        }
        if (options.isDebugEnabled()) {
            log.warn("Configure debugging through your logging configuration file");
        }
        this.authTimeout = TimeUnit.MINUTES.toNanos(options.getAuthTimeout());
        this.disableAuthTimeout = options.isAuthTimeoutDisabled();
        this.clientProperties = options.getClientProperties();
        if (ClientProperty.SASL_ENABLED.getBoolean(this.clientProperties)) {
            log.debug("SASL is enabled, disabling authorization timeout");
            this.disableAuthTimeout = true;
        }
        this.tabCompletion = !options.isTabCompletionDisabled();
        this.setTableName("");
        if (this.accumuloClient == null) {
            String principal;
            if (ClientProperty.INSTANCE_ZOOKEEPERS.isEmpty(this.clientProperties)) {
                throw new IllegalArgumentException("ZooKeepers must be set using -z or -zh on command line or in accumulo-client.properties");
            }
            if (ClientProperty.INSTANCE_NAME.isEmpty(this.clientProperties)) {
                throw new IllegalArgumentException("Instance name must be set using -z or -zi on command line or in accumulo-client.properties");
            }
            try {
                principal = options.getUsername();
            }
            catch (Exception e) {
                this.logError(e.getMessage());
                this.exitCode = 1;
                return false;
            }
            String authenticationString = options.getPassword();
            AuthenticationToken token = this.getAuthenticationToken(principal, authenticationString, "Password: ");
            try {
                this.setTableName("");
                this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(this.clientProperties).as((CharSequence)principal, token).build();
                this.authenticateUser(this.accumuloClient, token);
                this.context = (ClientContext)this.accumuloClient;
            }
            catch (Exception e) {
                this.printException(e);
                this.exitCode = 1;
                return false;
            }
        }
        if (options.getExecFile() != null) {
            this.execFile = options.getExecFile();
            this.verbose = false;
        } else if (options.getExecFileVerbose() != null) {
            this.execFile = options.getExecFileVerbose();
            this.verbose = true;
        }
        this.execCommand = options.getExecCommand();
        if (this.execCommand != null) {
            this.verbose = false;
        }
        this.rootToken = new Token();
        Command[] dataCommands = new Command[]{new DeleteCommand(), new DeleteManyCommand(), new DeleteRowsCommand(), new EGrepCommand(), new FormatterCommand(), new InterpreterCommand(), new GrepCommand(), new ImportDirectoryCommand(), new InsertCommand(), new MaxRowCommand(), new ScanCommand()};
        Command[] debuggingCommands = new Command[]{new ClasspathCommand(), new DebugCommand(), new ListScansCommand(), new ListCompactionsCommand(), new TraceCommand(), new PingCommand(), new ListBulkCommand(), new ListTabletsCommand()};
        Command[] execCommands = new Command[]{new ExecfileCommand(), new HistoryCommand(), new ExtensionCommand(), new ScriptCommand()};
        Command[] exitCommands = new Command[]{new ByeCommand(), new ExitCommand(), new QuitCommand()};
        Command[] helpCommands = new Command[]{new AboutCommand(), new HelpCommand(), new InfoCommand(), new QuestionCommand()};
        Command[] iteratorCommands = new Command[]{new DeleteIterCommand(), new DeleteScanIterCommand(), new ListIterCommand(), new SetIterCommand(), new SetScanIterCommand(), new SetShellIterCommand(), new ListShellIterCommand(), new DeleteShellIterCommand()};
        Command[] otherCommands = new Command[]{new HiddenCommand()};
        Command[] permissionsCommands = new Command[]{new GrantCommand(), new RevokeCommand(), new SystemPermissionsCommand(), new TablePermissionsCommand(), new UserPermissionsCommand(), new NamespacePermissionsCommand()};
        Command[] stateCommands = new Command[]{new AuthenticateCommand(), new ClsCommand(), new ClearCommand(), new FateCommand(), new NoTableCommand(), new SleepCommand(), new TableCommand(), new UserCommand(), new WhoAmICommand()};
        Command[] tableCommands = new Command[]{new CloneTableCommand(), new ConfigCommand(), new CreateTableCommand(), new DeleteTableCommand(), new DropTableCommand(), new DUCommand(), new ExportTableCommand(), new ImportTableCommand(), new OfflineCommand(), new OnlineCommand(), new RenameTableCommand(), new TablesCommand(), new NamespacesCommand(), new CreateNamespaceCommand(), new DeleteNamespaceCommand(), new RenameNamespaceCommand(), new SummariesCommand()};
        Command[] tableControlCommands = new Command[]{new AddSplitsCommand(), new CompactCommand(), new ConstraintCommand(), new FlushCommand(), new GetGroupsCommand(), new GetSplitsCommand(), new MergeCommand(), new SetGroupsCommand()};
        Command[] userCommands = new Command[]{new AddAuthsCommand(), new CreateUserCommand(), new DeleteUserCommand(), new DropUserCommand(), new GetAuthsCommand(), new PasswdCommand(), new SetAuthsCommand(), new UsersCommand(), new DeleteAuthsCommand()};
        this.commandGrouping.put("-- Writing, Reading, and Removing Data --", dataCommands);
        this.commandGrouping.put("-- Debugging Commands -------------------", debuggingCommands);
        this.commandGrouping.put("-- Shell Execution Commands -------------", execCommands);
        this.commandGrouping.put("-- Exiting Commands ---------------------", exitCommands);
        this.commandGrouping.put("-- Help Commands ------------------------", helpCommands);
        this.commandGrouping.put("-- Iterator Configuration ---------------", iteratorCommands);
        this.commandGrouping.put("-- Permissions Administration Commands --", permissionsCommands);
        this.commandGrouping.put("-- Shell State Commands -----------------", stateCommands);
        this.commandGrouping.put("-- Table Administration Commands --------", tableCommands);
        this.commandGrouping.put("-- Table Control Commands ---------------", tableControlCommands);
        this.commandGrouping.put("-- User Administration Commands ---------", userCommands);
        for (Command[] cmds : this.commandGrouping.values()) {
            for (Command cmd : cmds) {
                this.commandFactory.put(cmd.getName(), cmd);
            }
        }
        for (Command cmd : otherCommands) {
            this.commandFactory.put(cmd.getName(), cmd);
        }
        return true;
    }

    public AccumuloClient getAccumuloClient() {
        return this.accumuloClient;
    }

    public ClassLoader getClassLoader(CommandLine cl, Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Map tableProps;
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        if (namespaces) {
            try {
                tableProps = shellState.getAccumuloClient().namespaceOperations().getConfiguration(OptUtil.getNamespaceOpt(cl, shellState));
            }
            catch (NamespaceNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (tables) {
            tableProps = shellState.getAccumuloClient().tableOperations().getConfiguration(OptUtil.getTableOpt(cl, shellState));
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        String tableContext = Shell.getTableContextFromProps(tableProps);
        if (tableContext != null && !tableContext.isEmpty()) {
            ClassLoaderUtil.initContextFactory((AccumuloConfiguration)new ConfigurationCopy(shellState.getAccumuloClient().instanceOperations().getSystemConfiguration()));
        }
        return ClassLoaderUtil.getClassLoader((String)tableContext);
    }

    private static String getTableContextFromProps(Map<String, String> props) {
        String tableContext = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getKey().equals(Property.TABLE_CLASSLOADER_CONTEXT.getKey()) && entry.getValue() != null && !entry.getValue().isEmpty()) {
                return entry.getValue();
            }
            Property TABLE_CLASSPATH = Property.TABLE_CLASSPATH;
            if (!entry.getKey().equals(TABLE_CLASSPATH.getKey()) || (tableContext = entry.getValue()) == null || tableContext.isEmpty()) continue;
            log.warn("Deprecated table context property detected. '{}' should be replaced by '{}'", (Object)TABLE_CLASSPATH.getKey(), (Object)Property.TABLE_CLASSLOADER_CONTEXT.getKey());
        }
        return tableContext;
    }

    public String keyword() {
        return "shell";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Runs Accumulo shell";
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() from a main class is okay")
    public void execute(String[] args) throws IOException {
        try {
            if (!this.config(args)) {
                System.exit(this.getExitCode());
            }
            System.exit(this.start());
        }
        finally {
            this.shutdown();
        }
    }

    public static void main(String[] args) throws IOException {
        LineReader reader = LineReaderBuilder.builder().build();
        new Shell(reader).execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user-provided paths intentional")
    public int start() throws IOException {
        String home;
        if (this.isVerbose()) {
            this.printInfo();
        }
        if ((home = System.getProperty("HOME")) == null) {
            home = System.getenv("HOME");
        }
        String configDir = home + "/.accumulo";
        String historyPath = configDir + "/shell_history.txt";
        File accumuloDir = new File(configDir);
        if (!accumuloDir.exists() && !accumuloDir.mkdirs()) {
            log.warn("Unable to make directory for history at {}", (Object)accumuloDir);
        }
        this.reader.unsetOpt(LineReader.Option.DISABLE_HIGHLIGHTER);
        this.reader.unsetOpt(LineReader.Option.BRACKETED_PASTE);
        this.reader.unsetOpt(LineReader.Option.HISTORY_TIMESTAMPED);
        this.reader.setVariable("history-file", (Object)new File(historyPath));
        Thread executeThread = Thread.currentThread();
        this.terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
        if (this.execFile != null) {
            try (Scanner scanner = new Scanner(this.execFile, StandardCharsets.UTF_8);){
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split("\n")) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (true) {
            try {
                if (this.hasExited()) {
                    int scanner = this.exitCode;
                    return scanner;
                }
                if (this.tabCompletion) {
                    ShellCompletor userCompletor = this.setupCompletion();
                    ((LineReaderImpl)this.reader).setCompleter((Completer)userCompletor);
                }
                String input = this.reader.readLine(this.getDefaultPrompt());
                this.execCommand(input, this.disableAuthTimeout, false);
                continue;
            }
            catch (UserInterruptException uie) {
                this.writer.println();
                String partialLine = uie.getPartialLine();
                if (partialLine != null && !partialLine.trim().isEmpty()) continue;
                int n = this.exitCode;
                return n;
            }
            catch (EndOfFileException efe) {
                this.writer.println();
                int n = this.exitCode;
                return n;
            }
            finally {
                this.writer.flush();
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.reader != null) {
            try {
                this.terminal.close();
                this.reader = null;
            }
            catch (IOException e) {
                this.printException(e);
            }
        }
        if (this.accumuloClient != null) {
            this.accumuloClient.close();
        }
    }

    public void printInfo() {
        ClientInfo info = ClientInfo.from((Properties)this.accumuloClient.properties());
        this.writer.print("\nShell - Apache Accumulo Interactive Shell\n- \n- version: 2.1.3\n- instance name: " + info.getInstanceName() + "\n- instance id: " + this.accumuloClient.instanceOperations().getInstanceId() + "\n- \n- type 'help' for a list of available commands\n- \n");
        this.writer.flush();
    }

    public void printVerboseInfo() {
        StringBuilder sb = new StringBuilder("-\n");
        sb.append("- Current user: ").append(this.accumuloClient.whoami()).append("\n");
        if (this.execFile != null) {
            sb.append("- Executing commands from: ").append(this.execFile).append("\n");
        }
        if (this.disableAuthTimeout) {
            sb.append("- Authorization timeout: disabled\n");
        } else {
            sb.append("- Authorization timeout: ").append(String.format("%ds%n", TimeUnit.NANOSECONDS.toSeconds(this.authTimeout)));
        }
        if (!this.scanIteratorOptions.isEmpty()) {
            for (Map.Entry<String, List<IteratorSetting>> entry : this.scanIteratorOptions.entrySet()) {
                sb.append("- Session scan iterators for table ").append(entry.getKey()).append(":\n");
                for (IteratorSetting setting : entry.getValue()) {
                    sb.append("-    Iterator ").append(setting.getName()).append(" options:\n");
                    sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                    sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                    for (Map.Entry optEntry : setting.getOptions().entrySet()) {
                        sb.append("-        ").append((String)optEntry.getKey()).append(" = ").append((String)optEntry.getValue()).append("\n");
                    }
                }
            }
        }
        sb.append("-\n");
        this.writer.print(sb);
    }

    public String getDefaultPrompt() {
        Objects.requireNonNull(this.accumuloClient);
        ClientInfo info = ClientInfo.from((Properties)this.accumuloClient.properties());
        return this.accumuloClient.whoami() + "@" + info.getInstanceName() + (this.getTableName().isEmpty() ? "" : " ") + this.getTableName() + "> ";
    }

    private String sanitize(String msg) {
        return msg.replaceAll("[\r\n]", "");
    }

    public void execCommand(String input, boolean ignoreAuthTimeout, boolean echoPrompt) {
        String[] fields;
        audit.info("{}", (Object)this.sanitize(this.getDefaultPrompt() + input));
        if (echoPrompt) {
            this.writer.print(this.getDefaultPrompt());
            this.writer.println(input);
        }
        if (input.startsWith(COMMENT_PREFIX)) {
            return;
        }
        try {
            fields = new QuotedStringTokenizer(input).getTokens();
        }
        catch (BadArgumentException e) {
            this.printException((Exception)((Object)e));
            ++this.exitCode;
            return;
        }
        if (fields.length == 0) {
            return;
        }
        String command = fields[0];
        fields = fields.length > 1 ? Arrays.copyOfRange(fields, 1, fields.length) : new String[]{};
        Command sc = null;
        if (command.isEmpty()) {
            ++this.exitCode;
            this.printException((Exception)((Object)new BadArgumentException("Unrecognized empty command", command, -1)));
        } else {
            try {
                sc = this.commandFactory.get(command);
                if (sc == null) {
                    this.writer.println(String.format("Unknown command \"%s\".  Enter \"help\" for a list possible commands.", command));
                    this.writer.flush();
                    return;
                }
                long duration = System.nanoTime() - this.lastUserActivity;
                if (!(sc instanceof ExitCommand || ignoreAuthTimeout || duration >= 0L && duration <= this.authTimeout)) {
                    this.writer.println("Shell has been idle for too long. Please re-authenticate.");
                    boolean authFailed = true;
                    do {
                        AuthenticationToken authToken = this.getAuthenticationToken(this.accumuloClient.whoami(), null, "Enter current password for '" + this.accumuloClient.whoami() + "': ");
                        try {
                            authFailed = !this.authenticateUser(this.accumuloClient, authToken);
                        }
                        catch (Exception e) {
                            ++this.exitCode;
                            this.printException(e);
                        }
                        if (authFailed) {
                            this.writer.print("Invalid password. ");
                            this.askAgain = true;
                            continue;
                        }
                        if (!this.usedClientProps) continue;
                        this.writer.println("User re-authenticated using value from accumulo-client.properties file");
                    } while (authFailed);
                    this.lastUserActivity = System.nanoTime();
                }
                Options parseOpts = sc.getOptionsWithHelp();
                CommandLine cl = new DefaultParser().parse(parseOpts, fields);
                int actualArgLen = cl.getArgs().length;
                int expectedArgLen = sc.numArgs();
                if (cl.hasOption("?")) {
                    sc.printHelp(this);
                } else if (expectedArgLen != -1 && actualArgLen != expectedArgLen) {
                    ++this.exitCode;
                    this.printException(new IllegalArgumentException(String.format("Expected %d argument%s. There %s %d.", expectedArgLen, expectedArgLen == 1 ? "" : "s", actualArgLen == 1 ? "was" : "were", actualArgLen)));
                    sc.printHelp(this);
                } else {
                    int tmpCode = sc.execute(input, cl, this);
                    this.exitCode += tmpCode;
                    this.writer.flush();
                }
            }
            catch (ConstraintViolationException e) {
                ++this.exitCode;
                this.printConstraintViolationException(e);
            }
            catch (TableNotFoundException e) {
                ++this.exitCode;
                if (this.getTableName().equals(e.getTableName())) {
                    this.setTableName("");
                }
                this.printException((Exception)((Object)e));
            }
            catch (ParseException e) {
                if (!(e instanceof MissingOptionException) || !Stream.of(fields).anyMatch(IS_HELP_OPT)) {
                    ++this.exitCode;
                    this.printException((Exception)((Object)e));
                }
                sc.printHelp(this);
            }
            catch (UserInterruptException e) {
                ++this.exitCode;
            }
            catch (Exception e) {
                ++this.exitCode;
                this.printException(e);
            }
        }
        this.writer.flush();
    }

    private ShellCompletor setupCompletion() {
        Set<Object> namespaces;
        Set<String> userlist;
        Set<Object> tableNames;
        this.rootToken = new Token();
        try {
            tableNames = this.accumuloClient.tableOperations().list();
        }
        catch (Exception e) {
            log.debug("Unable to obtain list of tables", (Throwable)e);
            tableNames = Collections.emptySet();
        }
        try {
            userlist = this.accumuloClient.securityOperations().listLocalUsers();
        }
        catch (Exception e) {
            log.debug("Unable to obtain list of users", (Throwable)e);
            userlist = Collections.emptySet();
        }
        try {
            namespaces = this.accumuloClient.namespaceOperations().list();
        }
        catch (Exception e) {
            log.debug("Unable to obtain list of namespaces", (Throwable)e);
            namespaces = Collections.emptySet();
        }
        HashMap<Command.CompletionSet, Set<String>> options = new HashMap<Command.CompletionSet, Set<String>>();
        HashSet<String> commands = new HashSet<String>(this.commandFactory.keySet());
        HashSet<String> modifiedUserlist = new HashSet<String>();
        HashSet<String> modifiedTablenames = new HashSet<String>();
        HashSet<String> modifiedNamespaces = new HashSet<String>();
        for (String string : tableNames) {
            modifiedTablenames.add(string.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String string : userlist) {
            modifiedUserlist.add(string.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String string : namespaces) {
            String b = string.replaceAll("([\\s'\"])", "\\\\$1");
            modifiedNamespaces.add(b.isEmpty() ? "\"\"" : b);
        }
        options.put(Command.CompletionSet.USERNAMES, modifiedUserlist);
        options.put(Command.CompletionSet.TABLENAMES, modifiedTablenames);
        options.put(Command.CompletionSet.NAMESPACES, modifiedNamespaces);
        options.put(Command.CompletionSet.COMMANDS, commands);
        Iterator<Object> iterator = this.commandGrouping.values().iterator();
        while (iterator.hasNext()) {
            Command[] commandArray;
            for (Command c : commandArray = (Command[])iterator.next()) {
                c.getOptionsWithHelp();
                c.registerCompletion(this.rootToken, options);
            }
        }
        return new ShellCompletor(this.rootToken, options);
    }

    public final void printLines(Iterator<String> lines, boolean paginate) throws IOException {
        this.printLines(lines, paginate, null);
    }

    public final void printLines(Iterator<String> lines, boolean paginate, PrintLine out) throws IOException {
        double linesPrinted = 0.0;
        String prompt = "-- hit any key to continue or 'q' to quit --";
        int lastPromptLength = prompt.length();
        int termWidth = this.terminal.getWidth();
        int maxLines = this.terminal.getHeight();
        String peek = null;
        while (lines.hasNext()) {
            String nextLine = lines.next();
            if (nextLine == null) continue;
            for (String line : nextLine.split("\\n")) {
                if (out == null) {
                    if (peek != null) {
                        this.writer.println(peek);
                        if (paginate && (linesPrinted += peek.isEmpty() ? 0.0 : Math.ceil((double)peek.length() * 1.0 / (double)termWidth)) + Math.ceil((double)lastPromptLength * 1.0 / (double)termWidth) + Math.ceil((double)prompt.length() * 1.0 / (double)termWidth) + Math.ceil((double)line.length() * 1.0 / (double)termWidth) > (double)maxLines) {
                            linesPrinted = 0.0;
                            int numdashes = (termWidth - prompt.length()) / 2;
                            String nextPrompt = Shell.repeat("-", numdashes) + prompt + Shell.repeat("-", numdashes);
                            lastPromptLength = nextPrompt.length();
                            this.writer.print(nextPrompt);
                            this.writer.flush();
                            Attributes attr = this.terminal.enterRawMode();
                            int c = this.terminal.reader().read();
                            this.terminal.setAttributes(attr);
                            if (Character.toUpperCase((char)c) == 'Q') {
                                this.writer.println();
                                return;
                            }
                            this.writer.println();
                            termWidth = this.terminal.getWidth();
                            maxLines = this.terminal.getHeight();
                        }
                    }
                    peek = line;
                    continue;
                }
                out.print(line);
            }
        }
        if (out == null && peek != null) {
            this.writer.println(peek);
        }
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, boolean paginate, Class<? extends Formatter> formatterClass, PrintLine outFile) throws IOException {
        this.printLines((Iterator<String>)FormatterFactory.getFormatter(formatterClass, scanner, (FormatterConfig)config), paginate, outFile);
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, boolean paginate, Class<? extends Formatter> formatterClass) throws IOException {
        this.printLines((Iterator<String>)FormatterFactory.getFormatter(formatterClass, scanner, (FormatterConfig)config), paginate);
    }

    public static String repeat(String s, int c) {
        return s.repeat(Math.max(0, c));
    }

    public void checkTableState() {
        if (this.getTableName().isEmpty()) {
            throw new IllegalStateException("Not in a table context. Please use 'table <tableName>' to switch to a table, or use '-t' to specify a table if option is available.");
        }
    }

    private void printConstraintViolationException(ConstraintViolationException cve) {
        this.printException((Exception)((Object)cve), "");
        int COL1 = 50;
        int COL2 = 14;
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.terminal.getWidth() - COL1 - COL2 - 6));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "s | %-" + col3 + "s%n", "Constraint class", "Violation code", "Violation Description"));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        for (TConstraintViolationSummary cvs : cve.violationSummaries) {
            this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "d | %-" + col3 + "s%n", cvs.constrainClass, cvs.violationCode, cvs.violationDescription));
        }
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
    }

    public final void printException(Exception e) {
        this.printException(e, e.getMessage());
    }

    private void printException(Exception e, String msg) {
        this.logError(e.getClass().getName() + (String)(msg != null ? ": " + msg : ""));
        log.debug("{}{}", new Object[]{e.getClass().getName(), msg != null ? ": " + msg : "", e});
    }

    private void printHelp(String usage, String description, Options opts) {
        this.printHelp(usage, description, opts, Integer.MAX_VALUE);
    }

    private void printHelp(String usage, String description, Options opts, int width) {
        new HelpFormatter().printHelp(this.writer, width, usage, description, opts, 2, 5, null, true);
        this.writer.flush();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void resetExitCode() {
        this.exitCode = 0;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    public boolean getExit() {
        return this.exit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName == null || tableName.isEmpty() ? "" : TableNameUtil.qualified((String)tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public LineReader getReader() {
        return this.reader;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void updateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        AccumuloClient newClient = (AccumuloClient)Accumulo.newClient().from(this.clientProperties).as((CharSequence)principal, token).build();
        try {
            this.authenticateUser(newClient, token);
        }
        catch (AccumuloSecurityException e) {
            newClient.close();
            throw e;
        }
        AccumuloClient oldClient = this.accumuloClient;
        this.accumuloClient = newClient;
        this.context = (ClientContext)this.accumuloClient;
        if (oldClient != null) {
            oldClient.close();
        }
    }

    public ClientContext getContext() {
        return this.context;
    }

    public Class<? extends Formatter> getFormatter() {
        return this.getFormatter(this.tableName);
    }

    public Class<? extends Formatter> getFormatter(String tableName) {
        Class<? extends Formatter> formatter = FormatterCommand.getCurrentFormatter(tableName, this);
        if (formatter == null) {
            this.logError("Could not load the specified formatter. Using the DefaultFormatter");
            return this.defaultFormatterClass;
        }
        return formatter;
    }

    public void setLogErrorsToConsole() {
        this.logErrorsToConsole = true;
    }

    private void logError(String s) {
        log.error("{}", (Object)s);
        if (this.logErrorsToConsole) {
            this.writer.println("ERROR: " + s);
            this.writer.flush();
        }
    }

    public String readMaskedLine(String prompt, Character mask) {
        return this.reader.readLine(prompt, mask);
    }

    public boolean hasExited() {
        return this.exit;
    }

    public Optional<Boolean> confirm(String prompt) {
        String line;
        this.getWriter().flush();
        Optional<Boolean> confirmed = Optional.empty();
        try {
            line = this.getReader().readLine(prompt + " (yes|no)? ");
        }
        catch (EndOfFileException ignored) {
            line = null;
        }
        if (line != null) {
            confirmed = Optional.of(line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes"));
        }
        return confirmed;
    }

    static {
        String prop = "input.encoding";
        if (System.getProperty(prop) == null) {
            String value = System.getProperty("jline.WindowsTerminal.output.encoding");
            if (value == null) {
                value = System.getProperty("file.encoding");
            }
            if (value != null) {
                System.setProperty(prop, value);
            }
        }
    }

    public static abstract class Command {
        public void registerCompletionGeneral(Token root, Set<String> args, boolean caseSens) {
            Token t = new Token(args);
            t.setCaseSensitive(caseSens);
            Token command = new Token(this.getName());
            command.addSubcommand(t);
            root.addSubcommand(command);
        }

        public void registerCompletionForTables(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.TABLENAMES), true);
        }

        public void registerCompletionForUsers(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.USERNAMES), true);
        }

        public void registerCompletionForCommands(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.COMMANDS), false);
        }

        public void registerCompletionForNamespaces(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.NAMESPACES), true);
        }

        public abstract int execute(String var1, CommandLine var2, Shell var3) throws Exception;

        public abstract String description();

        public abstract int numArgs();

        public String getName() {
            String s = this.getClass().getName();
            int st = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
            int i = s.indexOf("Command");
            return i > 0 ? s.substring(st + 1, i).toLowerCase(Locale.ENGLISH) : null;
        }

        public void registerCompletion(Token root, Map<CompletionSet, Set<String>> completion_set) {
            root.addSubcommand(new Token(this.getName()));
        }

        public final void printHelp(Shell shellState) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp());
        }

        public final void printHelp(Shell shellState, int width) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp(), width);
        }

        public final Options getOptionsWithHelp() {
            Options opts = this.getOptions();
            opts.addOption(new Option("?", "help", false, "display this help"));
            return opts;
        }

        public String usage() {
            return this.getName();
        }

        public Options getOptions() {
            return new Options();
        }

        public static enum CompletionSet {
            TABLENAMES,
            USERNAMES,
            COMMANDS,
            NAMESPACES;

        }
    }

    public static interface PrintLine
    extends AutoCloseable {
        public void print(String var1);

        @Override
        public void close();
    }

    public static class PrintFile
    implements PrintLine {
        PrintWriter writer;

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT"}, justification="app is run in same security context as user providing the filename")
        public PrintFile(String filename) throws FileNotFoundException {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8)));
        }

        @Override
        public void print(String s) {
            this.writer.println(s);
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }

    public static class PrintShell
    implements PrintLine {
        LineReader reader;

        public PrintShell(LineReader reader) {
            this.reader = reader;
        }

        @Override
        public void print(String s) {
            try {
                this.reader.getTerminal().writer().println(s);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
        }
    }
}

