/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.spi.compaction.SimpleCompactionDispatcher;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

class InitialConfiguration {
    private final HashMap<String, String> initialRootConf = new HashMap();
    private final HashMap<String, String> initialRootMetaConf = new HashMap();
    private final HashMap<String, String> initialMetaConf = new HashMap();
    private final HashMap<String, String> initialReplicationTableConf = new HashMap();
    private final Configuration hadoopConf;
    private final SiteConfiguration siteConf;

    InitialConfiguration(Configuration hadoopConf, SiteConfiguration siteConf) {
        this.hadoopConf = hadoopConf;
        this.siteConf = siteConf;
        this.initialRootConf.put(Property.TABLE_COMPACTION_DISPATCHER.getKey(), SimpleCompactionDispatcher.class.getName());
        this.initialRootConf.put(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", "root");
        this.initialRootMetaConf.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "32K");
        this.initialRootMetaConf.put(Property.TABLE_FILE_REPLICATION.getKey(), "5");
        this.initialRootMetaConf.put(Property.TABLE_DURABILITY.getKey(), "sync");
        this.initialRootMetaConf.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
        this.initialRootMetaConf.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "64M");
        this.initialRootMetaConf.put(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", MetadataConstraints.class.getName());
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers", "10," + VersioningIterator.class.getName());
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions", "1");
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers", "10," + VersioningIterator.class.getName());
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions", "1");
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers", "10," + VersioningIterator.class.getName());
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions", "1");
        this.initialRootMetaConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter", "20," + MetadataBulkLoadFilter.class.getName());
        this.initialRootMetaConf.put(Property.TABLE_FAILURES_IGNORE.getKey(), "false");
        this.initialRootMetaConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet", String.format("%s,%s", MetadataSchema.TabletsSection.TabletColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME));
        this.initialRootMetaConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server", String.format("%s,%s,%s,%s", MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ServerColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME));
        this.initialRootMetaConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "tablet,server");
        this.initialRootMetaConf.put(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "");
        this.initialRootMetaConf.put(Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
        this.initialRootMetaConf.put(Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
        this.initialMetaConf.put(Property.TABLE_COMPACTION_DISPATCHER.getKey(), SimpleCompactionDispatcher.class.getName());
        this.initialMetaConf.put(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", "meta");
        Class<StatusCombiner> statusCombinerClass = StatusCombiner.class;
        IteratorSetting setting = new IteratorSetting(9, "replcombiner", statusCombinerClass);
        Combiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column(MetadataSchema.ReplicationSection.COLF)));
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            String string = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), setting.getName());
            for (Map.Entry entry : setting.getOptions().entrySet()) {
                this.initialMetaConf.put(string + ".opt." + (String)entry.getKey(), (String)entry.getValue());
            }
            this.initialMetaConf.put(string, setting.getPriority() + "," + setting.getIteratorClass());
        }
        String replicationCombinerName = "statuscombiner";
        setting = new IteratorSetting(30, replicationCombinerName, statusCombinerClass);
        setting.setPriority(30);
        Text statusSectionName = ReplicationSchema.StatusSection.NAME;
        Text workSectionName = ReplicationSchema.WorkSection.NAME;
        Combiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(statusSectionName), new IteratorSetting.Column(workSectionName)));
        for (IteratorUtil.IteratorScope iteratorScope : EnumSet.allOf(IteratorUtil.IteratorScope.class)) {
            String string = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, iteratorScope.name().toLowerCase(), setting.getName());
            for (Map.Entry entry : setting.getOptions().entrySet()) {
                this.initialReplicationTableConf.put(string + ".opt." + (String)entry.getKey(), (String)entry.getValue());
            }
            this.initialReplicationTableConf.put(string, setting.getPriority() + "," + setting.getIteratorClass());
        }
        Map replicationLocalityGroups = ReplicationTable.LOCALITY_GROUPS;
        for (Map.Entry entry : replicationLocalityGroups.entrySet()) {
            this.initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX + (String)entry.getKey(), LocalityGroupUtil.encodeColumnFamilies((Set)((Set)entry.getValue())));
        }
        this.initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), Joiner.on((String)",").join(replicationLocalityGroups.keySet()));
        String string = ReplicationUtil.STATUS_FORMATTER_CLASS_NAME;
        this.initialReplicationTableConf.put(Property.TABLE_FORMATTER_CLASS.getKey(), string);
        int n = hadoopConf.getInt("dfs.replication.max", 512);
        int n2 = Math.max(hadoopConf.getInt("dfs.replication.min", 1), hadoopConf.getInt("dfs.namenode.replication.min", 1));
        if (n < 5) {
            this.setMetadataReplication(n, "max");
        }
        if (n2 > 5) {
            this.setMetadataReplication(n2, "min");
        }
    }

    private void setMetadataReplication(int replication, String reason) {
        String rep = System.console().readLine("Your HDFS replication " + reason + " is not compatible with our default " + MetadataTable.NAME + " replication of 5. What do you want to set your " + MetadataTable.NAME + " replication to? (" + replication + ") ", new Object[0]);
        if (rep == null || rep.isEmpty()) {
            rep = Integer.toString(replication);
        } else {
            Integer.parseInt(rep);
        }
        this.initialRootMetaConf.put(Property.TABLE_FILE_REPLICATION.getKey(), rep);
    }

    HashMap<String, String> getRootTableConf() {
        return this.initialRootConf;
    }

    HashMap<String, String> getRootMetaConf() {
        return this.initialRootMetaConf;
    }

    HashMap<String, String> getMetaTableConf() {
        return this.initialMetaConf;
    }

    HashMap<String, String> getReplTableConf() {
        return this.initialReplicationTableConf;
    }

    Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    SiteConfiguration getSiteConf() {
        return this.siteConf;
    }

    Set<String> getVolumeUris() {
        return VolumeConfiguration.getVolumeUris((AccumuloConfiguration)this.siteConf);
    }

    String get(Property property) {
        return this.siteConf.get(property);
    }

    boolean getBoolean(Property property) {
        return this.siteConf.getBoolean(property);
    }

    void getProperties(Map<String, String> props, Predicate<String> filter, boolean defaults) {
        this.siteConf.getProperties(props, filter, defaults);
    }
}

