/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummarizerConfiguration;
import org.apache.accumulo.core.dataImpl.thrift.TSummary;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;
import org.apache.accumulo.core.summary.SummarizerFactory;

public class SummaryCollection {
    private Map<SummarizerConfiguration, MergedSummary> mergedSummaries;
    private long totalFiles;
    private long deletedFiles;

    public SummaryCollection() {
        this.mergedSummaries = new HashMap<SummarizerConfiguration, MergedSummary>();
        this.totalFiles = 0L;
    }

    public SummaryCollection(TSummaries tsums) {
        this.mergedSummaries = new HashMap<SummarizerConfiguration, MergedSummary>();
        for (TSummary tSummary : tsums.getSummaries()) {
            SummarizerConfiguration sconf = SummarizerConfigurationUtil.fromThrift(tSummary.getConfig());
            this.mergedSummaries.put(sconf, new MergedSummary(tSummary));
        }
        this.totalFiles = tsums.getTotalFiles();
        this.deletedFiles = tsums.getDeletedFiles();
    }

    SummaryCollection(Collection<FileSummary> initialEntries) {
        this(initialEntries, false);
    }

    SummaryCollection(Collection<FileSummary> initialEntries, boolean deleted) {
        if (deleted) {
            Preconditions.checkArgument((boolean)initialEntries.isEmpty());
        }
        this.mergedSummaries = new HashMap<SummarizerConfiguration, MergedSummary>();
        for (FileSummary entry : initialEntries) {
            this.mergedSummaries.put(entry.conf, new MergedSummary(entry));
        }
        this.totalFiles = 1L;
        this.deletedFiles = deleted ? 1L : 0L;
    }

    public void merge(SummaryCollection other, SummarizerFactory factory) {
        for (Map.Entry<SummarizerConfiguration, MergedSummary> entry : other.mergedSummaries.entrySet()) {
            MergedSummary ms = this.mergedSummaries.get(entry.getKey());
            if (ms == null) {
                this.mergedSummaries.put(entry.getKey(), entry.getValue());
                continue;
            }
            ms.merge(entry.getValue(), entry.getKey(), factory);
        }
        this.totalFiles += other.totalFiles;
        this.deletedFiles += other.deletedFiles;
    }

    public static SummaryCollection merge(SummaryCollection sc1, SummaryCollection sc2, SummarizerFactory factory) {
        SummaryCollection ret = new SummaryCollection();
        ret.merge(sc1, factory);
        ret.merge(sc2, factory);
        return ret;
    }

    public List<Summary> getSummaries() {
        ArrayList<Summary> ret = new ArrayList<Summary>(this.mergedSummaries.size());
        for (Map.Entry<SummarizerConfiguration, MergedSummary> entry : this.mergedSummaries.entrySet()) {
            SummarizerConfiguration config = entry.getKey();
            MergedSummary ms = entry.getValue();
            ret.add(new Summary(ms.summary, config, this.totalFiles, this.totalFiles - this.deletedFiles - ms.filesContaining, ms.filesExceedingBoundry, ms.filesLarge, this.deletedFiles));
        }
        return ret;
    }

    public long getTotalFiles() {
        return this.totalFiles;
    }

    public TSummaries toThrift() {
        ArrayList<TSummary> summaries = new ArrayList<TSummary>(this.mergedSummaries.size());
        for (Map.Entry<SummarizerConfiguration, MergedSummary> entry : this.mergedSummaries.entrySet()) {
            summaries.add(entry.getValue().toThrift(entry.getKey()));
        }
        return new TSummaries(true, -1L, this.totalFiles, this.deletedFiles, summaries);
    }

    private static class MergedSummary {
        Map<String, Long> summary;
        long filesContaining;
        long filesExceedingBoundry;
        long filesLarge;

        public MergedSummary(FileSummary entry) {
            this.summary = entry.summary;
            this.filesContaining = 1L;
            this.filesExceedingBoundry = entry.exceededBoundry ? 1L : 0L;
            this.filesLarge = entry.exceededMaxSize ? 1L : 0L;
        }

        public MergedSummary(TSummary tSummary) {
            this.summary = new HashMap<String, Long>(tSummary.getSummary());
            this.filesContaining = tSummary.getFilesContaining();
            this.filesExceedingBoundry = tSummary.getFilesExceeding();
            this.filesLarge = tSummary.getFilesLarge();
        }

        public void merge(MergedSummary other, SummarizerConfiguration config, SummarizerFactory factory) {
            if (this.summary == null && other.summary != null) {
                this.summary = new HashMap<String, Long>(other.summary);
            } else if (this.summary != null && other.summary != null) {
                Summarizer summarizer = factory.getSummarizer(config);
                summarizer.combiner(config).merge(this.summary, other.summary);
            }
            this.filesContaining += other.filesContaining;
            this.filesExceedingBoundry += other.filesExceedingBoundry;
            this.filesLarge += other.filesLarge;
        }

        public TSummary toThrift(SummarizerConfiguration key) {
            TSummarizerConfiguration tsumConf = SummarizerConfigurationUtil.toThrift(key);
            return new TSummary(this.summary, tsumConf, this.filesContaining, this.filesExceedingBoundry, this.filesLarge);
        }
    }

    static class FileSummary {
        private SummarizerConfiguration conf;
        private Map<String, Long> summary;
        private boolean exceededBoundry;
        private boolean exceededMaxSize;

        FileSummary(SummarizerConfiguration conf, Map<String, Long> summary, boolean exceededBoundry) {
            this.conf = conf;
            this.summary = summary;
            this.exceededBoundry = exceededBoundry;
            this.exceededMaxSize = false;
        }

        FileSummary(SummarizerConfiguration conf) {
            this.conf = conf;
            this.summary = new HashMap<String, Long>();
            this.exceededBoundry = false;
            this.exceededMaxSize = true;
        }
    }
}

