/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.util.HostAndPort;

public interface MetricsInfo {
    public static Tag instanceNameTag(String instanceName) {
        Objects.requireNonNull(instanceName, "cannot create the tag without providing the instance name");
        return Tag.of((String)"instance.name", (String)instanceName);
    }

    public static Tag processTag(String processName) {
        Objects.requireNonNull(processName, "cannot create the tag without providing the process name");
        return Tag.of((String)"process.name", (String)processName);
    }

    public static List<Tag> addressTags(HostAndPort hostAndPort) {
        Objects.requireNonNull(hostAndPort, "cannot create the tag without providing the hostAndPort");
        ArrayList<Tag> tags = new ArrayList<Tag>(2);
        tags.add(Tag.of((String)"host", (String)hostAndPort.getHost()));
        int port = hostAndPort.getPort();
        if (port != 0) {
            tags.add(Tag.of((String)"port", (String)Integer.toString(hostAndPort.getPort())));
        }
        return Collections.unmodifiableList(tags);
    }

    public boolean isMetricsEnabled();

    public void addServiceTags(String var1, HostAndPort var2);

    public void addCommonTags(List<Tag> var1);

    public Collection<Tag> getCommonTags();

    public void addRegistry(MeterRegistry var1);

    public void addMetricsProducers(MetricsProducer ... var1);

    public void init();

    public MeterRegistry getRegistry();

    public void close();
}

