/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateLock
implements DistributedReadWriteLock.QueueLock {
    private static final Logger log = LoggerFactory.getLogger(FateLock.class);
    private static final String PREFIX = "flock#";
    private final ZooReaderWriter zoo;
    private final FateLockPath path;

    public static FateLockPath path(String path) {
        return new FateLockPath(path);
    }

    public FateLock(ZooReaderWriter zrw, FateLockPath path) {
        this.zoo = Objects.requireNonNull(zrw);
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public long addEntry(byte[] data) {
        try {
            while (true) {
                try {
                    String newPath = this.zoo.putPersistentSequential(this.path + "/flock#", data);
                    String[] parts = newPath.split("/");
                    String last = parts[parts.length - 1];
                    return Long.parseLong(last.substring(PREFIX.length()));
                }
                catch (KeeperException.NoNodeException nne) {
                    this.zoo.putPersistentData(this.path.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SortedMap<Long, byte[]> getEarlierEntries(long entry) {
        TreeMap<Long, byte[]> result = new TreeMap<Long, byte[]>();
        try {
            List<Object> children = Collections.emptyList();
            try {
                children = this.zoo.getChildren(this.path.toString());
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            for (String name : children) {
                try {
                    byte[] data = this.zoo.getData(this.path + "/" + name);
                    long order = Long.parseLong(name.substring(PREFIX.length()));
                    if (order > entry) continue;
                    result.put(order, data);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public void removeEntry(long entry) {
        try {
            this.zoo.recursiveDelete(this.path + String.format("/%s%010d", PREFIX, entry), ZooUtil.NodeMissingPolicy.SKIP);
            try {
                this.zoo.delete(this.path.toString());
            }
            catch (KeeperException.NotEmptyException notEmptyException) {}
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<String> validateAndSort(FateLockPath path, List<String> children) {
        log.trace("validating and sorting children at path {}", (Object)path);
        ArrayList<String> validChildren = new ArrayList<String>();
        if (children == null || children.isEmpty()) {
            return validChildren;
        }
        children.forEach(c -> {
            log.trace("Validating {}", c);
            if (c.startsWith(PREFIX)) {
                int idx = c.indexOf(35);
                String sequenceNum = c.substring(idx + 1);
                if (sequenceNum.length() == 10) {
                    try {
                        log.trace("Testing number format of {}", (Object)sequenceNum);
                        Integer.parseInt(sequenceNum);
                        validChildren.add((String)c);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Fate lock found with invalid sequence number format: {} (not a number)", c);
                    }
                } else {
                    log.warn("Fate lock found with invalid sequence number format: {} (not 10 characters)", c);
                }
            } else {
                log.warn("Fate lock found with invalid lock format: {} (does not start with {})", c, (Object)PREFIX);
            }
        });
        if (validChildren.size() > 1) {
            validChildren.sort((o1, o2) -> {
                int secondHashIdx = 6;
                return Integer.valueOf(o1.substring(secondHashIdx)).compareTo(Integer.valueOf(o2.substring(secondHashIdx)));
            });
        }
        log.trace("Children nodes (size: {}): {}", (Object)validChildren.size(), validChildren);
        return validChildren;
    }

    public static class FateLockPath {
        private final String path;

        private FateLockPath(String path) {
            this.path = Objects.requireNonNull(path);
        }

        public String toString() {
            return this.path;
        }
    }
}

