/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Joiner;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TimeoutTabletLocator;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.dataImpl.thrift.UpdateErrors;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchWriter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchWriter.class);
    private final ClientContext context;
    private final long maxMem;
    private final long maxLatency;
    private final long timeout;
    private final Durability durability;
    private boolean flushing;
    private boolean closed;
    private MutationSet mutations;
    private final MutationWriter writer;
    private final ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> latencyTimerFuture;
    private final Map<String, TimeoutTracker> timeoutTrackers = Collections.synchronizedMap(new HashMap());
    private long totalMemUsed = 0L;
    private long lastProcessingStartTime;
    private long totalAdded = 0L;
    private final AtomicLong totalSent = new AtomicLong(0L);
    private final AtomicLong totalBinned = new AtomicLong(0L);
    private final AtomicLong totalBinTime = new AtomicLong(0L);
    private final AtomicLong totalSendTime = new AtomicLong(0L);
    private long startTime = 0L;
    private long initialGCTimes;
    private long initialCompileTimes;
    private double initialSystemLoad;
    private AtomicInteger tabletServersBatchSum = new AtomicInteger(0);
    private AtomicInteger tabletBatchSum = new AtomicInteger(0);
    private AtomicInteger numBatches = new AtomicInteger(0);
    private AtomicInteger maxTabletBatch = new AtomicInteger(Integer.MIN_VALUE);
    private AtomicInteger minTabletBatch = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger minTabletServersBatch = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger maxTabletServersBatch = new AtomicInteger(Integer.MIN_VALUE);
    private final Violations violations = new Violations();
    private final Map<KeyExtent, Set<SecurityErrorCode>> authorizationFailures = new HashMap<KeyExtent, Set<SecurityErrorCode>>();
    private final HashSet<String> serverSideErrors = new HashSet();
    private final FailedMutations failedMutations;
    private int unknownErrors = 0;
    private final AtomicBoolean somethingFailed = new AtomicBoolean(false);
    private Exception lastUnknownError = null;

    public TabletServerBatchWriter(ClientContext context, BatchWriterConfig config) {
        this.context = context;
        this.executor = context.threadPools().createGeneralScheduledExecutorService(this.context.getConfiguration());
        this.failedMutations = new FailedMutations();
        this.maxMem = config.getMaxMemory();
        this.maxLatency = config.getMaxLatency(TimeUnit.MILLISECONDS) <= 0L ? Long.MAX_VALUE : config.getMaxLatency(TimeUnit.MILLISECONDS);
        this.timeout = config.getTimeout(TimeUnit.MILLISECONDS);
        this.mutations = new MutationSet();
        this.lastProcessingStartTime = System.currentTimeMillis();
        this.durability = config.getDurability();
        this.writer = new MutationWriter(config.getMaxWriteThreads());
        if (this.maxLatency != Long.MAX_VALUE) {
            this.latencyTimerFuture = this.executor.scheduleWithFixedDelay(Threads.createNamedRunnable("BatchWriterLatencyTimer", () -> {
                try {
                    TabletServerBatchWriter tabletServerBatchWriter = this;
                    synchronized (tabletServerBatchWriter) {
                        if (System.currentTimeMillis() - this.lastProcessingStartTime > this.maxLatency) {
                            this.startProcessing();
                        }
                    }
                }
                catch (Exception e) {
                    this.updateUnknownErrors("Max latency task failed " + e.getMessage(), e);
                }
            }), 0L, this.maxLatency / 4L, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void startProcessing() {
        if (this.mutations.getMemoryUsed() == 0L) {
            return;
        }
        this.lastProcessingStartTime = System.currentTimeMillis();
        this.writer.queueMutations(this.mutations);
        this.mutations = new MutationSet();
    }

    private synchronized void decrementMemUsed(long amount) {
        this.totalMemUsed -= amount;
        this.notifyAll();
    }

    public synchronized void addMutation(TableId table, Mutation m) throws MutationsRejectedException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        if (this.latencyTimerFuture != null) {
            ThreadPools.ensureRunning(this.latencyTimerFuture, "Latency timer thread has exited, cannot guarantee latency target");
        }
        this.checkForFailures();
        this.waitRTE(() -> (this.totalMemUsed > this.maxMem || this.flushing) && !this.somethingFailed.get());
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        this.checkForFailures();
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : gcmBeans) {
                this.initialGCTimes += garbageCollectorMXBean.getCollectionTime();
            }
            CompilationMXBean compMxBean = ManagementFactory.getCompilationMXBean();
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                this.initialCompileTimes = compMxBean.getTotalCompilationTime();
            }
            this.initialSystemLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }
        m = new Mutation(m);
        this.totalMemUsed += m.estimatedMemoryUsed();
        this.mutations.addMutation(table, m);
        ++this.totalAdded;
        if (this.mutations.getMemoryUsed() >= this.maxMem / 2L) {
            this.startProcessing();
            this.checkForFailures();
        }
    }

    public void addMutation(TableId table, Iterator<Mutation> iterator) throws MutationsRejectedException {
        while (iterator.hasNext()) {
            this.addMutation(table, iterator.next());
        }
    }

    public synchronized void flush() throws MutationsRejectedException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        Span span = TraceUtil.startSpan(this.getClass(), "flush");
        try (Scope scope = span.makeCurrent();){
            this.checkForFailures();
            if (this.flushing) {
                this.waitRTE(() -> this.flushing && !this.somethingFailed.get());
                this.checkForFailures();
                return;
            }
            this.flushing = true;
            this.startProcessing();
            this.checkForFailures();
            this.waitRTE(() -> this.totalMemUsed > 0L && !this.somethingFailed.get());
            this.flushing = false;
            this.notifyAll();
            this.checkForFailures();
        }
        catch (Exception e) {
            TraceUtil.setException(span, e, true);
            throw e;
        }
        finally {
            span.end();
        }
    }

    @Override
    public synchronized void close() throws MutationsRejectedException {
        if (this.closed) {
            return;
        }
        Span span = TraceUtil.startSpan(this.getClass(), "close");
        try (Scope scope = span.makeCurrent();){
            this.closed = true;
            this.startProcessing();
            this.waitRTE(() -> this.totalMemUsed > 0L && !this.somethingFailed.get());
            this.logStats();
            this.checkForFailures();
        }
        catch (Exception e) {
            TraceUtil.setException(span, e, true);
            throw e;
        }
        finally {
            span.end();
            this.writer.binningThreadPool.shutdownNow();
            this.writer.sendThreadPool.shutdownNow();
            this.executor.shutdownNow();
        }
    }

    private void logStats() {
        if (log.isTraceEnabled()) {
            long finishTime = System.currentTimeMillis();
            long finalGCTimes = 0L;
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : gcmBeans) {
                finalGCTimes += garbageCollectorMXBean.getCollectionTime();
            }
            CompilationMXBean compMxBean = ManagementFactory.getCompilationMXBean();
            long finalCompileTimes = 0L;
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                finalCompileTimes = compMxBean.getTotalCompilationTime();
            }
            double averageRate = (double)this.totalSent.get() / ((double)this.totalSendTime.get() / 1000.0);
            double overallRate = (double)this.totalAdded / ((double)(finishTime - this.startTime) / 1000.0);
            double finalSystemLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            log.trace("");
            log.trace("TABLET SERVER BATCH WRITER STATISTICS");
            log.trace(String.format("Added                : %,10d mutations", this.totalAdded));
            log.trace(String.format("Sent                 : %,10d mutations", this.totalSent.get()));
            log.trace(String.format("Resent percentage   : %10.2f%s", (double)(this.totalSent.get() - this.totalAdded) / (double)this.totalAdded * 100.0, "%"));
            log.trace(String.format("Overall time         : %,10.2f secs", (double)(finishTime - this.startTime) / 1000.0));
            log.trace(String.format("Overall send rate    : %,10.2f mutations/sec", overallRate));
            log.trace(String.format("Send efficiency      : %10.2f%s", overallRate / averageRate * 100.0, "%"));
            log.trace("");
            log.trace("BACKGROUND WRITER PROCESS STATISTICS");
            log.trace(String.format("Total send time      : %,10.2f secs %6.2f%s", (double)this.totalSendTime.get() / 1000.0, 100.0 * (double)this.totalSendTime.get() / (double)(finishTime - this.startTime), "%"));
            log.trace(String.format("Average send rate    : %,10.2f mutations/sec", averageRate));
            log.trace(String.format("Total bin time       : %,10.2f secs %6.2f%s", (double)this.totalBinTime.get() / 1000.0, 100.0 * (double)this.totalBinTime.get() / (double)(finishTime - this.startTime), "%"));
            log.trace(String.format("Average bin rate     : %,10.2f mutations/sec", (double)this.totalBinned.get() / ((double)this.totalBinTime.get() / 1000.0)));
            log.trace(String.format("tservers per batch   : %,8.2f avg  %,6d min %,6d max", Float.valueOf(this.numBatches.get() != 0 ? this.tabletServersBatchSum.get() / this.numBatches.get() : 0), this.minTabletServersBatch.get(), this.maxTabletServersBatch.get()));
            log.trace(String.format("tablets per batch    : %,8.2f avg  %,6d min %,6d max", Float.valueOf(this.numBatches.get() != 0 ? this.tabletBatchSum.get() / this.numBatches.get() : 0), this.minTabletBatch.get(), this.maxTabletBatch.get()));
            log.trace("");
            log.trace("SYSTEM STATISTICS");
            log.trace(String.format("JVM GC Time          : %,10.2f secs", (double)(finalGCTimes - this.initialGCTimes) / 1000.0));
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                log.trace(String.format("JVM Compile Time     : %,10.2f secs", (double)(finalCompileTimes - this.initialCompileTimes) / 1000.0));
            }
            log.trace(String.format("System load average : initial=%6.2f final=%6.2f", this.initialSystemLoad, finalSystemLoad));
        }
    }

    private void updateSendStats(long count, long time) {
        this.totalSent.addAndGet(count);
        this.totalSendTime.addAndGet(time);
    }

    public void updateBinningStats(int count, long time, Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
        if (log.isTraceEnabled()) {
            this.totalBinTime.addAndGet(time);
            this.totalBinned.addAndGet(count);
            this.updateBatchStats(binnedMutations);
        }
    }

    private static void computeMin(AtomicInteger stat, int update2) {
        int old = stat.get();
        while (!stat.compareAndSet(old, Math.min(old, update2))) {
            old = stat.get();
        }
    }

    private static void computeMax(AtomicInteger stat, int update2) {
        int old = stat.get();
        while (!stat.compareAndSet(old, Math.max(old, update2))) {
            old = stat.get();
        }
    }

    private void updateBatchStats(Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
        this.tabletServersBatchSum.addAndGet(binnedMutations.size());
        TabletServerBatchWriter.computeMin(this.minTabletServersBatch, binnedMutations.size());
        TabletServerBatchWriter.computeMax(this.maxTabletServersBatch, binnedMutations.size());
        int numTablets = 0;
        for (Map.Entry<String, TabletLocator.TabletServerMutations<Mutation>> entry : binnedMutations.entrySet()) {
            TabletLocator.TabletServerMutations<Mutation> tsm = entry.getValue();
            numTablets += tsm.getMutations().size();
        }
        this.tabletBatchSum.addAndGet(numTablets);
        TabletServerBatchWriter.computeMin(this.minTabletBatch, numTablets);
        TabletServerBatchWriter.computeMax(this.maxTabletBatch, numTablets);
        this.numBatches.incrementAndGet();
    }

    private void waitRTE(WaitCondition condition) {
        try {
            while (condition.shouldWait()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatedConstraintViolations(List<ConstraintViolationSummary> cvsList) {
        if (!cvsList.isEmpty()) {
            TabletServerBatchWriter tabletServerBatchWriter = this;
            synchronized (tabletServerBatchWriter) {
                this.somethingFailed.set(true);
                this.violations.add(cvsList);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthorizationFailures(Map<KeyExtent, SecurityErrorCode> authorizationFailures) {
        if (!authorizationFailures.isEmpty()) {
            this.context.clearTableListCache();
            authorizationFailures.keySet().stream().map(KeyExtent::tableId).forEach(this.context::requireNotDeleted);
            TabletServerBatchWriter tabletServerBatchWriter = this;
            synchronized (tabletServerBatchWriter) {
                this.somethingFailed.set(true);
                authorizationFailures.forEach((ke, code) -> this.authorizationFailures.computeIfAbsent((KeyExtent)ke, k -> new HashSet()).add(code));
                this.notifyAll();
            }
        }
    }

    private synchronized void updateServerErrors(String server, Exception e) {
        this.somethingFailed.set(true);
        this.serverSideErrors.add(server);
        this.notifyAll();
        log.error("Server side error on {}", (Object)server, (Object)e);
    }

    private synchronized void updateUnknownErrors(String msg, Exception t) {
        this.somethingFailed.set(true);
        ++this.unknownErrors;
        this.lastUnknownError = t;
        this.notifyAll();
        if (t instanceof TableDeletedException || t instanceof TableOfflineException || t instanceof TimedOutException) {
            log.debug("{}", (Object)msg, (Object)t);
        } else {
            log.error("{}", (Object)msg, (Object)t);
        }
    }

    private void checkForFailures() throws MutationsRejectedException {
        if (this.somethingFailed.get()) {
            List<ConstraintViolationSummary> cvsList = this.violations.asList();
            HashMap<TabletId, Set<org.apache.accumulo.core.client.security.SecurityErrorCode>> af = new HashMap<TabletId, Set<org.apache.accumulo.core.client.security.SecurityErrorCode>>();
            for (Map.Entry<KeyExtent, Set<SecurityErrorCode>> entry : this.authorizationFailures.entrySet()) {
                HashSet<org.apache.accumulo.core.client.security.SecurityErrorCode> codes = new HashSet<org.apache.accumulo.core.client.security.SecurityErrorCode>();
                for (SecurityErrorCode sce : entry.getValue()) {
                    codes.add(org.apache.accumulo.core.client.security.SecurityErrorCode.valueOf(sce.name()));
                }
                af.put(new TabletIdImpl(entry.getKey()), codes);
            }
            throw new MutationsRejectedException(this.context, cvsList, af, this.serverSideErrors, this.unknownErrors, (Throwable)this.lastUnknownError);
        }
    }

    private synchronized void addFailedMutations(MutationSet failedMutations) {
        this.mutations.addAll(failedMutations);
        if (this.mutations.getMemoryUsed() >= this.maxMem / 2L || this.closed || this.flushing) {
            this.startProcessing();
        }
    }

    private class FailedMutations {
        private MutationSet recentFailures = null;
        private long initTime;
        private final Runnable task = Threads.createNamedRunnable("failed mutationBatchWriterLatencyTimers handler", this::run);
        private final ScheduledFuture<?> future;

        FailedMutations() {
            this.future = TabletServerBatchWriter.this.executor.scheduleWithFixedDelay(this.task, 0L, 500L, TimeUnit.MILLISECONDS);
        }

        private MutationSet init() {
            ThreadPools.ensureRunning(this.future, "Background task that re-queues failed mutations has exited.");
            if (this.recentFailures == null) {
                this.recentFailures = new MutationSet();
                this.initTime = System.currentTimeMillis();
            }
            return this.recentFailures;
        }

        synchronized void add(TableId table, ArrayList<Mutation> tableFailures) {
            this.init().addAll(table, tableFailures);
        }

        synchronized void add(MutationSet failures) {
            this.init().addAll(failures);
        }

        synchronized void add(TabletLocator.TabletServerMutations<Mutation> tsm) {
            this.init();
            tsm.getMutations().forEach((ke, muts) -> this.recentFailures.addAll(ke.tableId(), (List<Mutation>)muts));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MutationSet rf = null;
                FailedMutations failedMutations = this;
                synchronized (failedMutations) {
                    if (this.recentFailures != null && System.currentTimeMillis() - this.initTime > 1000L) {
                        rf = this.recentFailures;
                        this.recentFailures = null;
                    }
                }
                if (rf != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("tid={}  Requeuing {} failed mutations", (Object)Thread.currentThread().getId(), (Object)rf.size());
                    }
                    TabletServerBatchWriter.this.addFailedMutations(rf);
                }
            }
            catch (Exception t) {
                TabletServerBatchWriter.this.updateUnknownErrors("tid=" + Thread.currentThread().getId() + "  Failed to requeue failed mutations " + t.getMessage(), t);
                TabletServerBatchWriter.this.executor.remove(this.task);
            }
        }
    }

    private static class MutationSet {
        private final HashMap<TableId, List<Mutation>> mutations = new HashMap();
        private long memoryUsed = 0L;

        MutationSet() {
        }

        void addMutation(TableId table, Mutation mutation) {
            this.mutations.computeIfAbsent(table, k -> new ArrayList()).add(mutation);
            this.memoryUsed += mutation.estimatedMemoryUsed();
        }

        Map<TableId, List<Mutation>> getMutations() {
            return this.mutations;
        }

        int size() {
            int result = 0;
            for (List<Mutation> perTable : this.mutations.values()) {
                result += perTable.size();
            }
            return result;
        }

        public void addAll(MutationSet failures) {
            Set<Map.Entry<TableId, List<Mutation>>> es = failures.getMutations().entrySet();
            for (Map.Entry<TableId, List<Mutation>> entry : es) {
                TableId table = entry.getKey();
                for (Mutation mutation : entry.getValue()) {
                    this.addMutation(table, mutation);
                }
            }
        }

        public void addAll(TableId table, List<Mutation> mutations) {
            for (Mutation mutation : mutations) {
                this.addMutation(table, mutation);
            }
        }

        public long getMemoryUsed() {
            return this.memoryUsed;
        }
    }

    private class MutationWriter {
        private static final int MUTATION_BATCH_SIZE = 131072;
        private final ThreadPoolExecutor sendThreadPool;
        private final ThreadPoolExecutor binningThreadPool;
        private final Map<String, TabletLocator.TabletServerMutations<Mutation>> serversMutations = new HashMap<String, TabletLocator.TabletServerMutations<Mutation>>();
        private final Set<String> queued = new HashSet<String>();
        private final Map<TableId, TabletLocator> locators;

        public MutationWriter(int numSendThreads) {
            this.sendThreadPool = TabletServerBatchWriter.this.context.threadPools().getPoolBuilder(ThreadPoolNames.BATCH_WRITER_SEND_POOL).numCoreThreads(numSendThreads).build();
            this.locators = new HashMap<TableId, TabletLocator>();
            this.binningThreadPool = TabletServerBatchWriter.this.context.threadPools().getPoolBuilder(ThreadPoolNames.BATCH_WRITER_BIN_MUTATIONS_POOL).numCoreThreads(1).withQueue(new SynchronousQueue<Runnable>()).build();
            this.binningThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }

        private synchronized TabletLocator getLocator(TableId tableId) {
            TabletLocator ret = this.locators.get(tableId);
            if (ret == null) {
                ret = new TimeoutTabletLocator(TabletServerBatchWriter.this.timeout, TabletServerBatchWriter.this.context, tableId);
                this.locators.put(tableId, ret);
            }
            return ret;
        }

        private void binMutations(MutationSet mutationsToProcess, Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
            TableId tableId = null;
            try {
                Set<Map.Entry<TableId, List<Mutation>>> es = mutationsToProcess.getMutations().entrySet();
                for (Map.Entry<TableId, List<Mutation>> entry : es) {
                    tableId = entry.getKey();
                    TabletLocator locator = this.getLocator(tableId);
                    List<Mutation> tableMutations = entry.getValue();
                    if (tableMutations == null) continue;
                    ArrayList<Mutation> tableFailures = new ArrayList<Mutation>();
                    locator.binMutations(TabletServerBatchWriter.this.context, tableMutations, binnedMutations, tableFailures);
                    if (tableFailures.isEmpty()) continue;
                    TabletServerBatchWriter.this.failedMutations.add(tableId, tableFailures);
                    if (tableFailures.size() != tableMutations.size()) continue;
                    TabletServerBatchWriter.this.context.requireNotDeleted(tableId);
                    TabletServerBatchWriter.this.context.requireNotOffline(tableId, null);
                }
                return;
            }
            catch (AccumuloServerException ase) {
                TabletServerBatchWriter.this.updateServerErrors(ase.getServer(), ase);
            }
            catch (AccumuloException ae) {
                TabletServerBatchWriter.this.failedMutations.add(mutationsToProcess);
            }
            catch (AccumuloSecurityException e) {
                TabletServerBatchWriter.this.updateAuthorizationFailures(Collections.singletonMap(new KeyExtent(tableId, null, null), SecurityErrorCode.valueOf(e.getSecurityErrorCode().name())));
            }
            catch (TableDeletedException | TableNotFoundException | TableOfflineException e) {
                TabletServerBatchWriter.this.updateUnknownErrors(e.getMessage(), e);
            }
            binnedMutations.clear();
        }

        void queueMutations(MutationSet mutationsToSend) {
            if (mutationsToSend == null) {
                return;
            }
            this.binningThreadPool.execute(() -> {
                try {
                    log.trace("{} - binning {} mutations", (Object)Thread.currentThread().getName(), (Object)mutationsToSend.size());
                    this.addMutations(mutationsToSend);
                }
                catch (Exception e) {
                    TabletServerBatchWriter.this.updateUnknownErrors("Error processing mutation set", e);
                }
            });
        }

        private void addMutations(MutationSet mutationsToSend) {
            HashMap<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations = new HashMap<String, TabletLocator.TabletServerMutations<Mutation>>();
            Span span = TraceUtil.startSpan(this.getClass(), "binMutations");
            try (Scope scope = span.makeCurrent();){
                long t1 = System.currentTimeMillis();
                this.binMutations(mutationsToSend, binnedMutations);
                long t2 = System.currentTimeMillis();
                TabletServerBatchWriter.this.updateBinningStats(mutationsToSend.size(), t2 - t1, binnedMutations);
            }
            catch (Exception e) {
                TraceUtil.setException(span, e, true);
                throw e;
            }
            finally {
                span.end();
            }
            this.addMutations(binnedMutations);
        }

        private synchronized void addMutations(Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
            int count = 0;
            for (Map.Entry<String, TabletLocator.TabletServerMutations<Mutation>> entry : binnedMutations.entrySet()) {
                String server = entry.getKey();
                TabletLocator.TabletServerMutations<Mutation> currentMutations = this.serversMutations.get(server);
                if (currentMutations == null) {
                    this.serversMutations.put(server, entry.getValue());
                } else {
                    for (Map.Entry<KeyExtent, List<Mutation>> entry2 : entry.getValue().getMutations().entrySet()) {
                        for (Mutation m : entry2.getValue()) {
                            currentMutations.addMutation(entry2.getKey(), m);
                        }
                    }
                }
                if (!log.isTraceEnabled()) continue;
                for (Map.Entry<KeyExtent, List<Mutation>> entry2 : entry.getValue().getMutations().entrySet()) {
                    count += entry2.getValue().size();
                }
            }
            if (count > 0 && log.isTraceEnabled()) {
                log.trace(String.format("Started sending %,d mutations to %,d tablet servers", count, binnedMutations.keySet().size()));
            }
            ArrayList<String> servers = new ArrayList<String>(binnedMutations.keySet());
            Collections.shuffle(servers);
            for (String server : servers) {
                if (this.queued.contains(server)) continue;
                this.sendThreadPool.execute(new SendTask(server));
                this.queued.add(server);
            }
        }

        private synchronized TabletLocator.TabletServerMutations<Mutation> getMutationsToSend(String server) {
            TabletLocator.TabletServerMutations<Mutation> tsmuts = this.serversMutations.remove(server);
            if (tsmuts == null) {
                this.queued.remove(server);
            }
            return tsmuts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MutationSet sendMutationsToTabletServer(String location, Map<KeyExtent, List<Mutation>> tabMuts, TimeoutTracker timeoutTracker, SessionCloser sessionCloser) throws IOException, AccumuloSecurityException, AccumuloServerException {
            MutationSet mutationSet;
            if (tabMuts.isEmpty()) {
                return new MutationSet();
            }
            TInfo tinfo = TraceUtil.traceInfo();
            timeoutTracker.startingWrite();
            HostAndPort parsedServer = HostAndPort.fromString(location);
            TabletClientService.Iface client = timeoutTracker.getTimeOut() < TabletServerBatchWriter.this.context.getClientTimeoutInMillis() ? (TabletClientService.Iface)ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, parsedServer, TabletServerBatchWriter.this.context, timeoutTracker.getTimeOut()) : (TabletClientService.Iface)ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, parsedServer, TabletServerBatchWriter.this.context);
            try {
                MutationSet allFailures = new MutationSet();
                sessionCloser.setSession(client.startUpdate(tinfo, TabletServerBatchWriter.this.context.rpcCreds(), DurabilityImpl.toThrift(TabletServerBatchWriter.this.durability)));
                ArrayList<TMutation> updates = new ArrayList<TMutation>();
                for (Map.Entry<KeyExtent, List<Mutation>> entry2 : tabMuts.entrySet()) {
                    long size = 0L;
                    Iterator<Mutation> iter = entry2.getValue().iterator();
                    while (iter.hasNext()) {
                        while (size < 131072L && iter.hasNext()) {
                            Mutation mutation = iter.next();
                            updates.add(mutation.toThrift());
                            size += mutation.numBytes();
                        }
                        client.applyUpdates(tinfo, sessionCloser.getSession(), entry2.getKey().toThrift(), updates);
                        updates.clear();
                        size = 0L;
                    }
                }
                UpdateErrors updateErrors = client.closeUpdate(tinfo, sessionCloser.getSession());
                sessionCloser.clearSession();
                Map<KeyExtent, Long> failures = updateErrors.failedExtents.entrySet().stream().collect(Collectors.toMap(entry -> KeyExtent.fromThrift((TKeyExtent)entry.getKey()), Map.Entry::getValue));
                TabletServerBatchWriter.this.updatedConstraintViolations(updateErrors.violationSummaries.stream().map(ConstraintViolationSummary::new).collect(Collectors.toList()));
                TabletServerBatchWriter.this.updateAuthorizationFailures(updateErrors.authorizationFailures.entrySet().stream().collect(Collectors.toMap(entry -> KeyExtent.fromThrift((TKeyExtent)entry.getKey()), Map.Entry::getValue)));
                long totalCommitted = 0L;
                for (Map.Entry<KeyExtent, Long> entry3 : failures.entrySet()) {
                    KeyExtent failedExtent = entry3.getKey();
                    int numCommitted = (int)entry3.getValue().longValue();
                    totalCommitted += (long)numCommitted;
                    TableId tableId = failedExtent.tableId();
                    this.getLocator(tableId).invalidateCache(failedExtent);
                    List<Mutation> mutations = tabMuts.get(failedExtent);
                    allFailures.addAll(tableId, mutations.subList(numCommitted, mutations.size()));
                }
                if (failures.keySet().containsAll(tabMuts.keySet()) && totalCommitted == 0L) {
                    timeoutTracker.wroteNothing();
                } else {
                    timeoutTracker.madeProgress();
                }
                mutationSet = allFailures;
            }
            catch (Throwable throwable) {
                try {
                    ThriftUtil.returnClient((TServiceClient)client, TabletServerBatchWriter.this.context);
                    throw throwable;
                }
                catch (TTransportException e) {
                    timeoutTracker.errorOccured();
                    throw new IOException(e);
                }
                catch (TApplicationException tae) {
                    sessionCloser.clearSession();
                    TabletServerBatchWriter.this.updateServerErrors(location, (Exception)((Object)tae));
                    throw new AccumuloServerException(location, tae);
                }
                catch (ThriftSecurityException e) {
                    sessionCloser.clearSession();
                    TabletServerBatchWriter.this.updateAuthorizationFailures(tabMuts.keySet().stream().collect(Collectors.toMap(Function.identity(), ke -> e.code)));
                    throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            ThriftUtil.returnClient((TServiceClient)client, TabletServerBatchWriter.this.context);
            return mutationSet;
        }

        class SendTask
        implements Runnable {
            private final String location;

            SendTask(String server) {
                this.location = server;
            }

            @Override
            public void run() {
                try {
                    TabletLocator.TabletServerMutations<Mutation> tsmuts = MutationWriter.this.getMutationsToSend(this.location);
                    while (tsmuts != null) {
                        this.send(tsmuts);
                        tsmuts = MutationWriter.this.getMutationsToSend(this.location);
                    }
                }
                catch (Exception t) {
                    TabletServerBatchWriter.this.updateUnknownErrors("Failed to send tablet server " + this.location + " its batch : " + t.getMessage(), t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void send(TabletLocator.TabletServerMutations<Mutation> tsm) throws AccumuloServerException, AccumuloSecurityException {
                MutationSet failures = null;
                String oldName = Thread.currentThread().getName();
                Map<KeyExtent, List<Mutation>> mutationBatch = tsm.getMutations();
                try {
                    long count = 0L;
                    TreeSet<TableId> tableIds = new TreeSet<TableId>();
                    for (Map.Entry<KeyExtent, List<Mutation>> entry : mutationBatch.entrySet()) {
                        count += (long)entry.getValue().size();
                        tableIds.add(entry.getKey().tableId());
                    }
                    String msg = "sending " + String.format("%,d", count) + " mutations to " + String.format("%,d", mutationBatch.size()) + " tablets at " + this.location + " tids: [" + Joiner.on((char)',').join(tableIds) + "]";
                    Thread.currentThread().setName(msg);
                    Span span = TraceUtil.startSpan(this.getClass(), "sendMutations");
                    try (Scope scope = span.makeCurrent();){
                        TimeoutTracker timeoutTracker = TabletServerBatchWriter.this.timeoutTrackers.get(this.location);
                        if (timeoutTracker == null) {
                            timeoutTracker = new TimeoutTracker(this.location, TabletServerBatchWriter.this.timeout);
                            TabletServerBatchWriter.this.timeoutTrackers.put(this.location, timeoutTracker);
                        }
                        long st1 = System.currentTimeMillis();
                        try (SessionCloser sessionCloser = new SessionCloser(this.location);){
                            failures = MutationWriter.this.sendMutationsToTabletServer(this.location, mutationBatch, timeoutTracker, sessionCloser);
                        }
                        catch (ThriftSecurityException e) {
                            TabletServerBatchWriter.this.updateAuthorizationFailures(mutationBatch.keySet().stream().collect(Collectors.toMap(Function.identity(), ke -> e.code)));
                            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                        }
                        long st2 = System.currentTimeMillis();
                        if (log.isTraceEnabled()) {
                            log.trace("sent " + String.format("%,d", count) + " mutations to " + this.location + " in " + String.format("%.2f secs (%,.2f mutations/sec) with %,d failures", (double)(st2 - st1) / 1000.0, (double)count / ((double)(st2 - st1) / 1000.0), failures.size()));
                        }
                        long successBytes = 0L;
                        for (Map.Entry<KeyExtent, List<Mutation>> entry : mutationBatch.entrySet()) {
                            for (Mutation mutation : entry.getValue()) {
                                successBytes += mutation.estimatedMemoryUsed();
                            }
                        }
                        if (failures.size() > 0) {
                            TabletServerBatchWriter.this.failedMutations.add(failures);
                            successBytes -= failures.getMemoryUsed();
                        }
                        TabletServerBatchWriter.this.updateSendStats(count, st2 - st1);
                        TabletServerBatchWriter.this.decrementMemUsed(successBytes);
                    }
                    catch (Exception e) {
                        TraceUtil.setException(span, e, true);
                        throw e;
                    }
                    finally {
                        span.end();
                    }
                }
                catch (IOException e) {
                    log.debug("failed to send mutations to {}", (Object)this.location, (Object)e);
                    HashSet<TableId> tables = new HashSet<TableId>();
                    for (KeyExtent ke2 : mutationBatch.keySet()) {
                        tables.add(ke2.tableId());
                    }
                    for (TableId table : tables) {
                        MutationWriter.this.getLocator(table).invalidateCache(TabletServerBatchWriter.this.context, this.location);
                    }
                    TabletServerBatchWriter.this.failedMutations.add(tsm);
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        }

        class SessionCloser
        implements AutoCloseable {
            private final String location;
            private OptionalLong usid;

            SessionCloser(String location) {
                this.location = location;
                this.usid = OptionalLong.empty();
            }

            void setSession(long usid) {
                this.usid = OptionalLong.of(usid);
            }

            public long getSession() {
                return this.usid.getAsLong();
            }

            void clearSession() {
                this.usid = OptionalLong.empty();
            }

            @Override
            public void close() throws ThriftSecurityException {
                if (this.usid.isPresent()) {
                    try {
                        this.cancelSession();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }

            private boolean isALockHeld(String tserver) {
                String root = TabletServerBatchWriter.this.context.getZooKeeperRoot() + "/tservers";
                ServiceLock.ServiceLockPath zLockPath = ServiceLock.path(root + "/" + tserver);
                return ServiceLock.getSessionId(TabletServerBatchWriter.this.context.getZooCache(), zLockPath) != 0L;
            }

            /*
             * Exception decompiling
             */
            private void cancelSession() throws InterruptedException, ThriftSecurityException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
    }

    private static interface WaitCondition {
        public boolean shouldWait();
    }

    private static class TimeoutTracker {
        final String server;
        final long timeOut;
        long activityTime;
        Long firstErrorTime = null;

        TimeoutTracker(String server, long timeOut) {
            this.timeOut = timeOut;
            this.server = server;
        }

        void startingWrite() {
            this.activityTime = System.currentTimeMillis();
        }

        void madeProgress() {
            this.activityTime = System.currentTimeMillis();
            this.firstErrorTime = null;
        }

        void wroteNothing() {
            if (this.firstErrorTime == null) {
                this.firstErrorTime = this.activityTime;
            } else if (System.currentTimeMillis() - this.firstErrorTime > this.timeOut) {
                throw new TimedOutException(Collections.singleton(this.server));
            }
        }

        void errorOccured() {
            this.wroteNothing();
        }

        public long getTimeOut() {
            return this.timeOut;
        }
    }
}

