/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedWorkQueue {
    private static final SecureRandom random = new SecureRandom();
    private static final String LOCKS_NODE = "locks";
    private static final Logger log = LoggerFactory.getLogger(DistributedWorkQueue.class);
    private ThreadPoolExecutor threadPool;
    private ZooReaderWriter zoo;
    private String path;
    private ServerContext context;
    private long timerInitialDelay;
    private long timerPeriod;
    private AtomicInteger numTask = new AtomicInteger(0);

    private void lookForWork(final Processor processor, List<String> children) {
        if (children.isEmpty()) {
            return;
        }
        if (this.numTask.get() >= this.threadPool.getCorePoolSize()) {
            return;
        }
        Collections.shuffle(children, random);
        try {
            for (final String child : children) {
                if (child.equals(LOCKS_NODE)) continue;
                final String lockPath = this.path + "/locks/" + child;
                try {
                    this.zoo.putEphemeralData(lockPath, new byte[0]);
                }
                catch (KeeperException.NodeExistsException nee) {
                    continue;
                }
                final String childPath = this.path + "/" + child;
                if (!this.zoo.exists(childPath)) {
                    this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                    continue;
                }
                if (this.numTask.get() >= this.threadPool.getCorePoolSize()) {
                    this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                    break;
                }
                log.debug("got lock for {}", (Object)child);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                processor.newProcessor().process(child, DistributedWorkQueue.this.zoo.getData(childPath));
                                try {
                                    DistributedWorkQueue.this.zoo.recursiveDelete(childPath, ZooUtil.NodeMissingPolicy.SKIP);
                                }
                                catch (Exception e) {
                                    log.error("Error received when trying to delete entry in zookeeper " + childPath, (Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                log.warn("Failed to process work " + child, (Throwable)e);
                            }
                            try {
                                DistributedWorkQueue.this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                            }
                            catch (Exception e) {
                                log.error("Error received when trying to delete entry in zookeeper " + childPath, (Throwable)e);
                            }
                        }
                        finally {
                            DistributedWorkQueue.this.numTask.decrementAndGet();
                        }
                        try {
                            DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path));
                        }
                        catch (KeeperException e) {
                            log.error("Failed to look for work", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.info("Interrupted looking for work", (Throwable)e);
                        }
                    }
                };
                this.numTask.incrementAndGet();
                this.threadPool.execute(task);
            }
        }
        catch (Exception t) {
            log.error("Unexpected error", (Throwable)t);
        }
    }

    public DistributedWorkQueue(String path, AccumuloConfiguration config, ServerContext context) {
        this(path, config, context, random.nextInt(Math.toIntExact(TimeUnit.MINUTES.toMillis(1L))), TimeUnit.MINUTES.toMillis(1L));
    }

    public DistributedWorkQueue(String path, AccumuloConfiguration config, ServerContext context, long timerInitialDelay, long timerPeriod) {
        this.path = path;
        this.context = context;
        this.timerInitialDelay = timerInitialDelay;
        this.timerPeriod = timerPeriod;
        this.zoo = context.getZooReaderWriter();
    }

    public ServerContext getContext() {
        return this.context;
    }

    public void startProcessing(final Processor processor, ThreadPoolExecutor executorService) throws KeeperException, InterruptedException {
        this.threadPool = executorService;
        this.zoo.mkdirs(this.path);
        this.zoo.mkdirs(this.path + "/locks");
        List children = this.zoo.getChildren(this.path, new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case NodeChildrenChanged: {
                        if (event.getPath().equals(DistributedWorkQueue.this.path)) {
                            try {
                                DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path, (Watcher)this));
                            }
                            catch (KeeperException e) {
                                log.error("Failed to look for work at path {}; {}", new Object[]{DistributedWorkQueue.this.path, event, e});
                            }
                            catch (InterruptedException e) {
                                log.info("Interrupted looking for work at path {}; {}", new Object[]{DistributedWorkQueue.this.path, event, e});
                            }
                            break;
                        }
                        log.info("Unexpected path for NodeChildrenChanged event watching path {}; {}", (Object)DistributedWorkQueue.this.path, (Object)event);
                        break;
                    }
                    default: {
                        log.info("Unexpected event watching path {}; {}", (Object)DistributedWorkQueue.this.path, (Object)event);
                    }
                }
            }
        });
        this.lookForWork(processor, children);
        ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                log.debug("Looking for work in {}", (Object)DistributedWorkQueue.this.path);
                try {
                    DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path));
                }
                catch (KeeperException e) {
                    log.error("Failed to look for work", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.info("Interrupted looking for work", (Throwable)e);
                }
            }
        }, this.timerInitialDelay, this.timerPeriod, TimeUnit.MILLISECONDS));
    }

    public void addWork(String workId, String data) throws KeeperException, InterruptedException {
        this.addWork(workId, data.getBytes(StandardCharsets.UTF_8));
    }

    public void addWork(String workId, byte[] data) throws KeeperException, InterruptedException {
        if (workId.equalsIgnoreCase(LOCKS_NODE)) {
            throw new IllegalArgumentException("locks is reserved work id");
        }
        this.zoo.mkdirs(this.path);
        this.zoo.putPersistentData(this.path + "/" + workId, data, ZooUtil.NodeExistsPolicy.SKIP);
    }

    public List<String> getWorkQueued() throws KeeperException, InterruptedException {
        ArrayList<String> children = new ArrayList<String>(this.zoo.getChildren(this.path));
        children.remove(LOCKS_NODE);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone(Set<String> workIDs) throws KeeperException, InterruptedException {
        final Object condVar = new Object();
        Watcher watcher = new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case NodeChildrenChanged: {
                        Object object = condVar;
                        synchronized (object) {
                            condVar.notify();
                            break;
                        }
                    }
                    default: {
                        log.info("Got unexpected zookeeper event for path {}: {}", (Object)DistributedWorkQueue.this.path, (Object)event);
                    }
                }
            }
        };
        List children = this.zoo.getChildren(this.path, watcher);
        while (!Collections.disjoint(children, workIDs)) {
            Object object = condVar;
            synchronized (object) {
                condVar.wait(10000L);
            }
            children = this.zoo.getChildren(this.path, watcher);
        }
    }

    public static interface Processor {
        public Processor newProcessor();

        public void process(String var1, byte[] var2);
    }
}

