/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.compaction.thrift.CompactorService;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooSession;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.compaction.RunningCompaction;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCompactionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalCompactionUtil.class);

    public static String getHostPortString(HostAndPort address) {
        if (address == null) {
            return null;
        }
        return address.toString();
    }

    public static Optional<HostAndPort> findCompactionCoordinator(ClientContext context) {
        String lockPath = context.getZooKeeperRoot() + "/coordinators/lock";
        try {
            ZooKeeper zk = ZooSession.getAnonymousSession(context.getZooKeepers(), context.getZooKeepersSessionTimeOut());
            byte[] address = ServiceLock.getLockData(zk, ServiceLock.path(lockPath));
            if (null == address) {
                return Optional.empty();
            }
            return Optional.of(HostAndPort.fromString(new String(address)));
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<HostAndPort>> getCompactorAddrs(ClientContext context) {
        try {
            HashMap<String, List<HostAndPort>> queuesAndAddresses = new HashMap<String, List<HostAndPort>>();
            String compactorQueuesPath = context.getZooKeeperRoot() + "/compactors";
            ZooReader zooReader = context.getZooReader();
            List<String> queues = zooReader.getChildren(compactorQueuesPath);
            for (String queue : queues) {
                queuesAndAddresses.putIfAbsent(queue, new ArrayList());
                try {
                    List<String> compactors = zooReader.getChildren(compactorQueuesPath + "/" + queue);
                    for (String compactor : compactors) {
                        List<String> children = zooReader.getChildren(compactorQueuesPath + "/" + queue + "/" + compactor);
                        if (children.isEmpty()) continue;
                        LOG.trace("Found live compactor {} ", (Object)compactor);
                        ((List)queuesAndAddresses.get(queue)).add(HostAndPort.fromString(compactor));
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.trace("Ignoring node that went missing", (Throwable)e);
                }
            }
            return queuesAndAddresses;
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static List<ActiveCompaction> getActiveCompaction(HostAndPort compactor, ClientContext context) throws ThriftSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TExternalCompactionJob getRunningCompaction(HostAndPort compactorAddr, ClientContext context) {
        CompactorService.Client client;
        block4: {
            TExternalCompactionJob tExternalCompactionJob;
            client = null;
            try {
                client = ThriftUtil.getClient(ThriftClientTypes.COMPACTOR, compactorAddr, context);
                TExternalCompactionJob job = client.getRunningCompaction(TraceUtil.traceInfo(), context.rpcCreds());
                if (job.getExternalCompactionId() == null) break block4;
                LOG.debug("Compactor {} is running {}", (Object)compactorAddr, (Object)job.getExternalCompactionId());
                tExternalCompactionJob = job;
            }
            catch (TException e) {
                try {
                    LOG.debug("Failed to contact compactor {}", (Object)compactorAddr, (Object)e);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, context);
                    throw throwable;
                }
                ThriftUtil.returnClient(client, context);
            }
            ThriftUtil.returnClient(client, context);
            return tExternalCompactionJob;
        }
        ThriftUtil.returnClient(client, context);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExternalCompactionId getRunningCompactionId(HostAndPort compactorAddr, ClientContext context) {
        CompactorService.Client client;
        block4: {
            ExternalCompactionId externalCompactionId;
            client = null;
            try {
                client = ThriftUtil.getClient(ThriftClientTypes.COMPACTOR, compactorAddr, context);
                String secid = client.getRunningCompactionId(TraceUtil.traceInfo(), context.rpcCreds());
                if (secid.isEmpty()) break block4;
                externalCompactionId = ExternalCompactionId.of(secid);
            }
            catch (TException e) {
                try {
                    LOG.debug("Failed to contact compactor {}", (Object)compactorAddr, (Object)e);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, context);
                    throw throwable;
                }
                ThriftUtil.returnClient(client, context);
            }
            ThriftUtil.returnClient(client, context);
            return externalCompactionId;
        }
        ThriftUtil.returnClient(client, context);
        return null;
    }

    public static List<RunningCompaction> getCompactionsRunningOnCompactors(ClientContext context) {
        ArrayList rcFutures = new ArrayList();
        ThreadPoolExecutor executor = ThreadPools.getServerThreadPools().createFixedThreadPool(16, "CompactorRunningCompactions", false);
        ExternalCompactionUtil.getCompactorAddrs(context).forEach((q, hp) -> hp.forEach(hostAndPort -> rcFutures.add(new RunningCompactionFuture((String)q, (HostAndPort)hostAndPort, executor.submit(() -> ExternalCompactionUtil.getRunningCompaction(hostAndPort, context))))));
        executor.shutdown();
        ArrayList<RunningCompaction> results = new ArrayList<RunningCompaction>();
        rcFutures.forEach(rcf -> {
            try {
                TExternalCompactionJob job = rcf.getFuture().get();
                if (null != job && null != job.getExternalCompactionId()) {
                    String compactorAddress = ExternalCompactionUtil.getHostPortString(rcf.getCompactor());
                    results.add(new RunningCompaction(job, compactorAddress, rcf.getQueue()));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return results;
    }

    public static Collection<ExternalCompactionId> getCompactionIdsRunningOnCompactors(ClientContext context) {
        ThreadPoolExecutor executor = ThreadPools.getServerThreadPools().createFixedThreadPool(16, "CompactorRunningCompactions", false);
        ArrayList futures = new ArrayList();
        ExternalCompactionUtil.getCompactorAddrs(context).forEach((q, hp) -> hp.forEach(hostAndPort -> futures.add(executor.submit(() -> ExternalCompactionUtil.getRunningCompactionId(hostAndPort, context)))));
        executor.shutdown();
        HashSet<ExternalCompactionId> runningIds = new HashSet<ExternalCompactionId>();
        futures.forEach(future -> {
            try {
                ExternalCompactionId ceid = (ExternalCompactionId)future.get();
                if (ceid != null) {
                    runningIds.add(ceid);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return runningIds;
    }

    public static int countCompactors(String queueName, ClientContext context) {
        String queueRoot = context.getZooKeeperRoot() + "/compactors/" + queueName;
        List<String> children = context.getZooCache().getChildren(queueRoot);
        if (children == null) {
            return 0;
        }
        int count = 0;
        for (String child : children) {
            List<String> children2 = context.getZooCache().getChildren(queueRoot + "/" + child);
            if (children2 == null || children2.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelCompaction(ClientContext context, HostAndPort compactorAddr, String ecid) {
        CompactorService.Client client = null;
        try {
            client = ThriftUtil.getClient(ThriftClientTypes.COMPACTOR, compactorAddr, context);
            client.cancel(TraceUtil.traceInfo(), context.rpcCreds(), ecid);
        }
        catch (TException e) {
            try {
                LOG.debug("Failed to cancel compactor {} for {}", new Object[]{compactorAddr, ecid, e});
            }
            catch (Throwable throwable) {
                ThriftUtil.returnClient(client, context);
                throw throwable;
            }
            ThriftUtil.returnClient(client, context);
        }
        ThriftUtil.returnClient(client, context);
    }

    private static class RunningCompactionFuture {
        private final String queue;
        private final HostAndPort compactor;
        private final Future<TExternalCompactionJob> future;

        public RunningCompactionFuture(String queue, HostAndPort compactor, Future<TExternalCompactionJob> future) {
            this.queue = queue;
            this.compactor = compactor;
            this.future = future;
        }

        public String getQueue() {
            return this.queue;
        }

        public HostAndPort getCompactor() {
            return this.compactor;
        }

        public Future<TExternalCompactionJob> getFuture() {
            return this.future;
        }
    }
}

