/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.clientImpl.OfflineScanner;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.mapreduce.BatchInputSplit;
import org.apache.accumulo.core.clientImpl.mapreduce.SplitUtils;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.InputConfigurator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@Deprecated(since="2.0.0")
public abstract class AbstractInputFormat<K, V>
extends InputFormat<K, V> {
    private static final SecureRandom random = new SecureRandom();
    protected static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setClassLoaderContext(Job job, String context) {
        InputConfigurator.setClassLoaderContext(CLASS, job.getConfiguration(), context);
    }

    public static String getClassLoaderContext(JobContext job) {
        return InputConfigurator.getClassLoaderContext(CLASS, job.getConfiguration());
    }

    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (token instanceof KerberosToken) {
            log.info((Object)"Received KerberosToken, attempting to fetch DelegationToken");
            try {
                ClientContext client = InputConfigurator.client(CLASS, job.getConfiguration());
                token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
            catch (Exception e) {
                log.warn((Object)"Failed to automatically obtain DelegationToken, Mappers/Reducers will likely fail to communicate with Accumulo", (Throwable)e);
            }
        }
        if (token instanceof DelegationTokenImpl) {
            DelegationTokenImpl delegationToken = (DelegationTokenImpl)token;
            AuthenticationTokenIdentifier identifier = delegationToken.getIdentifier();
            Token hadoopToken = new Token(identifier.getBytes(), delegationToken.getPassword(), identifier.getKind(), delegationToken.getServiceName());
            job.getCredentials().addToken(hadoopToken.getService(), hadoopToken);
        }
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    public static void setConnectorInfo(Job job, String principal, String tokenFile) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobContext job) {
        return InputConfigurator.isConnectorInfoSet(CLASS, job.getConfiguration());
    }

    protected static String getPrincipal(JobContext job) {
        return InputConfigurator.getPrincipal(CLASS, job.getConfiguration());
    }

    @Deprecated(since="1.6.0")
    protected static String getTokenClass(JobContext job) {
        return AbstractInputFormat.getAuthenticationToken(job).getClass().getName();
    }

    @Deprecated(since="1.6.0")
    protected static byte[] getToken(JobContext job) {
        return AuthenticationToken.AuthenticationTokenSerializer.serialize(AbstractInputFormat.getAuthenticationToken(job));
    }

    protected static AuthenticationToken getAuthenticationToken(JobContext job) {
        AuthenticationToken token = InputConfigurator.getAuthenticationToken(CLASS, job.getConfiguration());
        return InputConfigurator.unwrapAuthenticationToken(job, token);
    }

    @Deprecated(since="1.6.0")
    public static void setZooKeeperInstance(Job job, String instanceName, String zooKeepers) {
        AbstractInputFormat.setZooKeeperInstance(job, ClientConfiguration.create().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    public static void setZooKeeperInstance(Job job, ClientConfiguration clientConfig) {
        InputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), clientConfig);
    }

    protected static Instance getInstance(JobContext job) {
        return InputConfigurator.getInstance(CLASS, job.getConfiguration());
    }

    public static void setLogLevel(Job job, Level level) {
        InputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext job) {
        return InputConfigurator.getLogLevel(CLASS, job.getConfiguration());
    }

    public static void setScanAuthorizations(Job job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, job.getConfiguration(), auths);
    }

    protected static Authorizations getScanAuthorizations(JobContext job) {
        return InputConfigurator.getScanAuthorizations(CLASS, job.getConfiguration());
    }

    protected static Map<String, InputTableConfig> getInputTableConfigs(JobContext job) {
        return InputConfigurator.getInputTableConfigs(CLASS, job.getConfiguration());
    }

    protected static InputTableConfig getInputTableConfig(JobContext job, String tableName) {
        return InputConfigurator.getInputTableConfig(CLASS, job.getConfiguration(), tableName);
    }

    protected static void validateOptions(JobContext job) throws IOException {
        InputConfigurator.validatePermissions(CLASS, job.getConfiguration());
    }

    protected static ClientConfiguration getClientConfiguration(JobContext job) {
        return InputConfigurator.getClientConfiguration(CLASS, job.getConfiguration());
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobContext job, TableId tableId, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        return InputConfigurator.binOffline(tableId, ranges, InputConfigurator.client(CLASS, job.getConfiguration()));
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Level logLevel = AbstractInputFormat.getLogLevel(job);
        log.setLevel(logLevel);
        AbstractInputFormat.validateOptions(job);
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        Map<String, InputTableConfig> tableConfigs = AbstractInputFormat.getInputTableConfigs(job);
        for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
            List<Range> ranges;
            boolean supportBatchScan;
            TableId tableId;
            ClientContext client;
            String tableName = tableConfigEntry.getKey();
            InputTableConfig tableConfig = tableConfigEntry.getValue();
            try {
                client = InputConfigurator.client(CLASS, job.getConfiguration());
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new IOException(e);
            }
            try {
                tableId = client.getTableId(tableName);
            }
            catch (TableNotFoundException e) {
                throw new IOException(e);
            }
            boolean batchScan = InputConfigurator.isBatchScan(CLASS, job.getConfiguration());
            boolean bl = supportBatchScan = !tableConfig.isOfflineScan() && !tableConfig.shouldUseIsolatedScanners() && !tableConfig.shouldUseLocalIterators();
            if (batchScan && !supportBatchScan) {
                throw new IllegalArgumentException("BatchScanner optimization not available for offline scan, isolated, or local iterators");
            }
            boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
            if (batchScan && !autoAdjust) {
                throw new IllegalArgumentException("AutoAdjustRanges must be enabled when using BatchScanner optimization");
            }
            List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
            if (ranges.isEmpty()) {
                ranges = new ArrayList<Range>(1);
                ranges.add(new Range());
            }
            Map<Object, Object> binnedRanges = new HashMap();
            try {
                if (tableConfig.isOfflineScan()) {
                    binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    while (binnedRanges == null) {
                        UtilWaitThread.sleepUninterruptibly(100 + random.nextInt(100), TimeUnit.MILLISECONDS);
                        binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    }
                } else {
                    TabletLocator tl = TabletLocator.getLocator(client, tableId);
                    tl.invalidateCache();
                    while (!tl.binRanges(client, ranges, binnedRanges).isEmpty()) {
                        client.requireNotDeleted(tableId);
                        client.requireNotOffline(tableId, tableName);
                        binnedRanges.clear();
                        log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                        UtilWaitThread.sleepUninterruptibly(100 + random.nextInt(100), TimeUnit.MILLISECONDS);
                        tl.invalidateCache();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashMap<Range, ArrayList<String>> splitsToAdd = null;
            if (!autoAdjust) {
                splitsToAdd = new HashMap<Range, ArrayList<String>>();
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry tserverBin : binnedRanges.entrySet()) {
                String ip = ((String)tserverBin.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getCanonicalHostName();
                    hostNameCache.put(ip, location);
                }
                for (Map.Entry extentRanges : ((Map)tserverBin.getValue()).entrySet()) {
                    Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                    if (batchScan) {
                        ArrayList<Range> clippedRanges = new ArrayList<Range>();
                        for (Range r : (List)extentRanges.getValue()) {
                            clippedRanges.add(ke.clip(r));
                        }
                        BatchInputSplit split = new BatchInputSplit(tableName, tableId, clippedRanges, new String[]{location});
                        SplitUtils.updateSplit(split, tableConfig, logLevel);
                        splits.add(split);
                        continue;
                    }
                    for (Range r : (List)extentRanges.getValue()) {
                        if (autoAdjust) {
                            RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonical(), ke.clip(r), new String[]{location});
                            SplitUtils.updateSplit(split, tableConfig, logLevel);
                            split.setOffline(tableConfig.isOfflineScan());
                            split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                            split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                            splits.add(split);
                            continue;
                        }
                        ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                        if (locations == null) {
                            locations = new ArrayList<String>(1);
                        }
                        locations.add(location);
                        splitsToAdd.put(r, locations);
                    }
                }
            }
            if (autoAdjust) continue;
            for (Map.Entry entry : splitsToAdd.entrySet()) {
                RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonical(), (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                SplitUtils.updateSplit(split, tableConfig, logLevel);
                split.setOffline(tableConfig.isOfflineScan());
                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                splits.add(split);
            }
        }
        return splits;
    }

    protected static abstract class AbstractRecordReader<K, V>
    extends RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected ScannerBase scannerBase;
        protected RangeInputSplit split;
        protected K currentK = null;
        protected V currentV = null;
        protected Key currentKey = null;

        protected AbstractRecordReader() {
        }

        protected abstract List<IteratorSetting> contextIterators(TaskAttemptContext var1, String var2);

        private void setupIterators(TaskAttemptContext context, ScannerBase scanner, String tableName, RangeInputSplit split) {
            List<IteratorSetting> iterators = null;
            if (split == null) {
                iterators = this.contextIterators(context, tableName);
            } else {
                iterators = split.getIterators();
                if (iterators == null) {
                    iterators = this.contextIterators(context, tableName);
                }
            }
            for (IteratorSetting iterator : iterators) {
                scanner.addScanIterator(iterator);
            }
        }

        @Deprecated(since="1.7.0")
        protected void setupIterators(TaskAttemptContext context, Scanner scanner, String tableName, RangeInputSplit split) {
            this.setupIterators(context, (ScannerBase)scanner, tableName, split);
        }

        /*
         * WARNING - void declaration
         */
        public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.split));
            Authorizations authorizations = AbstractInputFormat.getScanAuthorizations((JobContext)attempt);
            String classLoaderContext = AbstractInputFormat.getClassLoaderContext((JobContext)attempt);
            String table = this.split.getTableName();
            InputTableConfig tableConfig = AbstractInputFormat.getInputTableConfig((JobContext)attempt, this.split.getTableName());
            ClientContext client = InputConfigurator.client(CLASS, this.split, attempt.getConfiguration());
            log.debug((Object)("Created client with user: " + client.whoami()));
            log.debug((Object)("Creating scanner for table: " + table));
            log.debug((Object)("Authorizations are: " + authorizations));
            if (this.split instanceof BatchInputSplit) {
                BatchScanner scanner;
                BatchInputSplit batchSplit = (BatchInputSplit)this.split;
                try {
                    int n = 1;
                    scanner = client.createBatchScanner(this.split.getTableName(), authorizations, n);
                    this.setupIterators(attempt, scanner, this.split.getTableName(), this.split);
                    if (classLoaderContext != null) {
                        scanner.setClassLoaderContext(classLoaderContext);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException(exception);
                }
                scanner.setRanges(batchSplit.getRanges());
                this.scannerBase = scanner;
            } else {
                ScannerOptions scanner;
                Boolean usesLocalIterators;
                Boolean bl;
                Object isOffline = this.split.isOffline();
                if (isOffline == null) {
                    isOffline = tableConfig.isOfflineScan();
                }
                if ((bl = this.split.isIsolatedScan()) == null) {
                    Boolean bl2 = tableConfig.shouldUseIsolatedScanners();
                }
                if ((usesLocalIterators = this.split.usesLocalIterators()) == null) {
                    usesLocalIterators = tableConfig.shouldUseLocalIterators();
                }
                try {
                    void var10_13;
                    scanner = ((Boolean)isOffline).booleanValue() ? new OfflineScanner(client, TableId.of(this.split.getTableId()), authorizations) : new ScannerImpl(client, TableId.of(this.split.getTableId()), authorizations);
                    if (var10_13.booleanValue()) {
                        log.info((Object)"Creating isolated scanner");
                        scanner = new IsolatedScanner((Scanner)((Object)scanner));
                    }
                    if (usesLocalIterators.booleanValue()) {
                        log.info((Object)"Using local iterators");
                        scanner = new ClientSideIteratorScanner((Scanner)((Object)scanner));
                    }
                    this.setupIterators(attempt, (Scanner)((Object)scanner), this.split.getTableName(), this.split);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                scanner.setRange(this.split.getRange());
                this.scannerBase = scanner;
            }
            Collection<Pair<Text, Text>> columns = this.split.getFetchedColumns();
            if (columns == null) {
                columns = tableConfig.getFetchedColumns();
            }
            for (Pair pair : columns) {
                if (pair.getSecond() != null) {
                    log.debug((Object)("Fetching column " + pair.getFirst() + ":" + pair.getSecond()));
                    this.scannerBase.fetchColumn((Text)pair.getFirst(), (Text)pair.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + pair.getFirst()));
                this.scannerBase.fetchColumnFamily((Text)pair.getFirst());
            }
            SamplerConfiguration samplerConfig = this.split.getSamplerConfiguration();
            if (samplerConfig == null) {
                samplerConfig = tableConfig.getSamplerConfiguration();
            }
            if (samplerConfig != null) {
                this.scannerBase.setSamplerConfiguration(samplerConfig);
            }
            this.scannerIterator = this.scannerBase.iterator();
            this.numKeysRead = 0L;
        }

        public void close() {
            if (this.scannerBase != null) {
                this.scannerBase.close();
            }
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentK;
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.currentV;
        }
    }
}

