/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.classloader;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.common.ContextClassLoaderFactory;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextClassLoaderFactory
implements ContextClassLoaderFactory {
    private static final AtomicBoolean isInstantiated = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextClassLoaderFactory.class);
    private static final String className = DefaultContextClassLoaderFactory.class.getName();
    private static final Property VFS_CONTEXT_CLASSPATH_PROPERTY = Property.VFS_CONTEXT_CLASSPATH_PROPERTY;

    public DefaultContextClassLoaderFactory(AccumuloConfiguration accConf) {
        if (!isInstantiated.compareAndSet(false, true)) {
            throw new IllegalStateException("Can only instantiate " + className + " once");
        }
        Supplier<Map<String, String>> contextConfigSupplier = () -> accConf.getAllPropertiesWithPrefix(VFS_CONTEXT_CLASSPATH_PROPERTY);
        DefaultContextClassLoaderFactory.setContextConfig(contextConfigSupplier);
        LOG.debug("ContextManager configuration set");
        DefaultContextClassLoaderFactory.startCleanupThread(accConf, contextConfigSupplier);
    }

    private static void setContextConfig(Supplier<Map<String, String>> contextConfigSupplier) {
        AccumuloVFSClassLoader.setContextConfig(contextConfigSupplier);
    }

    private static void startCleanupThread(AccumuloConfiguration conf, Supplier<Map<String, String>> contextConfigSupplier) {
        ScheduledFuture<?> future = ThreadPools.getClientThreadPools((t, e) -> LOG.error("context classloader cleanup thread has failed.", e)).createGeneralScheduledExecutorService(conf).scheduleWithFixedDelay(Threads.createNamedRunnable(className + "-cleanup", () -> {
            LOG.trace("{}-cleanup thread, properties: {}", (Object)className, (Object)conf);
            Set<String> contextsInUse = ((Map)contextConfigSupplier.get()).keySet().stream().map(p -> p.substring(VFS_CONTEXT_CLASSPATH_PROPERTY.getKey().length())).collect(Collectors.toSet());
            LOG.trace("{}-cleanup thread, contexts in use: {}", (Object)className, contextsInUse);
            DefaultContextClassLoaderFactory.removeUnusedContexts(contextsInUse);
        }), 1L, 1L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
        LOG.debug("Context cleanup timer started at 60s intervals");
    }

    private static void removeUnusedContexts(Set<String> contextsInUse) {
        AccumuloVFSClassLoader.removeUnusedContexts(contextsInUse);
    }

    @Override
    public ClassLoader getClassLoader(String contextName) {
        return AccumuloVFSClassLoader.getContextClassLoader((String)contextName);
    }
}

