/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;

public class TabletServerScanMetrics
implements MetricsProducer {
    private final AtomicInteger openFiles = new AtomicInteger(0);
    private Timer scans;
    private DistributionSummary resultsPerScan;
    private DistributionSummary yields;
    private Counter startScanCalls;
    private Counter continueScanCalls;
    private Counter closeScanCalls;
    private Counter busyTimeoutReturned;
    private final LongAdder lookupCount = new LongAdder();
    private final LongAdder queryResultCount = new LongAdder();
    private final LongAdder queryResultBytes = new LongAdder();
    private final LongAdder scannedCount = new LongAdder();

    public void incrementLookupCount(long amount) {
        this.lookupCount.add(amount);
    }

    public long getLookupCount() {
        return this.lookupCount.sum();
    }

    public void incrementQueryResultCount(long amount) {
        this.queryResultCount.add(amount);
    }

    public long getQueryResultCount() {
        return this.queryResultCount.sum();
    }

    public void incrementQueryResultBytes(long amount) {
        this.queryResultBytes.add(amount);
    }

    public long getQueryByteCount() {
        return this.queryResultBytes.sum();
    }

    public void incrementScannedCount(long amount) {
        this.scannedCount.add(amount);
    }

    public LongAdder getScannedCounter() {
        return this.scannedCount;
    }

    public long getScannedCount() {
        return this.scannedCount.sum();
    }

    public void addScan(long value) {
        this.scans.record(Duration.ofMillis(value));
    }

    public void addResult(long value) {
        this.resultsPerScan.record((double)value);
    }

    public void addYield(long value) {
        this.yields.record((double)value);
    }

    public void incrementOpenFiles(int delta) {
        this.openFiles.addAndGet(Math.max(0, delta));
    }

    public void decrementOpenFiles(int delta) {
        this.openFiles.addAndGet(delta < 0 ? delta : delta * -1);
    }

    public void incrementStartScan(double value) {
        this.startScanCalls.increment(value);
    }

    public void incrementContinueScan(double value) {
        this.continueScanCalls.increment(value);
    }

    public void incrementCloseScan(double value) {
        this.closeScanCalls.increment(value);
    }

    public void incrementScanBusyTimeout(double value) {
        this.busyTimeoutReturned.increment(value);
    }

    public void registerMetrics(MeterRegistry registry) {
        Gauge.builder((String)"accumulo.tserver.scans.files.open", this.openFiles::get).description("Number of files open for scans").register(registry);
        this.scans = Timer.builder((String)"accumulo.tserver.scans").description("Scans").register(registry);
        this.resultsPerScan = DistributionSummary.builder((String)"accumulo.tserver.scans.result").description("Results per scan").register(registry);
        this.yields = DistributionSummary.builder((String)"accumulo.tserver.scans.yields").description("yields").register(registry);
        this.startScanCalls = Counter.builder((String)"accumulo.tserver.scans.start").description("calls to start a scan / multiscan").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.continueScanCalls = Counter.builder((String)"accumulo.tserver.scans.continue").description("calls to continue a scan / multiscan").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.closeScanCalls = Counter.builder((String)"accumulo.tserver.scans.close").description("calls to close a scan / multiscan").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.busyTimeoutReturned = Counter.builder((String)"accumulo.tserver.scans.busy_timeout").description("times that a scan has timed out in the queue").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        Gauge.builder((String)"accumulo.tserver.queries", (Object)this, TabletServerScanMetrics::getLookupCount).description("Number of queries").register(registry);
        Gauge.builder((String)"accumulo.tserver.scan.results", (Object)this, TabletServerScanMetrics::getQueryResultCount).description("Query rate (entries/sec)").register(registry);
        Gauge.builder((String)"accumulo.tserver.scan.results.bytes", (Object)this, TabletServerScanMetrics::getQueryByteCount).description("Query rate (bytes/sec)").register(registry);
        Gauge.builder((String)"accumulo.tserver.scan.scanned.entries", (Object)this, TabletServerScanMetrics::getScannedCount).description("Scanned rate").register(registry);
    }
}

