/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.miniclusterImpl;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterControl
implements ClusterControl {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterControl.class);
    protected MiniAccumuloClusterImpl cluster;
    Process zooKeeperProcess = null;
    Process masterProcess = null;
    Process gcProcess = null;
    Process monitor = null;
    Process tracer = null;
    final List<Process> tabletServerProcesses = new ArrayList<Process>();

    public MiniAccumuloClusterControl(MiniAccumuloClusterImpl cluster) {
        Objects.requireNonNull(cluster);
        this.cluster = cluster;
    }

    public void start(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public int exec(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        Process p = this.cluster.exec(clz, args).getProcess();
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return exitCode;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public Map.Entry<Integer, String> execWithStdout(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        MiniAccumuloClusterImpl.ProcessInfo pi = this.cluster.exec(clz, args);
        try {
            exitCode = pi.getProcess().waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return Maps.immutableEntry((Object)exitCode, (Object)pi.readStdOut());
    }

    @Override
    public void adminStopAll() throws IOException {
        Process p = this.cluster.exec(Admin.class, "stopAll").getProcess();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        if (p.exitValue() != 0) {
            throw new IOException("Failed to run `accumulo admin stopAll`");
        }
    }

    @Override
    public synchronized void startAllServers(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public synchronized void start(ServerType server, String hostname) throws IOException {
        this.start(server, Collections.emptyMap(), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(ServerType server, Map<String, String> configOverrides, int limit) throws IOException {
        if (limit <= 0) {
            return;
        }
        switch (server) {
            case TABLET_SERVER: {
                List<Process> list = this.tabletServerProcesses;
                synchronized (list) {
                    int count = 0;
                    for (int i = this.tabletServerProcesses.size(); count < limit && i < this.cluster.getConfig().getNumTservers(); ++i, ++count) {
                        this.tabletServerProcesses.add(this.cluster._exec(TabletServer.class, server, configOverrides, new String[0]).getProcess());
                    }
                    break;
                }
            }
            case MASTER: {
                if (this.masterProcess != null) break;
                this.masterProcess = this.cluster._exec(Master.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case ZOOKEEPER: {
                if (this.zooKeeperProcess != null) break;
                this.zooKeeperProcess = this.cluster._exec(ZooKeeperServerMain.class, server, configOverrides, this.cluster.getZooCfgFile().getAbsolutePath()).getProcess();
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (this.gcProcess != null) break;
                this.gcProcess = this.cluster._exec(SimpleGarbageCollector.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case MONITOR: {
                if (this.monitor != null) break;
                this.monitor = this.cluster._exec(Monitor.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case TRACER: {
                if (this.tracer != null) break;
                this.tracer = this.cluster._exec(TraceServer.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot start process for " + (Object)((Object)server));
            }
        }
    }

    @Override
    public synchronized void stopAllServers(ServerType server) throws IOException {
        this.stop(server);
    }

    public void stop(ServerType server) throws IOException {
        this.stop(server, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(ServerType server, String hostname) throws IOException {
        switch (server) {
            case MASTER: {
                if (this.masterProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.masterProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.masterProcess = null;
                }
            }
            case GARBAGE_COLLECTOR: {
                if (this.gcProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Garbage collector did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.gcProcess = null;
                }
            }
            case ZOOKEEPER: {
                if (this.zooKeeperProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.zooKeeperProcess = null;
                }
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    try {
                        for (Process tserver : this.tabletServerProcesses) {
                            try {
                                this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                            }
                            catch (ExecutionException | TimeoutException e2) {
                                log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        break;
                    }
                    finally {
                        this.tabletServerProcesses.clear();
                    }
                }
            }
            case MONITOR: {
                if (this.monitor == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.monitor, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Monitor did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.monitor = null;
                }
            }
            case TRACER: {
                if (this.tracer == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.tracer, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Tracer did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.tracer = null;
                }
            }
            default: {
                throw new UnsupportedOperationException("ServerType is not yet supported " + (Object)((Object)server));
            }
        }
    }

    @Override
    public void signal(ServerType server, String hostname, String signal) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(ServerType type, ProcessReference procRef) throws ProcessNotFoundException, InterruptedException {
        boolean found = false;
        switch (type) {
            case MASTER: {
                if (!procRef.getProcess().equals(this.masterProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.masterProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                }
                this.masterProcess = null;
                found = true;
                break;
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    for (Process tserver : this.tabletServerProcesses) {
                        if (!procRef.getProcess().equals(tserver)) continue;
                        this.tabletServerProcesses.remove(tserver);
                        try {
                            this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException | TimeoutException e2) {
                            log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                        }
                        found = true;
                        break;
                    }
                    break;
                }
            }
            case ZOOKEEPER: {
                if (!procRef.getProcess().equals(this.zooKeeperProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                }
                this.zooKeeperProcess = null;
                found = true;
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (!procRef.getProcess().equals(this.gcProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("GarbageCollector did not fully stop after 30 seconds", (Throwable)e);
                }
                this.gcProcess = null;
                found = true;
                break;
            }
            default: {
                found = true;
            }
        }
        if (!found) {
            throw new ProcessNotFoundException();
        }
    }

    @Override
    public void kill(ServerType server, String hostname) throws IOException {
        this.stop(server, hostname);
    }
}

