/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.fate.FateTxId;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(MasterMetadataUtil.class);

    public static void addNewTablet(ServerContext context, KeyExtent extent, String path, TServerInstance location, Map<FileRef, DataFileValue> datafileSizes, Map<Long, ? extends Collection<FileRef>> bulkLoadedFiles, String time, long lastFlushID, long lastCompactID, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(path.getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
        if (lastFlushID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value(("" + lastFlushID).getBytes()));
        }
        if (lastCompactID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + lastCompactID).getBytes()));
        }
        if (location != null) {
            location.putLocation(m);
            location.clearFutureLocation(m);
        }
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().meta(), new Value(entry.getValue().encode()));
        }
        for (Map.Entry<Comparable<FileRef>, Object> entry : bulkLoadedFiles.entrySet()) {
            Value tidVal = new Value((CharSequence)FateTxId.formatTid((long)((Long)entry.getKey())));
            for (FileRef ref : (Collection)entry.getValue()) {
                m.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, ref.meta(), tidVal);
            }
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static KeyExtent fixSplit(ServerContext context, Text metadataEntry, SortedMap<ColumnFQ, Value> columns, ZooLock lock) throws AccumuloException {
        log.info("Incomplete split {} attempting to fix", (Object)metadataEntry);
        Value oper = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN);
        if (columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN) == null) {
            throw new IllegalArgumentException("Metadata entry does not have split ratio (" + metadataEntry + ")");
        }
        double splitRatio = Double.parseDouble(new String(((Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN)).get(), StandardCharsets.UTF_8));
        Value prevEndRowIBW = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
        if (prevEndRowIBW == null) {
            throw new IllegalArgumentException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        Value time = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        if (time == null) {
            throw new IllegalArgumentException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        Text metadataPrevEndRow = KeyExtent.decodePrevEndRow((Value)prevEndRowIBW);
        TableId tableId = new KeyExtent(metadataEntry, (Text)null).getTableId();
        return MasterMetadataUtil.fixSplit(context, tableId, metadataEntry, metadataPrevEndRow, oper, splitRatio, lock);
    }

    private static KeyExtent fixSplit(ServerContext context, TableId tableId, Text metadataEntry, Text metadataPrevEndRow, Value oper, double splitRatio, ZooLock lock) throws AccumuloException {
        if (metadataPrevEndRow == null) {
            throw new AccumuloException("Split tablet does not have prev end row, something is amiss, extent = " + metadataEntry);
        }
        Key prevRowKey = new Key(new Text(MetadataSchema.TabletsSection.getRow((TableId)tableId, (Text)metadataPrevEndRow)));
        try (ScannerImpl scanner2 = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
            scanner2.setRange(new Range(prevRowKey, prevRowKey.followingKey(PartialKey.ROW)));
            if (!scanner2.iterator().hasNext()) {
                log.info("Rolling back incomplete split {} {}", (Object)metadataEntry, (Object)metadataPrevEndRow);
                MetadataTableUtil.rollBackSplit(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper), context, lock);
                KeyExtent keyExtent = new KeyExtent(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper));
                return keyExtent;
            }
            log.info("Finishing incomplete split {} {}", (Object)metadataEntry, (Object)metadataPrevEndRow);
            ArrayList<FileRef> highDatafilesToRemove = new ArrayList<FileRef>();
            TreeMap<FileRef, DataFileValue> origDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            try (ScannerImpl scanner3 = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
                Key rowKey = new Key(metadataEntry);
                scanner3.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner3.setRange(new Range(rowKey, rowKey.followingKey(PartialKey.ROW)));
                for (Map.Entry entry : scanner3) {
                    if (((Key)entry.getKey()).compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
                    origDatafileSizes.put(new FileRef(context.getVolumeManager(), (Key)entry.getKey()), new DataFileValue(((Value)entry.getValue()).get()));
                }
            }
            MetadataTableUtil.splitDatafiles(metadataPrevEndRow, splitRatio, new HashMap<FileRef, FileUtil.FileInfo>(), origDatafileSizes, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
            MetadataTableUtil.finishSplit(metadataEntry, highDatafileSizes, highDatafilesToRemove, context, lock);
            KeyExtent keyExtent = new KeyExtent(metadataEntry, KeyExtent.encodePrevEndRow((Text)metadataPrevEndRow));
            return keyExtent;
        }
    }

    private static TServerInstance getTServerInstance(String address, ZooLock zooLock) {
        while (true) {
            try {
                return new TServerInstance(address, zooLock.getSessionId());
            }
            catch (InterruptedException | KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public static void replaceDatafiles(ServerContext context, KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, String address, TServerInstance lastLocation, ZooLock zooLock) {
        MasterMetadataUtil.replaceDatafiles(context, extent, datafilesToDelete, scanFiles, path, compactionId, size, address, lastLocation, zooLock, true);
    }

    public static void replaceDatafiles(ServerContext context, KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, String address, TServerInstance lastLocation, ZooLock zooLock, boolean insertDeleteFlags) {
        if (insertDeleteFlags) {
            MetadataTableUtil.addDeleteEntries(extent, datafilesToDelete, context);
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (FileRef pathToRemove : datafilesToDelete) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.meta());
        }
        for (FileRef scanFile : scanFiles) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value(new byte[0]));
        }
        if (size.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(size.encode()));
        }
        if (compactionId != null) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + compactionId).getBytes()));
        }
        TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
        self.putLastLocation(m);
        if (lastLocation != null && !lastLocation.equals(self)) {
            lastLocation.clearLastLocation(m);
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void updateTabletDataFile(ServerContext context, KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        if (extent.isRootTablet()) {
            if (unusedWalLogs != null) {
                MasterMetadataUtil.updateRootTabletDataFile(context, unusedWalLogs);
            }
            return;
        }
        Mutation m = MasterMetadataUtil.getUpdateForTabletDataFile(extent, path, mergeFile, dfv, time, filesInUseByScans, address, zooLock, unusedWalLogs, lastLocation, flushId);
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    private static void updateRootTabletDataFile(ServerContext context, Set<String> unusedWalLogs) {
        ZooReaderWriter zk = context.getZooReaderWriter();
        String root = MetadataTableUtil.getZookeeperLogLocation(context);
        block2: for (String entry : unusedWalLogs) {
            String[] parts = entry.split("/");
            String zpath = root + "/" + parts[parts.length - 1];
            while (true) {
                try {
                    if (!zk.exists(zpath)) continue block2;
                    log.debug("Removing WAL reference for root table {}", (Object)zpath);
                    zk.recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
                    continue block2;
                }
                catch (InterruptedException | KeeperException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
        }
    }

    private static Mutation getUpdateForTabletDataFile(KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        if (dfv.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(dfv.encode()));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
            TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
            self.putLastLocation(m);
            if (lastLocation != null && !lastLocation.equals(self)) {
                lastLocation.clearLastLocation(m);
            }
        }
        if (unusedWalLogs != null) {
            for (String entry : unusedWalLogs) {
                m.putDelete(MetadataSchema.TabletsSection.LogColumnFamily.NAME, new Text(entry));
            }
        }
        for (FileRef scanFile : filesInUseByScans) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value(new byte[0]));
        }
        if (mergeFile != null) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, mergeFile.meta());
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value(Long.toString(flushId).getBytes(StandardCharsets.UTF_8)));
        return m;
    }
}

