/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DumpZookeeper {
    private static IZooReaderWriter zk = null;

    public static void main(String[] args) throws KeeperException, InterruptedException {
        Opts opts = new Opts();
        opts.parseArgs(DumpZookeeper.class.getName(), args, new Object[0]);
        PrintStream out = System.out;
        zk = new ZooReaderWriter((AccumuloConfiguration)opts.getSiteConfiguration());
        if (opts.xml) {
            DumpZookeeper.writeXml(out, opts.root);
        } else {
            DumpZookeeper.writeHumanReadable(out, opts.root);
        }
    }

    private static void writeXml(PrintStream out, String root) throws KeeperException, InterruptedException {
        DumpZookeeper.write(out, 0, "<dump root='%s'>", root);
        for (String child : zk.getChildren(root, null)) {
            if (child.equals("zookeeper")) continue;
            DumpZookeeper.childXml(out, root, child, 1);
        }
        DumpZookeeper.write(out, 0, "</dump>", new Object[0]);
    }

    private static void childXml(PrintStream out, String root, String child, int indent) throws KeeperException, InterruptedException {
        Stat stat;
        String path = root + "/" + child;
        if (root.endsWith("/")) {
            path = root + child;
        }
        if ((stat = zk.getStatus(path)) == null) {
            return;
        }
        String type = "node";
        if (stat.getEphemeralOwner() != 0L) {
            type = "ephemeral";
        }
        if (stat.getNumChildren() == 0) {
            if (stat.getDataLength() == 0) {
                DumpZookeeper.write(out, indent, "<%s name='%s'/>", type, child);
            } else {
                Encoded value = DumpZookeeper.value(path);
                DumpZookeeper.write(out, indent, "<%s name='%s' encoding='%s' value='%s'/>", type, child, value.encoding, value.value);
            }
        } else {
            if (stat.getDataLength() == 0) {
                DumpZookeeper.write(out, indent, "<%s name='%s'>", type, child);
            } else {
                Encoded value = DumpZookeeper.value(path);
                DumpZookeeper.write(out, indent, "<%s name='%s' encoding='%s' value='%s'>", type, child, value.encoding, value.value);
            }
            for (String c : zk.getChildren(path, null)) {
                DumpZookeeper.childXml(out, path, c, indent + 1);
            }
            DumpZookeeper.write(out, indent, "</node>", new Object[0]);
        }
    }

    private static Encoded value(String path) throws KeeperException, InterruptedException {
        byte[] data;
        for (byte element : data = zk.getData(path, null)) {
            if (element >= 32 && element <= 126) continue;
            return new Encoded("base64", Base64.getEncoder().encodeToString(data));
        }
        return new Encoded(StandardCharsets.UTF_8.name(), new String(data, StandardCharsets.UTF_8));
    }

    private static void write(PrintStream out, int indent, String fmt, Object ... args) {
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
        out.println(String.format(fmt, args));
    }

    private static void writeHumanReadable(PrintStream out, String root) throws KeeperException, InterruptedException {
        DumpZookeeper.write(out, 0, "%s:", root);
        for (String child : zk.getChildren(root, null)) {
            if (child.equals("zookeeper")) continue;
            DumpZookeeper.childHumanReadable(out, root, child, 1);
        }
    }

    private static void childHumanReadable(PrintStream out, String root, String child, int indent) throws KeeperException, InterruptedException {
        Stat stat;
        String path = root + "/" + child;
        if (root.endsWith("/")) {
            path = root + child;
        }
        if ((stat = zk.getStatus(path)) == null) {
            return;
        }
        String node = child;
        if (stat.getEphemeralOwner() != 0L) {
            node = "*" + child + "*";
        }
        if (stat.getDataLength() == 0) {
            DumpZookeeper.write(out, indent, "%s:", node);
        } else {
            DumpZookeeper.write(out, indent, "%s:  %s", node, DumpZookeeper.value((String)path).value);
        }
        if (stat.getNumChildren() > 0) {
            for (String c : zk.getChildren(path, null)) {
                DumpZookeeper.childHumanReadable(out, path, c, indent + 1);
            }
        }
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"-r", "-root", "--root"}, description="Root ZooKeeper directory to start dump at")
        String root = "/";
        @Parameter(names={"-x", "-xml", "--xml"}, description="Output dump as XML (instead of human readable")
        boolean xml = false;

        Opts() {
        }
    }

    private static class Encoded {
        public String encoding;
        public String value;

        Encoded(String e, String v) {
            this.encoding = e;
            this.value = v;
        }
    }
}

