/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.io.IOException;
import javax.security.sasl.SaslServer;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGIAssumingProcessor
implements TProcessor {
    private static final Logger log = LoggerFactory.getLogger(UGIAssumingProcessor.class);
    public static final ThreadLocal<String> rpcPrincipal = new ThreadLocal();
    public static final ThreadLocal<SaslConnectionParams.SaslMechanism> rpcMechanism = new ThreadLocal();
    private final TProcessor wrapped;
    private final UserGroupInformation loginUser;

    public UGIAssumingProcessor(TProcessor wrapped) {
        this.wrapped = wrapped;
        try {
            this.loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            log.error("Failed to obtain login user", (Throwable)e);
            throw new RuntimeException("Failed to obtain login user", e);
        }
    }

    public static String rpcPrincipal() {
        return rpcPrincipal.get();
    }

    public static ThreadLocal<String> getRpcPrincipalThreadLocal() {
        return rpcPrincipal;
    }

    public static SaslConnectionParams.SaslMechanism rpcMechanism() {
        return rpcMechanism.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
        SaslConnectionParams.SaslMechanism mechanism;
        TTransport trans = inProt.getTransport();
        if (!(trans instanceof TSaslServerTransport)) {
            throw new TException("Unexpected non-SASL transport " + trans.getClass() + ": " + trans);
        }
        TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
        SaslServer saslServer = saslTrans.getSaslServer();
        String endUser = saslServer.getAuthorizationID();
        try {
            mechanism = SaslConnectionParams.SaslMechanism.get((String)saslServer.getMechanismName());
        }
        catch (Exception e) {
            log.error("Failed to process RPC with SASL mechanism {}", (Object)saslServer.getMechanismName());
            throw e;
        }
        switch (mechanism) {
            case GSSAPI: {
                UserGroupInformation clientUgi = UserGroupInformation.createProxyUser((String)endUser, (UserGroupInformation)this.loginUser);
                String remoteUser = clientUgi.getUserName();
                try {
                    rpcPrincipal.set(remoteUser);
                    boolean bl = this.wrapped.process(inProt, outProt);
                    return bl;
                }
                finally {
                    rpcPrincipal.set(null);
                }
            }
            case DIGEST_MD5: {
                try {
                    rpcMechanism.set(mechanism);
                    boolean bl = this.wrapped.process(inProt, outProt);
                    return bl;
                }
                finally {
                    rpcMechanism.set(null);
                }
            }
        }
        throw new IllegalArgumentException("Cannot process SASL mechanism " + mechanism);
    }
}

