/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Metrics
implements MetricsSource {
    private static String processName = "Unknown";
    private final String name;
    private final String description;
    private final String context;
    private final String record;
    private final MetricsRegistry registry;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public static MetricsSystem initSystem(String serviceName) {
        MetricsSystem ms;
        processName = serviceName;
        String serviceInstance = System.getProperty("accumulo.metrics.service.instance", "");
        if (StringUtils.isNotBlank((CharSequence)serviceInstance)) {
            processName = processName + serviceInstance;
        }
        if ((ms = DefaultMetricsSystem.initialize((String)"Accumulo")).getSource(JvmMetricsInfo.JvmMetrics.name()) == null) {
            JvmMetrics.create((String)processName, (String)"", (MetricsSystem)ms);
        }
        return ms;
    }

    protected Metrics(String name, String description, String context, String record) {
        this.name = name;
        this.description = description;
        this.context = context;
        this.record = record;
        this.registry = new MetricsRegistry(Interns.info((String)name, (String)description));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, processName);
    }

    public void register(MetricsSystem system) {
        system.register(this.name, this.description, (Object)this);
    }

    protected final MetricsRegistry getRegistry() {
        return this.registry;
    }

    protected void prepareMetrics() {
    }

    protected void getMoreMetrics(MetricsRecordBuilder builder, boolean all) {
    }

    public final void getMetrics(MetricsCollector collector, boolean all) {
        this.log.trace("getMetrics called with collector: {} (all: {})", (Object)collector, (Object)all);
        this.prepareMetrics();
        MetricsRecordBuilder builder = collector.addRecord(this.record).setContext(this.context);
        this.registry.snapshot(builder, all);
        this.getMoreMetrics(builder, all);
    }
}

