/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerTableVolumeChooser
implements VolumeChooser {
    private static final Logger log = LoggerFactory.getLogger(PerTableVolumeChooser.class);
    private final ConcurrentHashMap<TableId, VolumeChooser> tableSpecificChooserCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<VolumeChooserEnvironment.ChooserScope, VolumeChooser> scopeSpecificChooserCache = new ConcurrentHashMap();
    private final RandomVolumeChooser randomChooser = new RandomVolumeChooser();
    private static final String TABLE_CUSTOM_SUFFIX = "volume.chooser";
    private static final String DEFAULT_SCOPED_VOLUME_CHOOSER = PerTableVolumeChooser.getCustomPropertySuffix(VolumeChooserEnvironment.ChooserScope.DEFAULT);

    private static final String getCustomPropertySuffix(VolumeChooserEnvironment.ChooserScope scope) {
        return "volume.chooser." + scope.name().toLowerCase();
    }

    @Override
    public String choose(VolumeChooserEnvironment env, String[] options) throws VolumeChooser.VolumeChooserException {
        log.trace("{}.choose", (Object)this.getClass().getSimpleName());
        return this.getDelegateChooser(env).choose(env, options);
    }

    VolumeChooser getDelegateChooser(VolumeChooserEnvironment env) {
        switch (env.getScope()) {
            case INIT: {
                log.warn("Not possible to determine delegate chooser at '{}' scope. Using {}.", (Object)VolumeChooserEnvironment.ChooserScope.INIT, (Object)RandomVolumeChooser.class.getName());
                return this.randomChooser;
            }
            case TABLE: {
                return this.getVolumeChooserForTable(env);
            }
        }
        return this.getVolumeChooserForScope(env);
    }

    private VolumeChooser getVolumeChooserForTable(VolumeChooserEnvironment env) {
        log.trace("Looking up property {} for table id: {}", (Object)TABLE_CUSTOM_SUFFIX, (Object)env.getTableId());
        String clazz = env.getServiceEnv().getConfiguration(env.getTableId()).getTableCustom(TABLE_CUSTOM_SUFFIX);
        if (clazz == null || clazz.isEmpty()) {
            clazz = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_VOLUME_CHOOSER);
        }
        if (clazz == null || clazz.isEmpty()) {
            String msg = "Property volume.chooser or " + DEFAULT_SCOPED_VOLUME_CHOOSER + " must be a valid " + VolumeChooser.class.getSimpleName() + " to use the " + this.getClass().getSimpleName();
            throw new VolumeChooser.VolumeChooserException(msg);
        }
        return this.createVolumeChooser(env, clazz, TABLE_CUSTOM_SUFFIX, env.getTableId(), this.tableSpecificChooserCache);
    }

    private VolumeChooser getVolumeChooserForScope(VolumeChooserEnvironment env) {
        VolumeChooserEnvironment.ChooserScope scope = env.getScope();
        String property = PerTableVolumeChooser.getCustomPropertySuffix(scope);
        log.trace("Looking up property {} for scope: {}", (Object)property, (Object)scope);
        String clazz = env.getServiceEnv().getConfiguration().getCustom(property);
        if ((clazz == null || clazz.isEmpty()) && scope != VolumeChooserEnvironment.ChooserScope.DEFAULT) {
            log.debug("{} not found; using {}", (Object)property, (Object)DEFAULT_SCOPED_VOLUME_CHOOSER);
            clazz = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_VOLUME_CHOOSER);
            if (clazz == null || clazz.isEmpty()) {
                String msg = "Property " + property + " or " + DEFAULT_SCOPED_VOLUME_CHOOSER + " must be a valid " + VolumeChooser.class.getSimpleName() + " to use the " + this.getClass().getSimpleName();
                throw new VolumeChooser.VolumeChooserException(msg);
            }
            property = DEFAULT_SCOPED_VOLUME_CHOOSER;
        }
        return this.createVolumeChooser(env, clazz, property, scope, this.scopeSpecificChooserCache);
    }

    private <T> VolumeChooser createVolumeChooser(VolumeChooserEnvironment env, String clazz, String property, T key, ConcurrentHashMap<T, VolumeChooser> cache) {
        String className = clazz.trim();
        return cache.compute(key, (k, previousChooser) -> {
            if (previousChooser != null && previousChooser.getClass().getName().equals(className)) {
                return previousChooser;
            }
            if (previousChooser == null) {
                log.trace("Change detected for {} for {}", (Object)property, key);
            }
            try {
                if (key instanceof TableId) {
                    TableId tableId = (TableId)key;
                    return (VolumeChooser)env.getServiceEnv().instantiate(tableId, className, VolumeChooser.class);
                }
                return (VolumeChooser)env.getServiceEnv().instantiate(className, VolumeChooser.class);
            }
            catch (Exception e) {
                String msg = "Failed to create instance for " + key + " configured to use " + className + " via " + property;
                throw new VolumeChooser.VolumeChooserException(msg, e);
            }
        });
    }
}

