/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections4.MapUtils;

public class TablesCommand
extends Shell.Command {
    static final String NAME_AND_ID_FORMAT = "%-20s => %9s%n";
    private Option tableIdOption;
    private Option sortByTableIdOption;
    private Option disablePaginationOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException, NamespaceNotFoundException {
        String namespace = cl.hasOption(OptUtil.namespaceOpt().getOpt()) ? OptUtil.getNamespaceOpt(cl, shellState) : null;
        TreeMap tables = shellState.getAccumuloClient().tableOperations().tableIdMap();
        tables = Maps.filterKeys((Map)tables, tableName -> namespace == null || ((String)Tables.qualify((String)tableName).getFirst()).equals(namespace));
        boolean sortByTableId = cl.hasOption(this.sortByTableIdOption.getOpt());
        tables = new TreeMap(sortByTableId ? MapUtils.invertMap((Map)tables) : tables);
        Iterator it = Iterators.transform(tables.entrySet().iterator(), entry -> {
            String tableName = String.valueOf(sortByTableId ? entry.getValue() : entry.getKey());
            String tableId = String.valueOf(sortByTableId ? entry.getKey() : entry.getValue());
            if (namespace != null) {
                tableName = (String)Tables.qualify((String)tableName).getSecond();
            }
            if (cl.hasOption(this.tableIdOption.getOpt())) {
                return String.format(NAME_AND_ID_FORMAT, tableName, tableId);
            }
            return tableName;
        });
        shellState.printLines(it, !cl.hasOption(this.disablePaginationOpt.getOpt()));
        return 0;
    }

    @Override
    public String description() {
        return "displays a list of all existing tables";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.tableIdOption = new Option("l", "list-ids", false, "display internal table ids along with the table name");
        o.addOption(this.tableIdOption);
        this.sortByTableIdOption = new Option("s", "sort-ids", false, "with -l: sort output by table ids");
        o.addOption(this.sortByTableIdOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        o.addOption(this.disablePaginationOpt);
        o.addOption(OptUtil.namespaceOpt("name of namespace to list only its tables"));
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

