/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;

public class RenameNamespaceCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, NamespaceNotFoundException, NamespaceExistsException {
        String old = cl.getArgs()[0];
        String newer = cl.getArgs()[1];
        boolean resetContext = false;
        TableId currentTableId = null;
        if (shellState.getTableName() != null && !shellState.getTableName().isEmpty()) {
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)shellState.getContext(), (String)old);
            List tableIds = Namespaces.getTableIds((ClientContext)shellState.getContext(), (NamespaceId)namespaceId);
            currentTableId = Tables.getTableId((ClientContext)shellState.getContext(), (String)shellState.getTableName());
            resetContext = tableIds.contains(currentTableId);
        }
        shellState.getAccumuloClient().namespaceOperations().rename(old, newer);
        if (resetContext) {
            shellState.setTableName(Tables.getTableName((ClientContext)shellState.getContext(), currentTableId));
        }
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <current namespace> <new namespace>";
    }

    @Override
    public String description() {
        return "renames a namespace";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForNamespaces(root, special);
    }

    @Override
    public int numArgs() {
        return 2;
    }
}

