/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.rpc;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.test.rpc.SimpleThriftServiceHandler;
import org.apache.accumulo.test.rpc.SimpleThriftServiceRunner;
import org.apache.accumulo.test.rpc.thrift.SimpleThriftService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;

@Category(value={SunnyDayTests.class})
public class ThriftBehaviorIT {
    @Rule
    public Timeout timeout = new Timeout(5L, TimeUnit.SECONDS);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private SimpleThriftService.Client client;
    private SimpleThriftServiceHandler handler;
    private SimpleThriftServiceRunner serviceRunner;
    private String propName;
    private static final String KITTY_MSG = "\ud83d\udc08 Kitty! \ud83d\udc08";

    @Before
    public void createClientAndServer() {
        String threadName = ThriftBehaviorIT.class.getSimpleName() + "." + this.testName.getMethodName();
        this.serviceRunner = new SimpleThriftServiceRunner(threadName);
        this.serviceRunner.startService();
        this.client = this.serviceRunner.client();
        this.handler = this.serviceRunner.handler();
        this.propName = this.testName.getMethodName();
        if (this.propName.endsWith("Handler")) {
            this.propName = this.propName.substring(0, this.propName.length() - 7);
        }
        this.propName = SimpleThriftServiceHandler.class.getSimpleName() + "." + this.propName;
        System.setProperty(this.propName, "-");
        Assert.assertEquals((Object)"-", (Object)System.getProperty(this.propName));
    }

    @After
    public void shutdownServer() {
        this.serviceRunner.stopService();
        Assert.assertEquals((Object)KITTY_MSG, (Object)System.getProperty(this.propName));
    }

    @Test
    public void echoFailHandler() throws TException {
        this.exception.expect(TException.class);
        this.exception.expectCause(IsInstanceOf.instanceOf(UnsupportedOperationException.class));
        this.handler.echoFail(KITTY_MSG);
    }

    @Test
    public void echoFail() throws TException {
        try {
            this.client.echoFail(KITTY_MSG);
            Assert.fail((String)"Thrift client did not throw an expected exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)TApplicationException.class.getName(), (Object)e.getClass().getName());
        }
        this.echoPass();
    }

    @Test
    public void echoRuntimeFailHandler() {
        this.exception.expect(UnsupportedOperationException.class);
        this.handler.echoRuntimeFail(KITTY_MSG);
    }

    @Test
    public void echoRuntimeFail() throws TException {
        try {
            this.client.echoRuntimeFail(KITTY_MSG);
            Assert.fail((String)"Thrift client did not throw an expected exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)TApplicationException.class.getName(), (Object)e.getClass().getName());
        }
        this.echoPass();
    }

    @Test
    public void echoPassHandler() {
        Assert.assertEquals((Object)KITTY_MSG, (Object)this.handler.echoPass(KITTY_MSG));
    }

    @Test
    public void echoPass() throws TException {
        Assert.assertEquals((Object)KITTY_MSG, (Object)this.client.echoPass(KITTY_MSG));
    }

    @Test
    public void onewayFailHandler() throws TException {
        this.exception.expect(TException.class);
        this.exception.expectCause(IsInstanceOf.instanceOf(UnsupportedOperationException.class));
        this.handler.onewayFail(KITTY_MSG);
    }

    @Test
    public void onewayFail() throws TException {
        this.client.onewayFail(KITTY_MSG);
        this.echoPass();
    }

    @Test
    public void onewayRuntimeFailHandler() {
        this.exception.expect(UnsupportedOperationException.class);
        this.handler.onewayRuntimeFail(KITTY_MSG);
    }

    @Test
    public void onewayRuntimeFail() throws TException {
        this.client.onewayRuntimeFail(KITTY_MSG);
        this.echoPass();
    }

    @Test
    public void onewayPassHandler() {
        this.handler.onewayPass(KITTY_MSG);
    }

    @Test
    public void onewayPass() throws TException {
        this.client.onewayPass(KITTY_MSG);
        this.echoPass();
    }
}

