/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.gc.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.gc.replication.CloseWriteAheadLogReferences;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloseWriteAheadLogReferencesIT
extends ConfigurableMacBase {
    private WrappedCloseWriteAheadLogReferences refs;
    private AccumuloClient client;

    @Before
    public void setupInstance() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), MetadataTable.NAME, TablePermission.WRITE);
        ReplicationTable.setOnline((AccumuloClient)this.client);
    }

    @After
    public void teardownInstance() {
        this.client.close();
    }

    @Before
    public void setupEasyMockStuff() {
        SiteConfiguration siteConfig = (SiteConfiguration)EasyMock.createMock(SiteConfiguration.class);
        ConfigurationCopy systemConf = new ConfigurationCopy(new HashMap());
        ServerConfigurationFactory factory = (ServerConfigurationFactory)EasyMock.createMock(ServerConfigurationFactory.class);
        EasyMock.expect((Object)factory.getSystemConfiguration()).andReturn((Object)systemConf).anyTimes();
        EasyMock.expect((Object)factory.getSiteConfiguration()).andReturn((Object)siteConfig).anyTimes();
        EasyMock.expect((Object)siteConfig.get((Property)EasyMock.anyObject(Property.class))).andAnswer(() -> CloseWriteAheadLogReferencesIT.lambda$setupEasyMockStuff$0((AccumuloConfiguration)systemConf)).anyTimes();
        EasyMock.expect((Object)siteConfig.getBoolean((Property)EasyMock.anyObject(Property.class))).andAnswer(() -> CloseWriteAheadLogReferencesIT.lambda$setupEasyMockStuff$1((AccumuloConfiguration)systemConf)).anyTimes();
        EasyMock.expect((Object)siteConfig.iterator()).andAnswer(() -> CloseWriteAheadLogReferencesIT.lambda$setupEasyMockStuff$2((AccumuloConfiguration)systemConf)).anyTimes();
        ServerContext context = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)context.getServerConfFactory()).andReturn((Object)factory).anyTimes();
        EasyMock.expect((Object)context.getProperties()).andReturn((Object)new Properties()).anyTimes();
        EasyMock.expect((Object)context.getZooKeepers()).andReturn((Object)"localhost").anyTimes();
        EasyMock.expect((Object)context.getInstanceName()).andReturn((Object)"test").anyTimes();
        EasyMock.expect((Object)context.getZooKeepersSessionTimeOut()).andReturn((Object)30000).anyTimes();
        EasyMock.expect((Object)context.getInstanceID()).andReturn((Object)"1111").anyTimes();
        EasyMock.expect((Object)context.getZooKeeperRoot()).andReturn((Object)"/accumulo/1111").anyTimes();
        EasyMock.replay((Object[])new Object[]{factory, siteConfig, context});
        this.refs = new WrappedCloseWriteAheadLogReferences(context);
    }

    @Test
    public void unclosedWalsLeaveStatusOpen() throws Exception {
        Set<String> wals = Collections.emptySet();
        try (BatchWriter bw = this.client.createBatchWriter(MetadataTable.NAME);){
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wal/tserver+port/12345"));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
            bw.addMutation(m);
        }
        this.refs.updateReplicationEntries(this.client, wals);
        try (Scanner s = this.client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            Assert.assertFalse((boolean)status.getClosed());
        }
    }

    @Test
    public void closedWalsUpdateStatus() throws Exception {
        String file = "file:/accumulo/wal/tserver+port/12345";
        Set<String> wals = Collections.singleton(file);
        try (BatchWriter bw = this.client.createBatchWriter(MetadataTable.NAME);){
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
            bw.addMutation(m);
        }
        this.refs.updateReplicationEntries(this.client, wals);
        try (Scanner s = this.client.createScanner(MetadataTable.NAME);){
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            Assert.assertTrue((boolean)status.getClosed());
        }
    }

    @Test
    public void partiallyReplicatedReferencedWalsAreNotClosed() throws Exception {
        String file = "file:/accumulo/wal/tserver+port/12345";
        Set<String> wals = Collections.singleton(file);
        try (BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);){
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"1"), (Value)ProtobufUtil.toValue((GeneratedMessage)StatusUtil.ingestedUntil((long)1000L)));
            bw.addMutation(m);
        }
        this.refs.updateReplicationEntries(this.client, wals);
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            Assert.assertFalse((boolean)status.getClosed());
        }
    }

    private static /* synthetic */ Iterator lambda$setupEasyMockStuff$2(AccumuloConfiguration systemConf) throws Throwable {
        return systemConf.iterator();
    }

    private static /* synthetic */ Boolean lambda$setupEasyMockStuff$1(AccumuloConfiguration systemConf) throws Throwable {
        Object[] args = EasyMock.getCurrentArguments();
        return systemConf.getBoolean((Property)args[0]);
    }

    private static /* synthetic */ String lambda$setupEasyMockStuff$0(AccumuloConfiguration systemConf) throws Throwable {
        Object[] args = EasyMock.getCurrentArguments();
        return systemConf.get((Property)args[0]);
    }

    private static class WrappedCloseWriteAheadLogReferences
    extends CloseWriteAheadLogReferences {
        public WrappedCloseWriteAheadLogReferences(ServerContext context) {
            super(context);
        }

        protected long updateReplicationEntries(AccumuloClient client, Set<String> closedWals) {
            return super.updateReplicationEntries(client, closedWals);
        }
    }
}

