/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MonitorSslIT
extends ConfigurableMacBase {
    @BeforeClass
    public static void initHttps() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        TrustManager[] tm = new TrustManager[]{new TestTrustManager()};
        ctx.init(new KeyManager[0], tm, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new TestHostnameVerifier());
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 360;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        super.configure(cfg, hadoopCoreSite);
        File baseDir = MonitorSslIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName());
        MonitorSslIT.configureForSsl(cfg, MonitorSslIT.getSslDir(baseDir));
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.MONITOR_SSL_KEYSTORE.getKey(), (String)siteConfig.get(Property.RPC_SSL_KEYSTORE_PATH.getKey()));
        siteConfig.put(Property.MONITOR_SSL_KEYSTOREPASS.getKey(), (String)siteConfig.get(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey()));
        if (siteConfig.containsKey(Property.RPC_SSL_KEYSTORE_TYPE.getKey())) {
            siteConfig.put(Property.MONITOR_SSL_KEYSTORETYPE.getKey(), (String)siteConfig.get(Property.RPC_SSL_KEYSTORE_TYPE.getKey()));
        } else {
            siteConfig.put(Property.MONITOR_SSL_KEYSTORETYPE.getKey(), Property.RPC_SSL_KEYSTORE_TYPE.getDefaultValue());
        }
        siteConfig.put(Property.MONITOR_SSL_TRUSTSTORE.getKey(), (String)siteConfig.get(Property.RPC_SSL_TRUSTSTORE_PATH.getKey()));
        siteConfig.put(Property.MONITOR_SSL_TRUSTSTOREPASS.getKey(), (String)siteConfig.get(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey()));
        if (siteConfig.containsKey(Property.RPC_SSL_TRUSTSTORE_TYPE.getKey())) {
            siteConfig.put(Property.MONITOR_SSL_TRUSTSTORETYPE.getKey(), (String)siteConfig.get(Property.RPC_SSL_TRUSTSTORE_TYPE.getKey()));
        } else {
            siteConfig.put(Property.MONITOR_SSL_TRUSTSTORETYPE.getKey(), Property.RPC_SSL_TRUSTSTORE_TYPE.getDefaultValue());
        }
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="url provided by test")
    public void test() throws Exception {
        log.debug("Starting Monitor");
        this.cluster.getClusterControl().startAllServers(ServerType.MONITOR);
        String monitorLocation = null;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            while (monitorLocation == null) {
                try {
                    monitorLocation = MonitorUtil.getLocation((ClientContext)((ClientContext)client));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (monitorLocation != null) continue;
                log.debug("Could not fetch monitor HTTP address from zookeeper");
                Thread.sleep(2000L);
            }
        }
        URL url = new URL("https://" + monitorLocation);
        log.debug("Fetching web page {}", (Object)url);
        String result = FunctionalTestUtils.readAll(url.openStream());
        Assert.assertTrue((result.length() > 100 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Accumulo Overview") >= 0 ? 1 : 0) != 0);
    }

    @SuppressFBWarnings(value={"WEAK_HOSTNAME_VERIFIER"}, justification="okay for test")
    private static class TestHostnameVerifier
    implements HostnameVerifier {
        private TestHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="trust manager is okay for testing")
    private static class TestTrustManager
    implements X509TrustManager {
        private TestTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

