/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MetadataMaxFilesIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.TSERV_SCAN_MAX_OPENFILES, "10");
        cfg.setProperty(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "100");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            int i;
            TreeSet<Text> splits = new TreeSet<Text>();
            for (i = 0; i < 1000; ++i) {
                splits.add(new Text(String.format("%03d", i)));
            }
            c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10000");
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            for (i = 0; i < 5; ++i) {
                String tableName = "table" + i;
                log.info("Creating {}", (Object)tableName);
                c.tableOperations().create(tableName);
                log.info("adding splits");
                c.tableOperations().addSplits(tableName, splits);
                log.info("flushing");
                c.tableOperations().flush(MetadataTable.NAME, null, null, true);
                c.tableOperations().flush(RootTable.NAME, null, null, true);
            }
            log.info("shutting down");
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            this.cluster.stop();
            log.info("starting up");
            this.cluster.start();
            while (true) {
                MasterMonitorInfo stats;
                MasterClientService.Client client = null;
                try {
                    ClientContext context = (ClientContext)c;
                    client = MasterClient.getConnectionWithRetry((ClientContext)context);
                    log.info("Fetching stats");
                    stats = client.getMasterStats(TraceUtil.traceInfo(), context.rpcCreds());
                }
                catch (ThriftNotActiveServiceException e) {
                    UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                finally {
                    if (client == null) continue;
                    MasterClient.close((MasterClientService.Iface)client);
                    continue;
                }
                int tablets = 0;
                for (TabletServerStatus tserver : stats.tServerInfo) {
                    for (Map.Entry entry : tserver.tableMap.entrySet()) {
                        if (((String)entry.getKey()).startsWith("!") || ((String)entry.getKey()).startsWith("+")) continue;
                        tablets += ((TableInfo)entry.getValue()).onlineTablets;
                    }
                }
                log.info("Online tablets " + tablets);
                if (tablets == 5005) {
                    break;
                }
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }
}

