/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanTmpIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(CleanTmpIT.class);

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Path file;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
                bw.flush();
                c.tableOperations().compact(tableName, null, null, true, true);
                m = new Mutation((CharSequence)"row2");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            String id = (String)c.tableOperations().tableIdMap().get(tableName);
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(Range.prefix((CharSequence)id));
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                file = new Path(((Key)entry.getKey()).getColumnQualifier().toString());
            }
            FileSystem fs = this.getCluster().getFileSystem();
            Assert.assertTrue((String)("Could not find file: " + file), (boolean)fs.exists(file));
            Path tabletDir = file.getParent();
            Assert.assertNotNull((String)"Tablet dir should not be null", (Object)tabletDir);
            Path tmp = new Path(tabletDir, "junk.rf_tmp");
            fs.create(tmp).close();
            log.info("Created tmp file {}", (Object)tmp);
            this.getCluster().stop();
            this.getCluster().start();
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)scanner.iterator()));
                Assert.assertFalse((String)("File still exists: " + tmp), (boolean)fs.exists(tmp));
            }
        }
    }
}

