/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Test;

public class BulkIT
extends AccumuloClusterHarness {
    private static final int N = 100000;
    private static final int COUNT = 5;

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkIT.getClientProps()).build();){
            BulkIT.runTest(client, BulkIT.getClientInfo(), BulkIT.getCluster().getFileSystem(), BulkIT.getCluster().getTemporaryPath(), this.getUniqueNames(1)[0], this.getClass().getName(), this.testName.getMethodName(), false);
        }
    }

    @Test
    public void testOld() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkIT.getClientProps()).build();){
            BulkIT.runTest(client, BulkIT.getClientInfo(), BulkIT.getCluster().getFileSystem(), BulkIT.getCluster().getTemporaryPath(), this.getUniqueNames(1)[0], this.getClass().getName(), this.testName.getMethodName(), true);
        }
    }

    static void runTest(AccumuloClient c, ClientInfo info, FileSystem fs, Path basePath, String tableName, String filePrefix, String dirSuffix, boolean useOld) throws Exception {
        c.tableOperations().create(tableName);
        Path base = new Path(fs.getUri().toString() + basePath, "testBulkFail_" + dirSuffix);
        fs.delete(base, true);
        fs.mkdirs(base);
        fs.deleteOnExit(base);
        Path bulkFailures = new Path(base, "failures");
        fs.deleteOnExit(bulkFailures);
        Path files = new Path(base, "files");
        fs.deleteOnExit(files);
        fs.mkdirs(bulkFailures);
        fs.mkdirs(files);
        TestIngest.IngestParams params = new TestIngest.IngestParams(info.getProperties(), tableName, 100000);
        params.timestamp = 1L;
        params.random = 56;
        params.cols = 1;
        String fileFormat = filePrefix + "rf%02d";
        for (int i = 0; i < 5; ++i) {
            params.outputFile = new Path(files, String.format(fileFormat, i)).toString();
            params.startRow = 100000 * i;
            TestIngest.ingest(c, fs, params);
        }
        params.outputFile = new Path(files, String.format(fileFormat, 100000)).toString();
        params.startRow = 100000;
        params.rows = 1;
        TestIngest.ingest(c, fs, params);
        BulkIT.bulkLoad(c, tableName, bulkFailures, files, useOld);
        VerifyIngest.VerifyParams verifyParams = new VerifyIngest.VerifyParams(info.getProperties(), tableName, 100000);
        verifyParams.random = 56;
        for (int i = 0; i < 5; ++i) {
            verifyParams.startRow = i * 100000;
            VerifyIngest.verifyIngest(c, verifyParams);
        }
        verifyParams.startRow = 100000;
        verifyParams.rows = 1;
        VerifyIngest.verifyIngest(c, verifyParams);
    }

    private static void bulkLoad(AccumuloClient c, String tableName, Path bulkFailures, Path files, boolean useOld) throws TableNotFoundException, IOException, AccumuloException, AccumuloSecurityException {
        if (useOld) {
            c.tableOperations().importDirectory(tableName, files.toString(), bulkFailures.toString(), false);
        } else {
            c.tableOperations().importDirectory(files.toString()).to(tableName).load();
        }
    }
}

