/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchScanSplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BatchScanSplitIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "0");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BatchScanSplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            int numRows = 262144;
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < numRows; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%09x", i)));
                    m.put(new Text("cf1"), new Text("cq1"), new Value(String.format("%016x", numRows - i).getBytes(StandardCharsets.UTF_8)));
                    bw.addMutation(m);
                }
            }
            c.tableOperations().flush(tableName, null, null, true);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "4K");
            Collection splits = c.tableOperations().listSplits(tableName);
            while (splits.size() < 2) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
                splits = c.tableOperations().listSplits(tableName);
            }
            System.out.println("splits : " + splits);
            SecureRandom random = new SecureRandom();
            HashMap<Text, Value> expected = new HashMap<Text, Value>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < 100; ++i) {
                int r = random.nextInt(numRows);
                Text row = new Text(String.format("%09x", r));
                expected.put(row, new Value(String.format("%016x", numRows - r).getBytes(StandardCharsets.UTF_8)));
                ranges.add(new Range(row));
            }
            HashMap<Text, Value> found = new HashMap<Text, Value>();
            for (int i = 0; i < 20; ++i) {
                try (BatchScanner bs = c.createBatchScanner(tableName);){
                    found.clear();
                    long t1 = System.currentTimeMillis();
                    bs.setRanges(ranges);
                    for (Map.Entry entry : bs) {
                        found.put(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                    }
                    long t2 = System.currentTimeMillis();
                    log.info(String.format("rate : %06.2f%n", (double)ranges.size() / ((double)(t2 - t1) / 1000.0)));
                    if (found.equals(expected)) continue;
                    throw new Exception("Found and expected differ " + found + " " + expected);
                }
            }
            splits = c.tableOperations().listSplits(tableName);
            log.info("splits : {}", (Object)splits);
        }
    }
}

