/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import jline.console.ConsoleReader;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class, SunnyDayTests.class})
public class ShellIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ShellIT.class);
    private StringInputStream input;
    private TestOutputStream output;
    private Shell shell;
    private File config;

    @Override
    protected int defaultTimeoutSeconds() {
        return 30;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    void execExpectList(String cmd, boolean expecteGoodExit, List<String> expectedStrings) throws IOException {
        this.exec(cmd);
        if (expecteGoodExit) {
            this.assertGoodExit("", true);
        } else {
            this.assertBadExit("", true);
        }
        for (String expectedString : expectedStrings) {
            Assert.assertTrue((String)(expectedString + " was not present in " + this.output.get()), (boolean)this.output.get().contains(expectedString));
        }
    }

    void exec(String cmd) throws IOException {
        this.output.clear();
        this.shell.execCommand(cmd, true, true);
    }

    void exec(String cmd, boolean expectGoodExit) throws IOException {
        this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit("", true);
        } else {
            this.assertBadExit("", true);
        }
    }

    void exec(String cmd, boolean expectGoodExit, String expectString) throws IOException {
        this.exec(cmd, expectGoodExit, expectString, true);
    }

    void exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent) throws IOException {
        this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit(expectString, stringPresent);
        } else {
            this.assertBadExit(expectString, stringPresent);
        }
    }

    @Before
    public void setupShell() throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.output = new TestOutputStream();
        this.input = new StringInputStream();
        this.config = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        this.shell = new Shell(new ConsoleReader((InputStream)this.input, (OutputStream)this.output));
        this.shell.setLogErrorsToConsole();
        this.shell.config(new String[]{"--config-file", this.config.toString(), "-u", "root", "-p", ShellIT.getRootPassword(), "-zi", ShellIT.getCluster().getInstanceName(), "-zh", ShellIT.getCluster().getZooKeepers()});
    }

    @After
    public void teardownShell() {
        if (this.config.exists() && !this.config.delete()) {
            log.error("Unable to delete {}", (Object)this.config);
        }
        this.shell.shutdown();
    }

    void assertGoodExit(String s, boolean stringPresent) {
        Shell.log.debug("{}", (Object)this.output.get());
        Assert.assertEquals((long)this.shell.getExitCode(), (long)0L);
        if (s.length() > 0) {
            Assert.assertEquals((String)(s + " present in " + this.output.get() + " was not " + stringPresent), (Object)stringPresent, (Object)this.output.get().contains(s));
        }
    }

    void assertBadExit(String s, boolean stringPresent) {
        Shell.log.debug("{}", (Object)this.output.get());
        Assert.assertTrue((this.shell.getExitCode() > 0 ? 1 : 0) != 0);
        if (s.length() > 0) {
            Assert.assertEquals((String)(s + " present in " + this.output.get() + " was not " + stringPresent), (Object)stringPresent, (Object)this.output.get().contains(s));
        }
        this.shell.resetExitCode();
    }

    @Test
    public void aboutTest() throws IOException {
        Shell.log.debug("Starting about test -----------------------------------");
        this.exec("about", true, "Shell - Apache Accumulo Interactive Shell");
        this.exec("about -v", true, "Current user:");
        this.exec("about arg", false, "java.lang.IllegalArgumentException: Expected 0 arguments");
    }

    @Test
    public void addGetSplitsTest() throws IOException {
        Shell.log.debug("Starting addGetSplits test ----------------------------");
        this.exec("addsplits arg", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("addsplits 1 \\x80", true);
        this.exec("getsplits", true, "1\n\\x80");
        this.exec("getsplits -m 1", true, "1");
        this.exec("getsplits -b64", true, "MQ==\ngA==");
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void insertDeleteScanTest() throws IOException {
        Shell.log.debug("Starting insertDeleteScan test ------------------------");
        this.exec("insert r f q v", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("delete r f q", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("insert r f q v", true);
        this.exec("scan", true, "r f:q []    v");
        this.exec("delete r f q", true);
        this.exec("scan", true, "r f:q []    v", false);
        this.exec("insert \\x90 \\xa0 \\xb0 \\xc0\\xd0\\xe0\\xf0", true);
        this.exec("scan", true, "\\x90 \\xA0:\\xB0 []    \\xC0\\xD0");
        this.exec("scan -f 2", true, "\\x90 \\xA0:\\xB0 []    \\xC0\\xD0");
        this.exec("scan -f 2", true, "\\x90 \\xA0:\\xB0 []    \\xC0\\xD0\\xE0", false);
        this.exec("scan -b \\x90 -e \\x90 -c \\xA0", true, "\\x90 \\xA0:\\xB0 []    \\xC0");
        this.exec("scan -b \\x90 -e \\x90 -c \\xA0:\\xB0", true, "\\x90 \\xA0:\\xB0 []    \\xC0");
        this.exec("scan -b \\x90 -be", true, "\\x90 \\xA0:\\xB0 []    \\xC0", false);
        this.exec("scan -e \\x90 -ee", true, "\\x90 \\xA0:\\xB0 []    \\xC0", false);
        this.exec("scan -b \\x90\\x00", true, "\\x90 \\xA0:\\xB0 []    \\xC0", false);
        this.exec("scan -e \\x8f", true, "\\x90 \\xA0:\\xB0 []    \\xC0", false);
        this.exec("delete \\x90 \\xa0 \\xb0", true);
        this.exec("scan", true, "\\x90 \\xA0:\\xB0 []    \\xC0", false);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void deleteManyTest() throws IOException {
        this.exec("deletemany", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("deletemany", true, "\n");
        this.exec("insert 0 0 0 0 -ts 0");
        this.exec("insert 0 0 0 0 -l 0 -ts 0");
        this.exec("insert 1 1 1 1 -ts 1");
        this.exec("insert 2 2 2 2 -ts 2");
        this.exec("deletemany", true, "[SKIPPED] 0 0:0 []");
        this.exec("deletemany -r 0", true, "[SKIPPED] 0 0:0 []");
        this.exec("deletemany -r 0 -f", true, "[DELETED] 0 0:0 []");
        this.exec("setauths -s 0");
        this.exec("deletemany -r 0 -f", true, "[DELETED] 0 0:0 [0]");
        this.exec("deletemany -r 1 -f -st", true, "[DELETED] 1 1:1 [] 1");
        this.exec("deletemany -r 2 -f -st -fm org.apache.accumulo.core.util.format.DateStringFormatter", true, "[DELETED] 2 2:2 [] 2");
        this.exec("setauths -c ", true);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void authsTest() throws Exception {
        Shell.log.debug("Starting auths test --------------------------");
        this.exec("setauths x,y,z", false, "Missing required option");
        this.exec("setauths -s x,y,z -u notauser", false, "user does not exist");
        this.exec("setauths -s y,z,x", true);
        this.exec("getauths -u notauser", false, "user does not exist");
        this.execExpectList("getauths", true, Arrays.asList("x", "y", "z"));
        this.exec("addauths -u notauser", false, "Missing required option");
        this.exec("addauths -u notauser -s foo", false, "user does not exist");
        this.exec("addauths -s a", true);
        this.execExpectList("getauths", true, Arrays.asList("x", "y", "z", "a"));
        this.exec("setauths -c", true);
    }

    @Test
    public void userTest() {
        Shell.log.debug("Starting user test --------------------------");
    }

    @Test
    public void duContextTest() throws Exception {
        Shell.log.debug("Starting du context test --------------------------");
        this.exec("createtable t", true);
        this.exec("du", true, "0 [t]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void duTest() throws IOException {
        Shell.log.debug("Starting DU test --------------------------");
        this.exec("createtable t", true);
        this.exec("du t", true, "0 [t]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void duPatternTest() throws IOException {
        Shell.log.debug("Starting DU with pattern test --------------------------");
        this.exec("createtable t", true);
        this.exec("createtable tt", true);
        this.exec("du -p t.*", true, "0 [t, tt]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
        this.exec("deletetable tt -f", true, "Table: [tt] has been deleted");
    }

    @Test
    public void scanTimestampTest() throws IOException {
        Shell.log.debug("Starting scanTimestamp test ------------------------");
        this.exec("createtable test", true);
        this.exec("insert r f q v -ts 0", true);
        this.exec("scan -st", true, "r f:q [] 0    v");
        this.exec("scan -st -f 0", true, " : [] 0   ");
        this.exec("deletemany -f", true);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void scanFewTest() throws IOException {
        Shell.log.debug("Starting scanFew test ------------------------");
        this.exec("createtable test", true);
        this.exec("insert 1 123 123456 -l '12345678' -ts 123456789 1234567890", true);
        this.exec("setauths -s 12345678", true);
        String expected = "1 123:123456 [12345678] 123456789    1234567890";
        String expectedFew = "1 123:12345 [12345678] 123456789    12345";
        this.exec("scan -st", true, expected);
        this.exec("scan -st -f 5", true, expectedFew);
        this.exec("scan -st -fm org.apache.accumulo.core.util.format.BinaryFormatter", true, expected);
        this.exec("scan -st -f 5 -fm org.apache.accumulo.core.util.format.BinaryFormatter", true, expectedFew);
        this.exec("setauths -c", true);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void scanDateStringFormatterTest() throws IOException {
        Shell.log.debug("Starting scan dateStringFormatter test --------------------------");
        this.exec("createtable t", true);
        this.exec("insert r f q v -ts 0", true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        String expected = String.format("r f:q [] %s    v", dateFormat.format(new Date(0L)));
        String expectedNoTimestamp = "r f:q []    v";
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st -f 1000", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st -f 5", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter", true, expectedNoTimestamp);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void grepTest() throws IOException {
        Shell.log.debug("Starting grep test --------------------------");
        this.exec("grep", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable t", true);
        this.exec("setauths -s vis", true);
        this.exec("insert r f q v -ts 0 -l vis", true);
        String expected = "r f:q [vis]    v";
        String expectedTimestamp = "r f:q [vis] 0    v";
        this.exec("grep", false, "No terms specified");
        this.exec("grep non_matching_string", true, "");
        this.exec("grep r", true, expected);
        this.exec("grep r -f 1", true, expected);
        this.exec("grep r -st", true, expectedTimestamp);
        this.exec("grep r -st -f 1", true, expectedTimestamp);
        this.exec("setauths -c", true);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void commentTest() throws IOException {
        Shell.log.debug("Starting comment test --------------------------");
        this.exec("#", true, "Unknown command", false);
        this.exec("# foo", true, "Unknown command", false);
        this.exec("- foo", true, "Unknown command", true);
    }

    @Test
    public void execFileTest() throws IOException {
        Shell.log.debug("Starting exec file test --------------------------");
        this.shell.config(new String[]{"--config-file", this.config.toString(), "-u", "root", "-p", ShellIT.getRootPassword(), "-zi", ShellIT.getCluster().getInstanceName(), "-zh", ShellIT.getCluster().getZooKeepers(), "-f", "src/main/resources/shellit.txt"});
        Assert.assertEquals((long)0L, (long)this.shell.start());
        this.assertGoodExit("Unknown command", false);
    }

    @Test
    public void setIterTest() throws IOException {
        Shell.log.debug("Starting setiter test --------------------------");
        this.exec("createtable t", true);
        String cmdJustClass = "setiter -class VersioningIterator -p 1";
        this.exec(cmdJustClass, false, "java.lang.IllegalArgumentException", false);
        this.exec(cmdJustClass, false, "fully qualified package name", true);
        String cmdFullPackage = "setiter -class o.a.a.foo -p 1";
        this.exec(cmdFullPackage, false, "java.lang.IllegalArgumentException", false);
        this.exec(cmdFullPackage, false, "class not found", true);
        String cmdNoOption = "setiter -class java.lang.String -p 1";
        this.exec(cmdNoOption, false, "loaded successfully but does not implement SortedKeyValueIterator", true);
        this.input.set("\n\n");
        this.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name foo", true);
        this.input.set("bar\nname value\n");
        this.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 31", true);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    public static class StringInputStream
    extends InputStream {
        private String source = "";
        private int offset = 0;

        @Override
        public int read() {
            if (this.offset == this.source.length()) {
                return 10;
            }
            return this.source.charAt(this.offset++);
        }

        public void set(String other) {
            this.source = other;
            this.offset = 0;
        }
    }

    public static class TestOutputStream
    extends OutputStream {
        StringBuilder sb = new StringBuilder();

        @Override
        public void write(int b) {
            this.sb.append((char)(0xFF & b));
        }

        public String get() {
            return this.sb.toString();
        }

        public void clear() {
            this.sb.setLength(0);
        }
    }
}

