/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.server.util.RandomizeVolumes;
import org.apache.accumulo.test.FairVolumeChooser;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class RewriteTabletDirectoriesIT
extends ConfigurableMacBase {
    private Path v1;
    private Path v2;

    @Override
    public int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        File baseDir = cfg.getDir();
        File volDirBase = new File(baseDir, "volumes");
        File v1f = new File(volDirBase, "v1");
        File v2f = new File(volDirBase, "v2");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        cfg.setProperty(Property.GENERAL_VOLUME_CHOOSER, FairVolumeChooser.class.getName());
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1.toString());
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.securityOperations().grantTablePermission(c.whoami(), MetadataTable.NAME, TablePermission.WRITE);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            TreeSet<Text> splits = new TreeSet<Text>();
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (String split : "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",")) {
                    splits.add(new Text(split));
                    Mutation m = new Mutation(new Text(split));
                    m.put(new byte[0], new byte[0], new byte[0]);
                    bw.addMutation(m);
                }
            }
            c.tableOperations().addSplits(tableName, splits);
            try (BatchScanner scanner = c.createBatchScanner(MetadataTable.NAME);){
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tableName)));
                Assert.assertNotNull((String)("TableID for " + tableName + " was null"), (Object)tableId);
                scanner.setRanges(Collections.singletonList(MetadataSchema.TabletsSection.getRange((TableId)tableId)));
                int count = 0;
                try (BatchWriter bw = c.createBatchWriter(MetadataTable.NAME);){
                    for (Map.Entry entry : scanner) {
                        Assert.assertTrue((String)("Expected " + entry.getValue() + " to contain " + this.v1), (boolean)((Value)entry.getValue()).toString().contains(this.v1.toString()));
                        if (++count % 2 != 0) continue;
                        String[] parts = ((Value)entry.getValue()).toString().split("/");
                        Key key = (Key)entry.getKey();
                        Mutation m = new Mutation(key.getRow());
                        m.put(key.getColumnFamily(), key.getColumnQualifier(), new Value(("/" + parts[parts.length - 1]).getBytes()));
                        bw.addMutation(m);
                    }
                }
                Assert.assertEquals((long)(splits.size() + 1), (long)count);
                Assert.assertEquals((long)1L, (long)this.cluster.exec(RandomizeVolumes.class, new String[]{"-c", this.cluster.getClientPropsPath(), "-t", tableName}).getProcess().waitFor());
                this.cluster.stop();
                FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(this.cluster.getAccumuloPropertiesPath())});
                ((PropertiesConfiguration)propsBuilder.getConfiguration()).setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(this.v1 + "," + this.v2));
                propsBuilder.save();
                Assert.assertEquals((long)0L, (long)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).getProcess().waitFor());
                this.cluster.start();
                Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"randomizeVolumes", "-t", tableName}).getProcess().waitFor());
                int v1Count = 0;
                int v2Count = 0;
                for (Map.Entry entry : scanner) {
                    if (((Value)entry.getValue()).toString().contains(this.v1.toString())) {
                        ++v1Count;
                    }
                    if (!((Value)entry.getValue()).toString().contains(this.v2.toString())) continue;
                    ++v2Count;
                }
                log.info("Count for volume1: {}", (Object)v1Count);
                log.info("Count for volume2: {}", (Object)v2Count);
                Assert.assertEquals((long)(splits.size() + 1), (long)(v1Count + v2Count));
                Assert.assertTrue((String)("Expected the number of files to differ between volumes by less than 10. " + v1Count + " " + v2Count), (Math.abs(v1Count - v2Count) < 2 ? 1 : 0) != 0);
                count = 0;
                for (Map.Entry entry : c.createScanner(tableName, Authorizations.EMPTY)) {
                    Assert.assertTrue((String)("Found unexpected entry in table: " + entry), (boolean)splits.contains(((Key)entry.getKey()).getRow()));
                    ++count;
                }
                Assert.assertEquals((long)splits.size(), (long)count);
            }
        }
    }
}

