/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardListIterator
implements SortedKeyValueIterator<Key, Value> {
    private static final Logger log = LoggerFactory.getLogger(HardListIterator.class);
    public static final SortedMap<Key, Value> allEntriesToInject;
    private PeekingIterator<Map.Entry<Key, Value>> inner;
    private Range seekRng;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        if (source != null) {
            log.info("HardListIterator ignores/replaces parent source passed in init(): {}", source);
        }
        IteratorUtil.IteratorScope scope = env.getIteratorScope();
        log.debug("{}: init on scope {}{}", new Object[]{this.getClass(), scope, scope == IteratorUtil.IteratorScope.majc ? " fullScan=" + env.isFullMajorCompaction() : ""});
        this.inner = new PeekingIterator(allEntriesToInject.entrySet().iterator());
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        HardListIterator newInstance;
        try {
            newInstance = (HardListIterator)HardListIterator.class.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.inner = new PeekingIterator(allEntriesToInject.tailMap((Key)((Map.Entry)this.inner.peek()).getKey()).entrySet().iterator());
        return newInstance;
    }

    public boolean hasTop() {
        if (!this.inner.hasNext()) {
            return false;
        }
        Key k = (Key)((Map.Entry)this.inner.peek()).getKey();
        return this.seekRng.contains(k);
    }

    public void next() {
        this.inner.next();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) {
        this.seekRng = range;
        this.inner = range.isInfiniteStartKey() ? new PeekingIterator(allEntriesToInject.entrySet().iterator()) : (range.isStartKeyInclusive() ? new PeekingIterator(allEntriesToInject.tailMap(range.getStartKey()).entrySet().iterator()) : new PeekingIterator(allEntriesToInject.tailMap(range.getStartKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME)).entrySet().iterator()));
    }

    public Key getTopKey() {
        return this.hasTop() ? (Key)((Map.Entry)this.inner.peek()).getKey() : null;
    }

    public Value getTopValue() {
        return this.hasTop() ? (Value)((Map.Entry)this.inner.peek()).getValue() : null;
    }

    static {
        TreeMap<Key, Value> t = new TreeMap<Key, Value>();
        t.put(new Key(new Text("a1"), new Text("colF3"), new Text("colQ3"), System.currentTimeMillis()), new Value("1".getBytes()));
        t.put(new Key(new Text("c1"), new Text("colF3"), new Text("colQ3"), System.currentTimeMillis()), new Value("1".getBytes()));
        t.put(new Key(new Text("m1"), new Text("colF3"), new Text("colQ3"), System.currentTimeMillis()), new Value("1".getBytes()));
        allEntriesToInject = Collections.unmodifiableSortedMap(t);
    }
}

