/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableImport;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.tableImport.FinishImportTable;
import org.apache.accumulo.master.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.tableImport.PopulateMetadataTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveExportedFiles
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(MoveExportedFiles.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MoveExportedFiles(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        try {
            FileStatus[] files;
            VolumeManager fs = master.getFileSystem();
            Map<String, String> fileNameMappings = PopulateMetadataTable.readMappingFile(fs, this.tableInfo);
            for (String oldFileName : fileNameMappings.keySet()) {
                if (fs.exists(new Path(this.tableInfo.exportDir, oldFileName))) continue;
                throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "File referenced by exported table does not exists " + oldFileName);
            }
            for (FileStatus fileStatus : files = fs.listStatus(new Path(this.tableInfo.exportDir))) {
                String newName = fileNameMappings.get(fileStatus.getPath().getName());
                if (newName == null) continue;
                fs.rename(fileStatus.getPath(), new Path(this.tableInfo.importDir, newName));
            }
            return new FinishImportTable(this.tableInfo);
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error renaming files " + ioe.getMessage());
        }
    }
}

