/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.namespace.rename;

import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.slf4j.LoggerFactory;

public class RenameNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceId namespaceId;
    private String oldName;
    private String newName;

    @Override
    public long isReady(long id, Master environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceId, id, true, true, TableOperation.RENAME);
    }

    public RenameNamespace(NamespaceId namespaceId, String oldName, String newName) {
        this.namespaceId = namespaceId;
        this.oldName = oldName;
        this.newName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long id, Master master) throws Exception {
        ZooReaderWriter zoo = master.getContext().getZooReaderWriter();
        Utils.getTableNameLock().lock();
        try {
            Utils.checkNamespaceDoesNotExist(master.getContext(), this.newName, this.namespaceId, TableOperation.RENAME);
            String tap = master.getZooKeeperRoot() + "/namespaces" + "/" + this.namespaceId + "/name";
            zoo.mutate(tap, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] current) throws Exception {
                    String currentName = new String(current);
                    if (currentName.equals(RenameNamespace.this.newName)) {
                        return null;
                    }
                    if (!currentName.equals(RenameNamespace.this.oldName)) {
                        throw new AcceptableThriftTableOperationException(null, RenameNamespace.this.oldName, TableOperation.RENAME, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Name changed while processing");
                    }
                    return RenameNamespace.this.newName.getBytes();
                }
            });
            Tables.clearCache((ClientContext)master.getContext());
        }
        finally {
            Utils.getTableNameLock().unlock();
            Utils.unreserveNamespace(master, this.namespaceId, id, true);
        }
        LoggerFactory.getLogger(RenameNamespace.class).debug("Renamed namespace {} {} {}", new Object[]{this.namespaceId, this.oldName, this.newName});
        return null;
    }

    @Override
    public void undo(long tid, Master env) {
        Utils.unreserveNamespace(env, this.namespaceId, tid, true);
    }
}

