/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.CompactionStrategyConfigUtil;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.master.thrift.FateService;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.SystemIteratorUtil;
import org.apache.accumulo.core.util.Validator;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ChangeTableState;
import org.apache.accumulo.master.tableOps.TraceRepo;
import org.apache.accumulo.master.tableOps.bulkVer1.BulkImport;
import org.apache.accumulo.master.tableOps.bulkVer2.PrepBulkImport;
import org.apache.accumulo.master.tableOps.clone.CloneTable;
import org.apache.accumulo.master.tableOps.compact.CompactRange;
import org.apache.accumulo.master.tableOps.compact.cancel.CancelCompactions;
import org.apache.accumulo.master.tableOps.create.CreateTable;
import org.apache.accumulo.master.tableOps.delete.DeleteTable;
import org.apache.accumulo.master.tableOps.merge.TableRangeOp;
import org.apache.accumulo.master.tableOps.namespace.create.CreateNamespace;
import org.apache.accumulo.master.tableOps.namespace.delete.DeleteNamespace;
import org.apache.accumulo.master.tableOps.namespace.rename.RenameNamespace;
import org.apache.accumulo.master.tableOps.rename.RenameTable;
import org.apache.accumulo.master.tableOps.tableExport.ExportTable;
import org.apache.accumulo.master.tableOps.tableImport.ImportTable;
import org.apache.accumulo.master.util.TableValidators;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;

class FateServiceHandler
implements FateService.Iface {
    protected final Master master;
    protected static final Logger log = Master.log;

    public FateServiceHandler(Master master) {
        this.master = master;
    }

    public long beginFateOperation(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.master.fate.startTransaction();
    }

    public void executeFateOperation(TInfo tinfo, TCredentials c, long opid, FateOperation op, List<ByteBuffer> arguments, Map<String, String> options, boolean autoCleanup) throws ThriftSecurityException, ThriftTableOperationException {
        this.authenticate(c);
        switch (op) {
            case NAMESPACE_CREATE: {
                TableOperation tableOp = TableOperation.CREATE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String namespace = this.validateNamespaceArgument(arguments.get(0), tableOp, null);
                if (!this.master.security.canCreateNamespace(c)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CreateNamespace(c.getPrincipal(), namespace, options)), autoCleanup);
                break;
            }
            case NAMESPACE_RENAME: {
                TableOperation tableOp = TableOperation.RENAME;
                this.validateArgumentCount(arguments, tableOp, 2);
                String oldName = this.validateNamespaceArgument(arguments.get(0), tableOp, (Validator<String>)Namespaces.NOT_DEFAULT.and(Namespaces.NOT_ACCUMULO));
                String newName = this.validateNamespaceArgument(arguments.get(1), tableOp, null);
                NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.master.getContext(), (String)oldName, (TableOperation)tableOp);
                if (!this.master.security.canRenameNamespace(c, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new RenameNamespace(namespaceId, oldName, newName)), autoCleanup);
                break;
            }
            case NAMESPACE_DELETE: {
                TableOperation tableOp = TableOperation.DELETE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String namespace = this.validateNamespaceArgument(arguments.get(0), tableOp, (Validator<String>)Namespaces.NOT_DEFAULT.and(Namespaces.NOT_ACCUMULO));
                NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.master.getContext(), (String)namespace, (TableOperation)tableOp);
                if (!this.master.security.canDeleteNamespace(c, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new DeleteNamespace(namespaceId)), autoCleanup);
                break;
            }
            case TABLE_CREATE: {
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.CREATE;
                int SPLIT_OFFSET = 4;
                if (arguments.size() < SPLIT_OFFSET) {
                    throw new ThriftTableOperationException(null, null, tableOp, TableOperationExceptionType.OTHER, "Expected at least " + SPLIT_OFFSET + " arguments, saw :" + arguments.size());
                }
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                TimeType timeType = TimeType.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(1)));
                InitialTableState initialTableState = InitialTableState.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                int splitCount = Integer.parseInt(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                this.validateArgumentCount(arguments, tableOp, SPLIT_OFFSET + splitCount);
                String splitFile = null;
                String splitDirsFile = null;
                if (splitCount > 0) {
                    try {
                        splitFile = this.writeSplitsToFile(opid, arguments, splitCount, SPLIT_OFFSET);
                        splitDirsFile = this.createSplitDirsFile(opid);
                    }
                    catch (IOException e) {
                        throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.OTHER, "Exception thrown while writing splits to file system");
                    }
                }
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.master.getContext(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                if (!this.master.security.canCreateTable(c, tableName, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CreateTable(c.getPrincipal(), tableName, timeType, options, splitFile, splitCount, splitDirsFile, initialTableState, namespaceId)), autoCleanup);
                break;
            }
            case TABLE_RENAME: {
                boolean canRename;
                TableOperation tableOp = TableOperation.RENAME;
                this.validateArgumentCount(arguments, tableOp, 2);
                final String oldTableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String newTableName = this.validateTableNameArgument(arguments.get(1), tableOp, new Validator<String>(){

                    public boolean test(String argument) {
                        String oldNamespace = (String)Tables.qualify((String)oldTableName).getFirst();
                        return oldNamespace.equals(Tables.qualify((String)argument).getFirst());
                    }

                    public String invalidMessage(String argument) {
                        return "Cannot move tables to a new namespace by renaming. The namespace for " + oldTableName + " does not match " + argument;
                    }
                });
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)oldTableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canRename = this.master.security.canRenameTable(c, tableId, oldTableName, newTableName, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, oldTableName, TableOperation.RENAME);
                    throw e;
                }
                if (!canRename) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                try {
                    this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new RenameTable(namespaceId, tableId, oldTableName, newTableName)), autoCleanup);
                    break;
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, oldTableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
            }
            case TABLE_CLONE: {
                boolean canCloneTable;
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.CLONE;
                this.validateArgumentCount(arguments, tableOp, 2);
                TableId srcTableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                String tableName = this.validateTableNameArgument(arguments.get(1), tableOp, TableValidators.NOT_SYSTEM);
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.master.getContext(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canCloneTable = this.master.security.canCloneTable(c, srcTableId, tableName, namespaceId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, srcTableId, null, TableOperation.CLONE);
                    throw e;
                }
                if (!canCloneTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                HashMap<String, String> propertiesToSet = new HashMap<String, String>();
                HashSet<String> propertiesToExclude = new HashSet<String>();
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    if (entry.getKey().startsWith("!")) {
                        propertiesToExclude.add(entry.getKey().substring("!".length()));
                        continue;
                    }
                    if (!TablePropUtil.isPropertyValid((String)entry.getKey(), (String)entry.getValue())) {
                        throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.OTHER, "Property or value not valid " + entry.getKey() + "=" + entry.getValue());
                    }
                    propertiesToSet.put(entry.getKey(), entry.getValue());
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CloneTable(c.getPrincipal(), namespaceId, srcTableId, tableName, propertiesToSet, propertiesToExclude)), autoCleanup);
                break;
            }
            case TABLE_DELETE: {
                boolean canDeleteTable;
                TableOperation tableOp = TableOperation.DELETE;
                this.validateArgumentCount(arguments, tableOp, 1);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canDeleteTable = this.master.security.canDeleteTable(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE);
                    throw e;
                }
                if (!canDeleteTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new DeleteTable(namespaceId, tableId)), autoCleanup);
                break;
            }
            case TABLE_ONLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.ONLINE;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canOnlineOfflineTable = this.master.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.ONLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(namespaceId, tableId, tableOp)), autoCleanup);
                break;
            }
            case TABLE_OFFLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.OFFLINE;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canOnlineOfflineTable = this.master.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.OFFLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(namespaceId, tableId, tableOp)), autoCleanup);
                break;
            }
            case TABLE_MERGE: {
                boolean canMerge;
                TableOperation tableOp = TableOperation.MERGE;
                this.validateArgumentCount(arguments, tableOp, 3);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, null);
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canMerge = this.master.security.canMerge(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.MERGE);
                    throw e;
                }
                if (!canMerge) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                Master.log.debug("Creating merge op: {} {} {}", new Object[]{tableId, startRow, endRow});
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.MERGE, namespaceId, tableId, startRow, endRow)), autoCleanup);
                break;
            }
            case TABLE_DELETE_RANGE: {
                boolean canDeleteRange;
                TableOperation tableOp = TableOperation.DELETE_RANGE;
                this.validateArgumentCount(arguments, tableOp, 3);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_METADATA);
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canDeleteRange = this.master.security.canDeleteRange(c, tableId, tableName, startRow, endRow, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE_RANGE);
                    throw e;
                }
                if (!canDeleteRange) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.DELETE, namespaceId, tableId, startRow, endRow)), autoCleanup);
                break;
            }
            case TABLE_BULK_IMPORT: {
                boolean canBulkImport;
                TableOperation tableOp = TableOperation.BULK_IMPORT;
                this.validateArgumentCount(arguments, tableOp, 4);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                String failDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(2));
                boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canBulkImport = this.master.security.canBulkImport(c, tableId, tableName, dir, failDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.BULK_IMPORT);
                    throw e;
                }
                if (!canBulkImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.updateBulkImportStatus(dir, BulkImportState.INITIAL);
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new BulkImport(tableId, dir, failDir, setTime)), autoCleanup);
                break;
            }
            case TABLE_COMPACT: {
                boolean canCompact;
                TableOperation tableOp = TableOperation.COMPACT;
                this.validateArgumentCount(arguments, tableOp, 5);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                byte[] startRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(1));
                byte[] endRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(2));
                List iterators = SystemIteratorUtil.decodeIteratorSettings((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(3)));
                CompactionStrategyConfig compactionStrategy = CompactionStrategyConfigUtil.decode((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(4)));
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canCompact = this.master.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT);
                    throw e;
                }
                if (!canCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CompactRange(namespaceId, tableId, startRow, endRow, iterators, compactionStrategy)), autoCleanup);
                break;
            }
            case TABLE_CANCEL_COMPACT: {
                boolean canCancelCompact;
                TableOperation tableOp = TableOperation.COMPACT_CANCEL;
                this.validateArgumentCount(arguments, tableOp, 1);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canCancelCompact = this.master.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT_CANCEL);
                    throw e;
                }
                if (!canCancelCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CancelCompactions(namespaceId, tableId)), autoCleanup);
                break;
            }
            case TABLE_IMPORT: {
                boolean canImport;
                NamespaceId namespaceId;
                TableOperation tableOp = TableOperation.IMPORT;
                this.validateArgumentCount(arguments, tableOp, 2);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                try {
                    namespaceId = Namespaces.getNamespaceId((ClientContext)this.master.getContext(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canImport = this.master.security.canImport(c, tableName, exportDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, null, tableName, TableOperation.IMPORT);
                    throw e;
                }
                if (!canImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ImportTable(c.getPrincipal(), tableName, exportDir, namespaceId)), autoCleanup);
                break;
            }
            case TABLE_EXPORT: {
                boolean canExport;
                TableOperation tableOp = TableOperation.EXPORT;
                this.validateArgumentCount(arguments, tableOp, 2);
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)tableOp);
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    canExport = this.master.security.canExport(c, tableId, tableName, exportDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.EXPORT);
                    throw e;
                }
                if (!canExport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ExportTable(namespaceId, tableName, tableId, exportDir)), autoCleanup);
                break;
            }
            case TABLE_BULK_IMPORT2: {
                boolean canBulkImport;
                TableOperation tableOp = TableOperation.BULK_IMPORT;
                this.validateArgumentCount(arguments, tableOp, 3);
                TableId tableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(2)));
                NamespaceId namespaceId = this.getNamespaceIdFromTableId(tableOp, tableId);
                try {
                    String tableName = Tables.getTableName((ClientContext)this.master.getContext(), (TableId)tableId);
                    canBulkImport = this.master.security.canBulkImport(c, tableId, tableName, dir, null, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, "", TableOperation.BULK_IMPORT);
                    throw e;
                }
                catch (TableNotFoundException e) {
                    throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.NOTFOUND, "Table no longer exists");
                }
                if (!canBulkImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new PrepBulkImport(tableId, dir, setTime)), autoCleanup);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private NamespaceId getNamespaceIdFromTableId(TableOperation tableOp, TableId tableId) throws ThriftTableOperationException {
        NamespaceId namespaceId;
        try {
            namespaceId = Tables.getNamespaceId((ClientContext)this.master.getContext(), (TableId)tableId);
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonical(), null, tableOp, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        return namespaceId;
    }

    private void throwIfTableMissingSecurityException(ThriftSecurityException e, TableId tableId, String tableName, TableOperation op) throws ThriftTableOperationException {
        if (e.isSetCode() && e.getCode() == SecurityErrorCode.TABLE_DOESNT_EXIST) {
            throw new ThriftTableOperationException(tableId.canonical(), tableName, op, TableOperationExceptionType.NOTFOUND, "Table no longer exists");
        }
    }

    public String waitForFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, ThriftTableOperationException {
        this.authenticate(credentials);
        ReadOnlyTStore.TStatus status = this.master.fate.waitForCompletion(opid);
        if (status == ReadOnlyTStore.TStatus.FAILED) {
            Exception e = this.master.fate.getException(opid);
            if (e instanceof ThriftTableOperationException) {
                throw (ThriftTableOperationException)e;
            }
            if (e instanceof ThriftSecurityException) {
                throw (ThriftSecurityException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        String ret = this.master.fate.getReturn(opid);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void finishFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.master.fate.delete(opid);
    }

    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!this.master.security.authenticateUser(credentials, credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
        }
    }

    private TableId validateTableIdArgument(ByteBuffer tableIdArg, TableOperation op, Validator<TableId> userValidator) throws ThriftTableOperationException {
        TableId tableId = tableIdArg == null ? null : ByteBufferUtil.toTableId((ByteBuffer)tableIdArg);
        try {
            return (TableId)TableValidators.VALID_ID.and(userValidator).validate((Object)tableId);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.debug(why);
            throw new ThriftTableOperationException(tableId.canonical(), null, op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }

    private String validateTableNameArgument(ByteBuffer tableNameArg, TableOperation op, Validator<String> userValidator) throws ThriftTableOperationException {
        String tableName = tableNameArg == null ? null : ByteBufferUtil.toString((ByteBuffer)tableNameArg);
        return this._validateArgument(tableName, op, TableValidators.VALID_NAME.and(userValidator));
    }

    private void validateArgumentCount(List<ByteBuffer> arguments, TableOperation op, int expected) throws ThriftTableOperationException {
        if (arguments.size() != expected) {
            throw new ThriftTableOperationException(null, null, op, TableOperationExceptionType.OTHER, "Unexpected number of arguments : " + expected + " != " + arguments.size());
        }
    }

    private String validateNamespaceArgument(ByteBuffer namespaceArg, TableOperation op, Validator<String> userValidator) throws ThriftTableOperationException {
        String namespace = namespaceArg == null ? null : ByteBufferUtil.toString((ByteBuffer)namespaceArg);
        return this._validateArgument(namespace, op, Namespaces.VALID_NAME.and(userValidator));
    }

    private <T> T _validateArgument(T arg, TableOperation op, Validator<T> validator) throws ThriftTableOperationException {
        try {
            return (T)validator.validate(arg);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.debug(why);
            throw new ThriftTableOperationException(null, String.valueOf(arg), op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }

    private String writeSplitsToFile(long opid, List<ByteBuffer> arguments, int splitCount, int splitOffset) throws IOException {
        String opidStr = String.format("%016x", opid);
        String splitsPath = this.getSplitPath("/tmp/splits-" + opidStr);
        this.removeAndCreateTempFile(splitsPath);
        try (FSDataOutputStream stream = this.master.getOutputStream(splitsPath);){
            this.writeSplitsToFileSystem(stream, arguments, splitCount, splitOffset);
        }
        catch (IOException e) {
            log.error("Error in FateServiceHandler while writing splits for opid: " + opidStr + ": " + e.getMessage());
            throw e;
        }
        return splitsPath;
    }

    private void removeAndCreateTempFile(String path) throws IOException {
        FileSystem fs = this.master.getFileSystem().getDefaultVolume().getFileSystem();
        if (fs.exists(new Path(path))) {
            fs.delete(new Path(path), true);
        }
        fs.create(new Path(path));
    }

    private String createSplitDirsFile(long opid) throws IOException {
        String opidStr = String.format("%016x", opid);
        String splitDirPath = this.getSplitPath("/tmp/splitDirs-" + opidStr);
        this.removeAndCreateTempFile(splitDirPath);
        return splitDirPath;
    }

    private void writeSplitsToFileSystem(FSDataOutputStream stream, List<ByteBuffer> arguments, int splitCount, int splitOffset) throws IOException {
        for (int i = splitOffset; i < splitCount + splitOffset; ++i) {
            byte[] splitBytes = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(i));
            String encodedSplit = Base64.getEncoder().encodeToString(splitBytes);
            stream.writeBytes(encodedSplit + '\n');
        }
    }

    private String getSplitPath(String relPath) {
        Volume defaultVolume = this.master.getFileSystem().getDefaultVolume();
        String uri = defaultVolume.getFileSystem().getUri().toString();
        String basePath = defaultVolume.getBasePath();
        return uri + basePath + relPath;
    }
}

