/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.thrift.TSummarizerConfiguration;

public class SummarizerConfigurationUtil {
    public static Map<String, String> toTablePropertiesMap(List<SummarizerConfiguration> summarizers) {
        if (summarizers.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (SummarizerConfiguration sconf : summarizers) {
            String cid = sconf.getPropertyId();
            String prefix = Property.TABLE_SUMMARIZER_PREFIX.getKey() + cid;
            if (props.containsKey(prefix)) {
                throw new IllegalArgumentException("Duplicate summarizer config id : " + cid);
            }
            props.put(prefix, sconf.getClassName());
            Set<Map.Entry<String, String>> es = sconf.getOptions().entrySet();
            StringBuilder sb = new StringBuilder(prefix + ".opt.");
            int resetLen = sb.length();
            for (Map.Entry<String, String> entry : es) {
                sb.append(entry.getKey());
                props.put(sb.toString(), entry.getValue());
                sb.setLength(resetLen);
            }
        }
        return props;
    }

    public static List<SummarizerConfiguration> getSummarizerConfigs(Iterable<Map.Entry<String, String>> props) {
        TreeMap<String, String> filteredMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : props) {
            if (!entry.getKey().startsWith(Property.TABLE_SUMMARIZER_PREFIX.getKey())) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return SummarizerConfigurationUtil.getSummarizerConfigsFiltered(filteredMap);
    }

    public static List<SummarizerConfiguration> getSummarizerConfigs(AccumuloConfiguration aconf) {
        Map<String, String> sprops = aconf.getAllPropertiesWithPrefix(Property.TABLE_SUMMARIZER_PREFIX);
        return SummarizerConfigurationUtil.getSummarizerConfigsFiltered(new TreeMap<String, String>(sprops));
    }

    private static List<SummarizerConfiguration> getSummarizerConfigsFiltered(SortedMap<String, String> sprops) {
        if (sprops.size() == 0) {
            return Collections.emptyList();
        }
        SummarizerConfiguration.Builder builder = null;
        ArrayList<SummarizerConfiguration> configs = new ArrayList<SummarizerConfiguration>();
        int preLen = Property.TABLE_SUMMARIZER_PREFIX.getKey().length();
        for (Map.Entry<String, String> entry : sprops.entrySet()) {
            String k = entry.getKey().substring(preLen);
            String[] tokens = k.split("\\.");
            String id = tokens[0];
            if (tokens.length == 1) {
                if (builder != null) {
                    configs.add(builder.build());
                }
                builder = SummarizerConfiguration.builder(entry.getValue()).setPropertyId(id);
                continue;
            }
            if (tokens.length == 3 || tokens[1].equals("opt")) {
                builder.addOption(tokens[2], entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unable to parse summarizer property : " + k);
        }
        configs.add(builder.build());
        return configs;
    }

    public static TSummarizerConfiguration toThrift(SummarizerConfiguration sc) {
        return new TSummarizerConfiguration(sc.getClassName(), sc.getOptions(), sc.getPropertyId());
    }

    public static SummarizerConfiguration fromThrift(TSummarizerConfiguration config) {
        SummarizerConfiguration.Builder builder = SummarizerConfiguration.builder(config.getClassname());
        builder.setPropertyId(config.getConfigId());
        builder.addOptions(config.getOptions());
        return builder.build();
    }
}

