/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.spi.scan.ScanInfo;

public class SimpleScanDispatcher
implements ScanDispatcher {
    private final String EXECUTOR_PREFIX = "executor.";
    private final Set<String> VALID_OPTS = ImmutableSet.of((Object)"executor", (Object)"multi_executor", (Object)"single_executor");
    private String multiExecutor;
    private String singleExecutor;
    private Map<String, String> typeExecutors;
    public static final String DEFAULT_SCAN_EXECUTOR_NAME = "default";

    @Override
    public void init(ScanDispatcher.InitParameters params) {
        Map<String, String> options = params.getOptions();
        ImmutableMap.Builder teb = ImmutableMap.builder();
        options.forEach((k, v) -> {
            if (k.startsWith("executor.")) {
                String type = k.substring("executor.".length());
                teb.put((Object)type, v);
            } else if (!this.VALID_OPTS.contains(k)) {
                throw new IllegalArgumentException("Invalid option " + k);
            }
        });
        this.typeExecutors = teb.build();
        String base = options.getOrDefault("executor", DEFAULT_SCAN_EXECUTOR_NAME);
        this.multiExecutor = options.getOrDefault("multi_executor", base);
        this.singleExecutor = options.getOrDefault("single_executor", base);
    }

    @Override
    public String dispatch(ScanDispatcher.DispatchParmaters params) {
        String executor;
        String scanType;
        ScanInfo scanInfo = params.getScanInfo();
        if (!this.typeExecutors.isEmpty() && (scanType = scanInfo.getExecutionHints().get("scan_type")) != null && (executor = this.typeExecutors.get(scanType)) != null) {
            return executor;
        }
        switch (scanInfo.getScanType()) {
            case MULTI: {
                return this.multiExecutor;
            }
            case SINGLE: {
                return this.singleExecutor;
            }
        }
        throw new IllegalArgumentException("Unexpected scan type " + (Object)((Object)scanInfo.getScanType()));
    }
}

