/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheType;

public abstract class BlockCacheManager {
    private final Map<CacheType, BlockCache> caches = new HashMap<CacheType, BlockCache>();
    public static final String CACHE_PROPERTY_BASE = (Object)((Object)Property.TSERV_PREFIX) + "cache.config.";

    public void start(Configuration conf) {
        for (CacheType type : CacheType.values()) {
            BlockCache cache = this.createCache(conf, type);
            this.caches.put(type, cache);
        }
    }

    public void stop() {
        this.caches.clear();
    }

    public BlockCache getBlockCache(CacheType type) {
        return this.caches.get((Object)type);
    }

    protected abstract BlockCache createCache(Configuration var1, CacheType var2);

    public static String getFullyQualifiedPropertyPrefix(String prefix) {
        return CACHE_PROPERTY_BASE + prefix + ".default.";
    }

    public static String getFullyQualifiedPropertyPrefix(String prefix, CacheType type) {
        return CACHE_PROPERTY_BASE + prefix + "." + type.name().toLowerCase() + ".";
    }

    public static interface Configuration {
        public long getMaxSize(CacheType var1);

        public long getBlockSize();

        public Map<String, String> getProperties(String var1, CacheType var2);
    }
}

