/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.schema.Section;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.hadoop.io.Text;

public class MetadataSchema {
    public static final String RESERVED_PREFIX = "~";

    public static class ReplicationSection {
        public static final Text COLF = new Text("stat");
        private static final ArrayByteSequence COLF_BYTE_SEQ = new ArrayByteSequence(COLF.toString());
        private static final Section section = new Section("~repl", true, "~repm", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }

        public static TableId getTableId(Key k) {
            Objects.requireNonNull(k);
            return TableId.of(k.getColumnQualifier().toString());
        }

        public static void getFile(Key k, Text buff) {
            Objects.requireNonNull(k);
            Objects.requireNonNull(buff);
            Preconditions.checkArgument((boolean)COLF_BYTE_SEQ.equals(k.getColumnFamilyData()), (Object)"Given metadata replication status key with incorrect colfam");
            k.getRow(buff);
            buff.set(buff.getBytes(), section.getRowPrefix().length(), buff.getLength() - section.getRowPrefix().length());
        }
    }

    public static class BlipSection {
        private static final Section section = new Section("~blip", true, "~bliq", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class DeletesSection {
        private static final Section section = new Section("~del", true, "~dem", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class ReservedSection {
        private static final Section section = new Section("~", true, null, false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class TabletsSection {
        private static final Section section = new Section(null, false, "~", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static Range getRange(TableId tableId) {
            return new Range(new Key(tableId.canonical() + ';'), true, new Key(tableId.canonical() + '<').followingKey(PartialKey.ROW), false);
        }

        public static Text getRow(TableId tableId, Text endRow) {
            Text entry = new Text(tableId.canonical());
            if (endRow == null) {
                entry.append(new byte[]{60}, 0, 1);
            } else {
                entry.append(new byte[]{59}, 0, 1);
                entry.append(endRow.getBytes(), 0, endRow.getLength());
            }
            return entry;
        }

        public static class ChoppedColumnFamily {
            public static final Text NAME = new Text("chopped");
            public static final ColumnFQ CHOPPED_COLUMN = new ColumnFQ(NAME, new Text("chopped"));
        }

        public static class LogColumnFamily {
            public static final String STR_NAME = "log";
            public static final Text NAME = new Text("log");
        }

        public static class ScanFileColumnFamily {
            public static final String STR_NAME = "scan";
            public static final Text NAME = new Text("scan");
        }

        public static class DataFileColumnFamily {
            public static final String STR_NAME = "file";
            public static final Text NAME = new Text("file");
        }

        public static class ClonedColumnFamily {
            public static final String STR_NAME = "!cloned";
            public static final Text NAME = new Text("!cloned");
        }

        public static class BulkFileColumnFamily {
            public static final String STR_NAME = "loaded";
            public static final Text NAME = new Text("loaded");
        }

        public static class SuspendLocationColumn {
            public static final String STR_NAME = "suspend";
            public static final ColumnFQ SUSPEND_COLUMN = new ColumnFQ(new Text("suspend"), new Text("loc"));
        }

        public static class LastLocationColumnFamily {
            public static final String STR_NAME = "last";
            public static final Text NAME = new Text("last");
        }

        public static class FutureLocationColumnFamily {
            public static final String STR_NAME = "future";
            public static final Text NAME = new Text("future");
        }

        public static class CurrentLocationColumnFamily {
            public static final String STR_NAME = "loc";
            public static final Text NAME = new Text("loc");
        }

        public static class ServerColumnFamily {
            public static final String STR_NAME = "srv";
            public static final Text NAME = new Text("srv");
            public static final String DIRECTORY_QUAL = "dir";
            public static final ColumnFQ DIRECTORY_COLUMN = new ColumnFQ(NAME, new Text("dir"));
            public static final String TIME_QUAL = "time";
            public static final ColumnFQ TIME_COLUMN = new ColumnFQ(NAME, new Text("time"));
            public static final String FLUSH_QUAL = "flush";
            public static final ColumnFQ FLUSH_COLUMN = new ColumnFQ(NAME, new Text("flush"));
            public static final String COMPACT_QUAL = "compact";
            public static final ColumnFQ COMPACT_COLUMN = new ColumnFQ(NAME, new Text("compact"));
            public static final String LOCK_QUAL = "lock";
            public static final ColumnFQ LOCK_COLUMN = new ColumnFQ(NAME, new Text("lock"));
        }

        public static class TabletColumnFamily {
            public static final String STR_NAME = "~tab";
            public static final Text NAME = new Text("~tab");
            public static final String PREV_ROW_QUAL = "~pr";
            public static final ColumnFQ PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("~pr"));
            public static final ColumnFQ OLD_PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("oldprevrow"));
            public static final ColumnFQ SPLIT_RATIO_COLUMN = new ColumnFQ(NAME, new Text("splitRatio"));
        }
    }
}

