/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityFilter
extends Filter
implements OptionDescriber {
    protected VisibilityEvaluator ve;
    protected LRUMap<ByteSequence, Boolean> cache;
    private static final Logger log = LoggerFactory.getLogger(VisibilityFilter.class);
    private static final String AUTHS = "auths";
    private static final String FILTER_INVALID_ONLY = "filterInvalid";
    private boolean filterInvalid;

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.validateOptions(options);
        this.filterInvalid = Boolean.parseBoolean(options.get(FILTER_INVALID_ONLY));
        if (!this.filterInvalid) {
            String auths = options.get(AUTHS);
            Authorizations authObj = auths == null || auths.isEmpty() ? new Authorizations() : new Authorizations(auths.getBytes(StandardCharsets.UTF_8));
            this.ve = new VisibilityEvaluator(authObj);
        }
        this.cache = new LRUMap(1000);
    }

    @Override
    public boolean accept(Key k, Value v) {
        ByteSequence testVis = k.getColumnVisibilityData();
        if (this.filterInvalid) {
            Boolean b = (Boolean)this.cache.get((Object)testVis);
            if (b != null) {
                return b;
            }
            try {
                new ColumnVisibility(testVis.toArray());
                this.cache.put((Object)testVis, (Object)true);
                return true;
            }
            catch (BadArgumentException e) {
                this.cache.put((Object)testVis, (Object)false);
                return false;
            }
        }
        if (testVis.length() == 0) {
            return true;
        }
        Boolean b = (Boolean)this.cache.get((Object)testVis);
        if (b != null) {
            return b;
        }
        try {
            boolean bb = this.ve.evaluate(new ColumnVisibility(testVis.toArray()));
            this.cache.put((Object)testVis, (Object)bb);
            return bb;
        }
        catch (VisibilityParseException | BadArgumentException e) {
            log.error("Parse Error", (Throwable)e);
            return false;
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("visibilityFilter");
        io.setDescription("The VisibilityFilter allows you to filter for key/value pairs by a set of authorizations or filter invalid labels from corrupt files.");
        io.addNamedOption(FILTER_INVALID_ONLY, "if 'true', the iterator is instructed to ignore the authorizations and only filter invalid visibility labels (default: false)");
        io.addNamedOption(AUTHS, "the serialized set of authorizations to filter against (default: empty string, accepts only entries visible by all)");
        return io;
    }

    public static void setAuthorizations(IteratorSetting setting, Authorizations auths) {
        setting.addOption(AUTHS, auths.serialize());
    }

    public static void filterInvalidLabelsOnly(IteratorSetting setting, boolean featureEnabled) {
        setting.addOption(FILTER_INVALID_ONLY, Boolean.toString(featureEnabled));
    }
}

