/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.dataImpl;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class KeyExtent
implements WritableComparable<KeyExtent> {
    private TableId tableId;
    private Text textEndRow;
    private Text textPrevEndRow;
    private static final TableId EMPTY_ID = TableId.of("");
    private static final Text EMPTY_TEXT = new Text("");
    private static final Comparator<KeyExtent> COMPARATOR = Comparator.comparing(KeyExtent::getTableId).thenComparing(KeyExtent::getEndRow, Comparator.nullsLast(BinaryComparable::compareTo)).thenComparing(KeyExtent::getPrevEndRow, Comparator.nullsFirst(BinaryComparable::compareTo));
    private int hashCode = 0;

    private void check() {
        if (this.getTableId() == null) {
            throw new IllegalArgumentException("null table id not allowed");
        }
        if (this.getEndRow() == null || this.getPrevEndRow() == null) {
            return;
        }
        if (this.getPrevEndRow().compareTo((BinaryComparable)this.getEndRow()) >= 0) {
            throw new IllegalArgumentException("prevEndRow (" + this.getPrevEndRow() + ") >= endRow (" + this.getEndRow() + ")");
        }
    }

    public KeyExtent() {
        this.setTableId(EMPTY_ID);
        this.setEndRow(new Text(), false, false);
        this.setPrevEndRow(new Text(), false, false);
    }

    public KeyExtent(TableId table, Text endRow, Text prevEndRow) {
        this.setTableId(table);
        this.setEndRow(endRow, false, true);
        this.setPrevEndRow(prevEndRow, false, true);
        this.check();
    }

    public KeyExtent(KeyExtent extent) {
        this.tableId = extent.tableId;
        this.setEndRow(extent.getEndRow(), false, true);
        this.setPrevEndRow(extent.getPrevEndRow(), false, true);
        this.check();
    }

    public KeyExtent(TKeyExtent tke) {
        this.setTableId(TableId.of(new String(ByteBufferUtil.toBytes(tke.table), StandardCharsets.UTF_8)));
        this.setEndRow(tke.endRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.endRow)), false, false);
        this.setPrevEndRow(tke.prevEndRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.prevEndRow)), false, false);
        this.check();
    }

    public Text getMetadataEntry() {
        return MetadataSchema.TabletsSection.getRow(this.getTableId(), this.getEndRow());
    }

    public KeyExtent(Text flattenedExtent, Value prevEndRow) {
        this.decodeMetadataRow(flattenedExtent);
        this.setPrevEndRow(KeyExtent.decodePrevEndRow(prevEndRow), false, true);
        this.check();
    }

    public KeyExtent(Text flattenedExtent, Text prevEndRow) {
        this.decodeMetadataRow(flattenedExtent);
        this.setPrevEndRow(null, false, false);
        if (prevEndRow != null) {
            this.setPrevEndRow(prevEndRow, false, true);
        }
        this.check();
    }

    public void setTableId(TableId tId) {
        Objects.requireNonNull(tId, "null table id not allowed");
        this.tableId = tId;
        this.hashCode = 0;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    private void setEndRow(Text endRow, boolean check, boolean copy) {
        this.textEndRow = endRow != null ? (copy ? new Text(endRow) : endRow) : null;
        this.hashCode = 0;
        if (check) {
            this.check();
        }
    }

    public void setEndRow(Text endRow) {
        this.setEndRow(endRow, true, true);
    }

    public Text getEndRow() {
        return this.textEndRow;
    }

    public Text getPrevEndRow() {
        return this.textPrevEndRow;
    }

    private void setPrevEndRow(Text prevEndRow, boolean check, boolean copy) {
        this.textPrevEndRow = prevEndRow != null ? (copy ? new Text(prevEndRow) : prevEndRow) : null;
        this.hashCode = 0;
        if (check) {
            this.check();
        }
    }

    public void setPrevEndRow(Text prevEndRow) {
        this.setPrevEndRow(prevEndRow, true, true);
    }

    public void readFields(DataInput in) throws IOException {
        Text tid = new Text();
        tid.readFields(in);
        this.setTableId(TableId.of(tid.toString()));
        boolean hasRow = in.readBoolean();
        if (hasRow) {
            Text er = new Text();
            er.readFields(in);
            this.setEndRow(er, false, false);
        } else {
            this.setEndRow(null, false, false);
        }
        boolean hasPrevRow = in.readBoolean();
        if (hasPrevRow) {
            Text per = new Text();
            per.readFields(in);
            this.setPrevEndRow(per, false, true);
        } else {
            this.setPrevEndRow(null);
        }
        this.hashCode = 0;
        this.check();
    }

    public void write(DataOutput out) throws IOException {
        new Text(this.getTableId().canonical()).write(out);
        if (this.getEndRow() != null) {
            out.writeBoolean(true);
            this.getEndRow().write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.getPrevEndRow() != null) {
            out.writeBoolean(true);
            this.getPrevEndRow().write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public Mutation getPrevRowUpdateMutation() {
        return KeyExtent.getPrevRowUpdateMutation(this);
    }

    public static Text decodePrevEndRow(Value ibw) {
        Text per = null;
        if (ibw.get()[0] != 0) {
            per = new Text();
            per.set(ibw.get(), 1, ibw.get().length - 1);
        }
        return per;
    }

    public static Value encodePrevEndRow(Text per) {
        if (per == null) {
            return new Value(new byte[]{0});
        }
        byte[] b = new byte[per.getLength() + 1];
        b[0] = 1;
        System.arraycopy(per.getBytes(), 0, b, 1, per.getLength());
        return new Value(b);
    }

    public static Mutation getPrevRowUpdateMutation(KeyExtent ke) {
        Mutation m = new Mutation(ke.getMetadataEntry());
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow(ke.getPrevEndRow()));
        return m;
    }

    public int compareTo(KeyExtent other) {
        return COMPARATOR.compare(this, other);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prevEndRowHash = 0;
        int endRowHash = 0;
        if (this.getEndRow() != null) {
            endRowHash = this.getEndRow().hashCode();
        }
        if (this.getPrevEndRow() != null) {
            prevEndRowHash = this.getPrevEndRow().hashCode();
        }
        this.hashCode = this.getTableId().hashCode() + endRowHash + prevEndRowHash;
        return this.hashCode;
    }

    private boolean equals(Text t1, Text t2) {
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        return t1.equals((Object)t2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyExtent)) {
            return false;
        }
        KeyExtent oke = (KeyExtent)o;
        return this.tableId.equals(oke.tableId) && this.equals(this.textEndRow, oke.textEndRow) && this.equals(this.textPrevEndRow, oke.textPrevEndRow);
    }

    public String toString() {
        String tableIdString = this.getTableId().canonical().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        String endRowString = this.getEndRow() == null ? "<" : ";" + TextUtil.truncate(this.getEndRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        String prevEndRowString = this.getPrevEndRow() == null ? "<" : ";" + TextUtil.truncate(this.getPrevEndRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        return tableIdString + endRowString + prevEndRowString;
    }

    public UUID getUUID() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.write(dos);
            dos.close();
            return UUID.nameUUIDFromBytes(baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void decodeMetadataRow(Text flattenedExtent) {
        int semiPos = -1;
        int ltPos = -1;
        for (int i = 0; i < flattenedExtent.getLength(); ++i) {
            if (flattenedExtent.getBytes()[i] == 59 && semiPos < 0) {
                semiPos = i;
            }
            if (flattenedExtent.getBytes()[i] != 60) continue;
            ltPos = i;
        }
        if (semiPos < 0 && ltPos < 0) {
            throw new IllegalArgumentException("Metadata row does not contain ; or <  " + flattenedExtent);
        }
        if (semiPos < 0) {
            if (ltPos != flattenedExtent.getLength() - 1) {
                throw new IllegalArgumentException("< must come at end of Metadata row  " + flattenedExtent);
            }
            String decodedString = new String(Arrays.copyOfRange(flattenedExtent.getBytes(), 0, flattenedExtent.getLength() - 1), StandardCharsets.UTF_8);
            TableId tableId = TableId.of(decodedString);
            this.setTableId(tableId);
            this.setEndRow(null, false, false);
        } else {
            TableId tableId = TableId.of(new String(Arrays.copyOfRange(flattenedExtent.getBytes(), 0, semiPos), StandardCharsets.UTF_8));
            Text endRow = new Text();
            endRow.set(flattenedExtent.getBytes(), semiPos + 1, flattenedExtent.getLength() - (semiPos + 1));
            this.setTableId(tableId);
            this.setEndRow(endRow, false, false);
        }
    }

    public static byte[] tableOfMetadataRow(Text row) {
        KeyExtent ke = new KeyExtent();
        ke.decodeMetadataRow(row);
        return ke.getTableId().canonical().getBytes(StandardCharsets.UTF_8);
    }

    public boolean contains(final ByteSequence bsrow) {
        if (bsrow == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        BinaryComparable row = new BinaryComparable(){

            public int getLength() {
                return bsrow.length();
            }

            public byte[] getBytes() {
                if (bsrow.isBackedByArray() && bsrow.offset() == 0) {
                    return bsrow.getBackingArray();
                }
                return bsrow.toArray();
            }
        };
        return !(this.getPrevEndRow() != null && this.getPrevEndRow().compareTo(row) >= 0 || this.getEndRow() != null && this.getEndRow().compareTo(row) < 0);
    }

    public boolean contains(BinaryComparable row) {
        if (row == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        return !(this.getPrevEndRow() != null && this.getPrevEndRow().compareTo(row) >= 0 || this.getEndRow() != null && this.getEndRow().compareTo(row) < 0);
    }

    public Range toDataRange() {
        return new Range(this.getPrevEndRow(), false, this.getEndRow(), true);
    }

    public Range toMetadataRange() {
        Text metadataPrevRow = MetadataSchema.TabletsSection.getRow(this.getTableId(), this.getPrevEndRow() == null ? EMPTY_TEXT : this.getPrevEndRow());
        return new Range(metadataPrevRow, this.getPrevEndRow() == null, this.getMetadataEntry(), true);
    }

    public static SortedSet<KeyExtent> findChildren(KeyExtent ke, SortedSet<KeyExtent> tablets) {
        TreeSet<KeyExtent> children = null;
        for (KeyExtent tabletKe : tablets) {
            if (ke.getPrevEndRow() == tabletKe.getPrevEndRow() || ke.getPrevEndRow() != null && tabletKe.getPrevEndRow() != null && tabletKe.getPrevEndRow().compareTo((BinaryComparable)ke.getPrevEndRow()) == 0) {
                children = new TreeSet<KeyExtent>();
            }
            if (children != null) {
                children.add(tabletKe);
            }
            if (ke.getEndRow() != tabletKe.getEndRow() && (ke.getEndRow() == null || tabletKe.getEndRow() == null || tabletKe.getEndRow().compareTo((BinaryComparable)ke.getEndRow()) != 0)) continue;
            return children;
        }
        return new TreeSet<KeyExtent>();
    }

    public static KeyExtent findContainingExtent(KeyExtent extent, SortedSet<KeyExtent> extents) {
        KeyExtent lookupExtent = new KeyExtent(extent);
        lookupExtent.setPrevEndRow(null);
        SortedSet<KeyExtent> tailSet = extents.tailSet(lookupExtent);
        if (tailSet.isEmpty()) {
            return null;
        }
        KeyExtent first = tailSet.first();
        if (first.getTableId().compareTo(extent.getTableId()) != 0) {
            return null;
        }
        if (first.getPrevEndRow() == null) {
            return first;
        }
        if (extent.getPrevEndRow() == null) {
            return null;
        }
        if (extent.getPrevEndRow().compareTo((BinaryComparable)first.getPrevEndRow()) >= 0) {
            return first;
        }
        return null;
    }

    private static boolean startsAfter(KeyExtent nke, KeyExtent ke) {
        int tiCmp = ke.getTableId().compareTo(nke.getTableId());
        if (tiCmp > 0) {
            return true;
        }
        return ke.getPrevEndRow() != null && nke.getEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)nke.getEndRow()) >= 0;
    }

    private static Text rowAfterPrevRow(KeyExtent nke) {
        Text row = new Text(nke.getPrevEndRow());
        row.append(new byte[]{0}, 0, 1);
        return row;
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedSet<KeyExtent> extents) {
        KeyExtent ke;
        SortedSet<KeyExtent> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.getPrevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), row, null);
            start = extents.tailSet(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), new Text(), null);
            start = extents.tailSet(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator iterator = start.iterator();
        while (iterator.hasNext() && !KeyExtent.startsAfter(nke, ke = (KeyExtent)iterator.next())) {
            result.add(ke);
        }
        return result;
    }

    public boolean overlaps(KeyExtent other) {
        TreeSet<KeyExtent> set = new TreeSet<KeyExtent>();
        set.add(other);
        return !KeyExtent.findOverlapping(this, set).isEmpty();
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedMap<KeyExtent, ?> extents) {
        Map.Entry<KeyExtent, ?> entry;
        KeyExtent ke;
        SortedMap<KeyExtent, ?> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.getPrevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), row, null);
            start = extents.tailMap(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), new Text(), null);
            start = extents.tailMap(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator<Map.Entry<KeyExtent, ?>> iterator = start.entrySet().iterator();
        while (iterator.hasNext() && !KeyExtent.startsAfter(nke, ke = (entry = iterator.next()).getKey())) {
            result.add(ke);
        }
        return result;
    }

    public static Text getMetadataEntry(KeyExtent extent) {
        return MetadataSchema.TabletsSection.getRow(extent.getTableId(), extent.getEndRow());
    }

    public TKeyExtent toThrift() {
        return new TKeyExtent(ByteBuffer.wrap(this.tableId.canonical().getBytes(StandardCharsets.UTF_8)), this.textEndRow == null ? null : TextUtil.getByteBuffer(this.textEndRow), this.textPrevEndRow == null ? null : TextUtil.getByteBuffer(this.textPrevEndRow));
    }

    public boolean isPreviousExtent(KeyExtent prevExtent) {
        if (prevExtent == null) {
            return this.getPrevEndRow() == null;
        }
        if (!prevExtent.getTableId().equals(this.getTableId())) {
            throw new IllegalArgumentException("Cannot compare across tables " + prevExtent + " " + this);
        }
        if (prevExtent.getEndRow() == null) {
            return false;
        }
        if (this.getPrevEndRow() == null) {
            return false;
        }
        return prevExtent.getEndRow().equals((Object)this.getPrevEndRow());
    }

    public boolean isMeta() {
        return this.getTableId().equals(MetadataTable.ID) || this.isRootTablet();
    }

    public boolean isRootTablet() {
        return this.getTableId().equals(RootTable.ID);
    }
}

