/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.constraints;

import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;

public class NoDeleteConstraint
implements Constraint {
    @Override
    public String getViolationDescription(short violationCode) {
        if (violationCode == 1) {
            return "Deletes are not allowed";
        }
        return null;
    }

    @Override
    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        List<ColumnUpdate> updates = mutation.getUpdates();
        for (ColumnUpdate update2 : updates) {
            if (!update2.isDeleted()) continue;
            return Collections.singletonList((short)1);
        }
        return null;
    }
}

