/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.compaction;

import java.util.Map;
import org.apache.accumulo.core.compaction.NullType;
import org.apache.accumulo.core.compaction.PatternType;
import org.apache.accumulo.core.compaction.SizeType;
import org.apache.accumulo.core.compaction.StringType;
import org.apache.accumulo.core.compaction.Type;
import org.apache.accumulo.core.compaction.UIntType;

public enum CompactionSettings {
    SF_NO_SUMMARY(new NullType()),
    SF_EXTRA_SUMMARY(new NullType()),
    SF_NO_SAMPLE(new NullType()),
    SF_GT_ESIZE_OPT(new SizeType()),
    SF_LT_ESIZE_OPT(new SizeType()),
    SF_NAME_RE_OPT(new PatternType()),
    SF_PATH_RE_OPT(new PatternType()),
    MIN_FILES_OPT(new UIntType()),
    OUTPUT_COMPRESSION_OPT(new StringType()),
    OUTPUT_BLOCK_SIZE_OPT(new SizeType()),
    OUTPUT_HDFS_BLOCK_SIZE_OPT(new SizeType()),
    OUTPUT_INDEX_BLOCK_SIZE_OPT(new SizeType()),
    OUTPUT_REPLICATION_OPT(new UIntType());

    private Type type;

    private CompactionSettings(Type type) {
        this.type = type;
    }

    public void put(Map<String, String> options, String val) {
        options.put(this.name(), this.type.convert(val));
    }
}

