/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.clientImpl.bulk.BulkSerialize;
import org.apache.accumulo.core.clientImpl.bulk.ConcurrentKeyExtentCache;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.LoadPlan;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImport
implements TableOperations.ImportDestinationArguments,
TableOperations.ImportMappingOptions {
    private static final Logger log = LoggerFactory.getLogger(BulkImport.class);
    private boolean setTime = false;
    private Executor executor = null;
    private final String dir;
    private int numThreads = -1;
    private final ClientContext context;
    private String tableName;
    private LoadPlan plan = null;
    private static final byte[] byte0 = new byte[]{0};

    public BulkImport(String directory, ClientContext context) {
        this.context = context;
        this.dir = Objects.requireNonNull(directory);
    }

    @Override
    public TableOperations.ImportMappingOptions tableTime(boolean value) {
        this.setTime = value;
        return this;
    }

    @Override
    public void load() throws TableNotFoundException, IOException, AccumuloException, AccumuloSecurityException {
        TableId tableId = Tables.getTableId(this.context, this.tableName);
        Map<String, String> props = this.context.instanceOperations().getSystemConfiguration();
        ConfigurationCopy conf = new ConfigurationCopy(props);
        FileSystem fs = VolumeConfiguration.getVolume(this.dir, this.context.getHadoopConf(), conf).getFileSystem();
        Path srcPath = this.checkPath(fs, this.dir);
        SortedMap<KeyExtent, Bulk.Files> mappings = this.plan == null ? this.computeMappingFromFiles(fs, tableId, srcPath) : this.computeMappingFromPlan(fs, tableId, srcPath);
        if (mappings.isEmpty()) {
            throw new IllegalArgumentException("Attempted to import zero files from " + srcPath);
        }
        BulkSerialize.writeLoadMapping(mappings, srcPath.toString(), arg_0 -> ((FileSystem)fs).create(arg_0));
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.canonical().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(srcPath.toString().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap((this.setTime + "").getBytes(StandardCharsets.UTF_8)));
        new TableOperationsImpl(this.context).doBulkFateOperation(args, this.tableName);
    }

    private Path checkPath(FileSystem fs, String dir) throws IOException, AccumuloException {
        Path ret = dir.contains(":") ? new Path(dir) : fs.makeQualified(new Path(dir));
        try {
            if (!fs.getFileStatus(ret).isDirectory()) {
                throw new AccumuloException("Bulk import directory " + dir + " is not a directory!");
            }
            Path tmpFile = new Path(ret, "isWritable");
            if (!fs.createNewFile(tmpFile)) {
                throw new AccumuloException("Bulk import directory " + dir + " is not writable.");
            }
            fs.delete(tmpFile, true);
        }
        catch (FileNotFoundException fnf) {
            throw new AccumuloException("Bulk import directory " + dir + " does not exist or has bad permissions", fnf);
        }
        return ret;
    }

    @Override
    public TableOperations.ImportMappingOptions executor(Executor service) {
        this.executor = Objects.requireNonNull(service);
        return this;
    }

    @Override
    public TableOperations.ImportMappingOptions threads(int numThreads) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"Non positive number of threads given : %s", (int)numThreads);
        this.numThreads = numThreads;
        return this;
    }

    @Override
    public TableOperations.ImportMappingOptions plan(LoadPlan plan) {
        this.plan = Objects.requireNonNull(plan);
        return this;
    }

    @Override
    public TableOperations.ImportMappingOptions to(String tableName) {
        this.tableName = Objects.requireNonNull(tableName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<KeyExtent, Long> estimateSizes(AccumuloConfiguration acuConf, Path mapFile, long fileSize, Collection<KeyExtent> extents, FileSystem ns, Cache<String, Long> fileLenCache, CryptoService cs) throws IOException {
        if (extents.size() == 1) {
            return Collections.singletonMap(extents.iterator().next(), fileSize);
        }
        long totalIndexEntries = 0L;
        TreeMap<KeyExtent, MLong> counts = new TreeMap<KeyExtent, MLong>();
        for (KeyExtent keyExtent : extents) {
            counts.put(keyExtent, new MLong(0L));
        }
        Text row = new Text();
        FileSKVIterator index = FileOperations.getInstance().newIndexReaderBuilder().forFile(mapFile.toString(), ns, ns.getConf(), cs).withTableConfiguration(acuConf).withFileLenCache(fileLenCache).build();
        try {
            while (index.hasTop()) {
                Key key = (Key)index.getTopKey();
                ++totalIndexEntries;
                key.getRow(row);
                for (Map.Entry entry : counts.entrySet()) {
                    if (!((KeyExtent)entry.getKey()).contains((BinaryComparable)row)) continue;
                    ++((MLong)entry.getValue()).l;
                }
                index.next();
            }
        }
        finally {
            try {
                if (index != null) {
                    index.close();
                }
            }
            catch (IOException e) {
                log.debug("Failed to close " + mapFile, (Throwable)e);
            }
        }
        TreeMap<KeyExtent, Long> results = new TreeMap<KeyExtent, Long>();
        for (KeyExtent keyExtent : extents) {
            double numEntries = ((MLong)counts.get((Object)keyExtent)).l;
            if (numEntries == 0.0) {
                numEntries = 1.0;
            }
            long estSize = (long)(numEntries / (double)totalIndexEntries * (double)fileSize);
            results.put(keyExtent, estSize);
        }
        return results;
    }

    public static List<KeyExtent> findOverlappingTablets(KeyExtentCache extentCache, FileSKVIterator reader) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Text startRow = null;
        BinaryComparable endRow = null;
        ArrayList<KeyExtent> result = new ArrayList<KeyExtent>();
        List<ByteSequence> columnFamilies = Collections.emptyList();
        Text row = startRow;
        if (row == null) {
            row = new Text();
        }
        while (true) {
            reader.seek(new Range(row, null), columnFamilies, false);
            if (!reader.hasTop()) break;
            row = ((Key)reader.getTopKey()).getRow();
            KeyExtent extent = extentCache.lookup(row);
            result.add(extent);
            row = extent.getEndRow();
            if (row == null || endRow != null && row.compareTo(endRow) >= 0) break;
            row = BulkImport.nextRow(row);
        }
        return result;
    }

    private static Text nextRow(Text row) {
        Text next = new Text(row);
        next.append(byte0, 0, byte0.length);
        return next;
    }

    public static List<KeyExtent> findOverlappingTablets(ClientContext context, KeyExtentCache extentCache, Path file, FileSystem fs, Cache<String, Long> fileLenCache, CryptoService cs) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try (FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(file.toString(), fs, fs.getConf(), cs).withTableConfiguration(context.getConfiguration()).withFileLenCache(fileLenCache).seekToBeginning().build();){
            List<KeyExtent> list = BulkImport.findOverlappingTablets(extentCache, reader);
            return list;
        }
    }

    private static Map<String, Long> getFileLenMap(List<FileStatus> statuses) {
        HashMap<String, Long> fileLens = new HashMap<String, Long>();
        for (FileStatus status : statuses) {
            fileLens.put(status.getPath().getName(), status.getLen());
            status.getLen();
        }
        return fileLens;
    }

    private static Cache<String, Long> getPopulatedFileLenCache(Path dir, List<FileStatus> statuses) {
        Map<String, Long> fileLens = BulkImport.getFileLenMap(statuses);
        HashMap absFileLens = new HashMap();
        fileLens.forEach((k, v) -> absFileLens.put(CachableBlockFile.pathToCacheId(new Path(dir, k)), v));
        Cache fileLenCache = CacheBuilder.newBuilder().build();
        fileLenCache.putAll(absFileLens);
        return fileLenCache;
    }

    private SortedMap<KeyExtent, Bulk.Files> computeMappingFromPlan(FileSystem fs, TableId tableId, Path srcPath) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Map<String, List<LoadPlan.Destination>> fileDestinations = this.plan.getDestinations().stream().collect(Collectors.groupingBy(LoadPlan.Destination::getFileName));
        List<FileStatus> statuses = BulkImport.filterInvalid(fs.listStatus(srcPath, p -> !p.getName().equals("loadmap.json")));
        Map<String, Long> fileLens = BulkImport.getFileLenMap(statuses);
        if (!fileDestinations.keySet().equals(fileLens.keySet())) {
            throw new IllegalArgumentException("Load plan files differ from directory files, symmetric difference : " + Sets.symmetricDifference(fileDestinations.keySet(), fileLens.keySet()));
        }
        ConcurrentKeyExtentCache extentCache = new ConcurrentKeyExtentCache(tableId, this.context);
        fileDestinations.values().stream().flatMap(Collection::stream).filter(dest -> dest.getRangeType() == LoadPlan.RangeType.FILE).flatMap(dest -> Stream.of(dest.getStartRow(), dest.getEndRow())).filter(row -> row != null).map(Text::new).sorted().distinct().forEach(row -> {
            try {
                extentCache.lookup((Text)row);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        TreeMap<KeyExtent, Bulk.Files> mapping = new TreeMap<KeyExtent, Bulk.Files>();
        for (Map.Entry<String, List<LoadPlan.Destination>> entry : fileDestinations.entrySet()) {
            String fileName = entry.getKey();
            List<LoadPlan.Destination> destinations = entry.getValue();
            Set<KeyExtent> extents = this.mapDesitnationsToExtents(tableId, extentCache, destinations);
            long estSize = (long)((double)fileLens.get(fileName).longValue() / (double)extents.size());
            for (KeyExtent keyExtent : extents) {
                mapping.computeIfAbsent(keyExtent, k -> new Bulk.Files()).add(new Bulk.FileInfo(fileName, estSize, 0L));
            }
        }
        return BulkImport.mergeOverlapping(mapping);
    }

    private Text toText(byte[] row) {
        return row == null ? null : new Text(row);
    }

    private Set<KeyExtent> mapDesitnationsToExtents(TableId tableId, KeyExtentCache kec, List<LoadPlan.Destination> destinations) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        HashSet<KeyExtent> extents = new HashSet<KeyExtent>();
        for (LoadPlan.Destination dest : destinations) {
            if (dest.getRangeType() == LoadPlan.RangeType.TABLE) {
                extents.add(new KeyExtent(tableId, this.toText(dest.getEndRow()), this.toText(dest.getStartRow())));
                continue;
            }
            if (dest.getRangeType() == LoadPlan.RangeType.FILE) {
                Text startRow = new Text(dest.getStartRow());
                Text endRow = new Text(dest.getEndRow());
                KeyExtent extent = kec.lookup(startRow);
                extents.add(extent);
                while (!extent.contains((BinaryComparable)endRow) && extent.getEndRow() != null) {
                    extent = kec.lookup(BulkImport.nextRow(extent.getEndRow()));
                    extents.add(extent);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return extents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<KeyExtent, Bulk.Files> computeMappingFromFiles(FileSystem fs, TableId tableId, Path dirPath) throws IOException {
        Executor executor;
        ExecutorService service = null;
        if (this.executor != null) {
            executor = this.executor;
        } else if (this.numThreads > 0) {
            service = Executors.newFixedThreadPool(this.numThreads);
            executor = service;
        } else {
            String threads = this.context.getConfiguration().get(ClientProperty.BULK_LOAD_THREADS.getKey());
            service = Executors.newFixedThreadPool(ConfigurationTypeHelper.getNumThreads(threads));
            executor = service;
        }
        try {
            SortedMap<KeyExtent, Bulk.Files> sortedMap = BulkImport.computeFileToTabletMappings(fs, tableId, dirPath, executor, this.context);
            return sortedMap;
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    public static List<FileStatus> filterInvalid(FileStatus[] files) {
        ArrayList<FileStatus> fileList = new ArrayList<FileStatus>(files.length);
        for (FileStatus fileStatus : files) {
            String fname = fileStatus.getPath().getName();
            if (fileStatus.isDirectory()) {
                log.debug("{} is a directory, ignoring.", (Object)fileStatus.getPath());
                continue;
            }
            if (FileOperations.getBulkWorkingFiles().contains(fname)) {
                log.debug("{} is an internal working file, ignoring.", (Object)fileStatus.getPath());
                continue;
            }
            if (!FileOperations.getValidExtensions().contains(FilenameUtils.getExtension((String)fname))) {
                log.warn("{} does not have a valid extension, ignoring", (Object)fileStatus.getPath());
                continue;
            }
            fileList.add(fileStatus);
        }
        return fileList;
    }

    public static SortedMap<KeyExtent, Bulk.Files> computeFileToTabletMappings(FileSystem fs, TableId tableId, Path dirPath, Executor executor, ClientContext context) throws IOException {
        ConcurrentKeyExtentCache extentCache = new ConcurrentKeyExtentCache(tableId, context);
        List<FileStatus> files = BulkImport.filterInvalid(fs.listStatus(dirPath, p -> !p.getName().equals("loadmap.json")));
        Cache<String, Long> fileLensCache = BulkImport.getPopulatedFileLenCache(dirPath, files);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        CryptoService cs = CryptoServiceFactory.newDefaultInstance();
        for (FileStatus fileStatus : files) {
            CompletableFuture future = CompletableFuture.supplyAsync(() -> {
                try {
                    long t1 = System.currentTimeMillis();
                    List<KeyExtent> extents = BulkImport.findOverlappingTablets(context, extentCache, fileStatus.getPath(), fs, fileLensCache, cs);
                    Map<KeyExtent, Long> estSizes = BulkImport.estimateSizes(context.getConfiguration(), fileStatus.getPath(), fileStatus.getLen(), extents, fs, fileLensCache, cs);
                    HashMap<KeyExtent, Bulk.FileInfo> pathLocations = new HashMap<KeyExtent, Bulk.FileInfo>();
                    for (KeyExtent ke : extents) {
                        pathLocations.put(ke, new Bulk.FileInfo(fileStatus.getPath(), estSizes.getOrDefault(ke, 0L)));
                    }
                    long t2 = System.currentTimeMillis();
                    log.trace("Mapped {} to {} tablets in {}ms", new Object[]{fileStatus.getPath(), pathLocations.size(), t2 - t1});
                    return pathLocations;
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, executor);
            futures.add(future);
        }
        TreeMap<KeyExtent, Bulk.Files> mappings = new TreeMap<KeyExtent, Bulk.Files>();
        for (CompletableFuture future : futures) {
            try {
                Map pathMapping = (Map)future.get();
                pathMapping.forEach((extent, path) -> mappings.computeIfAbsent((KeyExtent)extent, k -> new Bulk.Files()).add((Bulk.FileInfo)path));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return BulkImport.mergeOverlapping(mappings);
    }

    static SortedMap<KeyExtent, Bulk.Files> mergeOverlapping(SortedMap<KeyExtent, Bulk.Files> mappings) {
        ArrayList<KeyExtent> extents = new ArrayList<KeyExtent>(mappings.keySet());
        for (KeyExtent ke : extents) {
            Set<KeyExtent> overlapping = KeyExtent.findOverlapping(ke, mappings);
            for (KeyExtent oke : overlapping) {
                boolean containsEndRow;
                if (ke.equals(oke)) continue;
                boolean containsPrevRow = ke.getPrevEndRow() == null || oke.getPrevEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)oke.getPrevEndRow()) <= 0;
                boolean bl = containsEndRow = ke.getEndRow() == null || oke.getEndRow() != null && ke.getEndRow().compareTo((BinaryComparable)oke.getEndRow()) >= 0;
                if (containsPrevRow && containsEndRow) {
                    ((Bulk.Files)mappings.get(ke)).merge((Bulk.Files)mappings.remove(oke));
                    continue;
                }
                throw new RuntimeException("TODO handle merges");
            }
        }
        return mappings;
    }

    public static interface KeyExtentCache {
        public KeyExtent lookup(Text var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;
    }

    private static class MLong {
        long l;

        public MLong(long i) {
            this.l = i;
        }
    }
}

