/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.clientImpl.BatchWriterImpl;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletServerBatchReader;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;

public class TabletServerBatchDeleter
extends TabletServerBatchReader
implements BatchDeleter {
    private final ClientContext context;
    private TableId tableId;
    private BatchWriterConfig bwConfig;

    public TabletServerBatchDeleter(ClientContext context, TableId tableId, Authorizations authorizations, int numQueryThreads, BatchWriterConfig bwConfig) {
        super(context, tableId, authorizations, numQueryThreads);
        this.context = context;
        this.tableId = tableId;
        this.bwConfig = bwConfig;
        super.addScanIterator(new IteratorSetting(Integer.MAX_VALUE, BatchDeleter.class.getName().replaceAll("[.]", "_") + "_NOVALUE", SortedKeyIterator.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws MutationsRejectedException {
        try (BatchWriter bw = null;){
            bw = new BatchWriterImpl(this.context, this.tableId, this.bwConfig);
            Iterator<Map.Entry<Key, Value>> iter = super.iterator();
            while (iter.hasNext()) {
                Map.Entry<Key, Value> next = iter.next();
                Key k = next.getKey();
                Mutation m = new Mutation(k.getRow());
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), k.getTimestamp());
                bw.addMutation(m);
            }
        }
    }
}

