/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMap {
    private static final Logger log = LoggerFactory.getLogger(TableMap.class);
    private final Map<String, TableId> tableNameToIdMap;
    private final Map<TableId, String> tableIdToNameMap;
    private final ZooCache zooCache;
    private final long updateCount;

    public TableMap(ClientContext context, ZooCache zooCache) {
        this.zooCache = zooCache;
        this.updateCount = zooCache.getUpdateCount();
        List<String> tableIds = zooCache.getChildren(context.getZooKeeperRoot() + "/tables");
        HashMap<NamespaceId, String> namespaceIdToNameMap = new HashMap<NamespaceId, String>();
        ImmutableMap.Builder tableNameToIdBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder tableIdToNameBuilder = new ImmutableMap.Builder();
        StringBuilder zPathBuilder = new StringBuilder();
        zPathBuilder.append(context.getZooKeeperRoot()).append("/tables").append("/");
        int prefixLength = zPathBuilder.length();
        for (String tableIdStr : tableIds) {
            String namespaceName;
            byte[] tableName;
            block6: {
                zPathBuilder.setLength(prefixLength);
                zPathBuilder.append(tableIdStr).append("/name");
                tableName = zooCache.get(zPathBuilder.toString());
                zPathBuilder.setLength(prefixLength);
                zPathBuilder.append(tableIdStr).append("/namespace");
                byte[] nId = zooCache.get(zPathBuilder.toString());
                namespaceName = Namespace.DEFAULT.name();
                if (nId == null) {
                    namespaceName = null;
                } else {
                    NamespaceId namespaceId = NamespaceId.of(new String(nId, StandardCharsets.UTF_8));
                    if (!namespaceId.equals(Namespace.DEFAULT.id())) {
                        try {
                            namespaceName = (String)namespaceIdToNameMap.get(namespaceId);
                            if (namespaceName != null) break block6;
                            namespaceName = Namespaces.getNamespaceName(context, namespaceId);
                            namespaceIdToNameMap.put(namespaceId, namespaceName);
                        }
                        catch (NamespaceNotFoundException e) {
                            log.error("Table (" + tableIdStr + ") contains reference to namespace (" + namespaceId + ") that doesn't exist", (Throwable)e);
                            continue;
                        }
                    }
                }
            }
            if (tableName == null || namespaceName == null) continue;
            String tableNameStr = Tables.qualified(new String(tableName, StandardCharsets.UTF_8), namespaceName);
            TableId tableId = TableId.of(tableIdStr);
            tableNameToIdBuilder.put((Object)tableNameStr, (Object)tableId);
            tableIdToNameBuilder.put((Object)tableId, (Object)tableNameStr);
        }
        this.tableNameToIdMap = tableNameToIdBuilder.build();
        this.tableIdToNameMap = tableIdToNameBuilder.build();
    }

    public Map<String, TableId> getNameToIdMap() {
        return this.tableNameToIdMap;
    }

    public Map<TableId, String> getIdtoNameMap() {
        return this.tableIdToNameMap;
    }

    public boolean isCurrent(ZooCache zc) {
        return this.zooCache == zc && this.updateCount == zc.getUpdateCount();
    }
}

