/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientExec;
import org.apache.accumulo.core.clientImpl.ClientExecReturn;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.DelegationTokenConfigSerializer;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.ServerClient;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationToken;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationTokenConfig;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.ByteBufferUtil;

public class SecurityOperationsImpl
implements SecurityOperations {
    private final ClientContext context;

    private void executeVoid(ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRawVoid(this.context, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (ttoe.getType() == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    private <T> T execute(ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(this.context, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (ttoe.getType() == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public SecurityOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    public void createLocalUser(String principal, PasswordToken password) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        if (this.context.getSaslParams() == null) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password is null");
        }
        this.executeVoid(client -> {
            if (this.context.getSaslParams() == null) {
                client.createLocalUser(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, ByteBuffer.wrap(password.getPassword()));
            } else {
                client.createLocalUser(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, ByteBuffer.wrap(new byte[0]));
            }
        });
    }

    @Override
    public void dropLocalUser(String principal) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        this.executeVoid(client -> client.dropLocalUser(TraceUtil.traceInfo(), this.context.rpcCreds(), principal));
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        Credentials toAuth = new Credentials(principal, token);
        return this.execute(client -> client.authenticateUser(TraceUtil.traceInfo(), this.context.rpcCreds(), toAuth.toThrift(this.context.getInstanceID())));
    }

    @Override
    public void changeLocalUserPassword(String principal, PasswordToken token) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        Credentials toChange = new Credentials(principal, token);
        this.executeVoid(client -> client.changeLocalUserPassword(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, ByteBuffer.wrap(token.getPassword())));
        if (this.context.getCredentials().getPrincipal().equals(principal)) {
            this.context.setCredentials(toChange);
        }
    }

    @Override
    public void changeUserAuthorizations(String principal, Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.executeVoid(client -> client.changeAuthorizations(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, ByteBufferUtil.toByteBuffers(authorizations.getAuthorizations())));
    }

    @Override
    public Authorizations getUserAuthorizations(String principal) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        return this.execute(client -> new Authorizations(client.getUserAuthorizations(TraceUtil.traceInfo(), this.context.rpcCreds(), principal)));
    }

    @Override
    public boolean hasSystemPermission(String principal, SystemPermission perm) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((perm != null ? 1 : 0) != 0, (Object)"perm is null");
        return this.execute(client -> client.hasSystemPermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, perm.getId()));
    }

    @Override
    public boolean hasTablePermission(String principal, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((perm != null ? 1 : 0) != 0, (Object)"perm is null");
        try {
            return this.execute(client -> client.hasTablePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, table, perm.getId()));
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public boolean hasNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        return this.execute(client -> client.hasNamespacePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, namespace, permission.getId()));
    }

    @Override
    public void grantSystemPermission(String principal, SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(client -> client.grantSystemPermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, permission.getId()));
    }

    @Override
    public void grantTablePermission(String principal, String table, TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        try {
            this.executeVoid(client -> client.grantTablePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, table, permission.getId()));
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public void grantNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(client -> client.grantNamespacePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, namespace, permission.getId()));
    }

    @Override
    public void revokeSystemPermission(String principal, SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(client -> client.revokeSystemPermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, permission.getId()));
    }

    @Override
    public void revokeTablePermission(String principal, String table, TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        try {
            this.executeVoid(client -> client.revokeTablePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, table, permission.getId()));
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public void revokeNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(client -> client.revokeNamespacePermission(TraceUtil.traceInfo(), this.context.rpcCreds(), principal, namespace, permission.getId()));
    }

    @Override
    public Set<String> listLocalUsers() throws AccumuloException, AccumuloSecurityException {
        return this.execute(client -> client.listLocalUsers(TraceUtil.traceInfo(), this.context.rpcCreds()));
    }

    @Override
    public DelegationToken getDelegationToken(DelegationTokenConfig cfg) throws AccumuloException, AccumuloSecurityException {
        TDelegationToken thriftToken;
        TDelegationTokenConfig tConfig = cfg != null ? DelegationTokenConfigSerializer.serialize(cfg) : new TDelegationTokenConfig();
        try {
            thriftToken = MasterClient.execute(this.context, client -> client.getDelegationToken(TraceUtil.traceInfo(), this.context.rpcCreds(), tConfig));
        }
        catch (TableNotFoundException e) {
            throw new AssertionError("Received TableNotFoundException on method which should not throw that exception", e);
        }
        AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier(thriftToken.getIdentifier());
        return new DelegationTokenImpl(thriftToken.getPassword(), identifier);
    }
}

