/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationOperationsImpl
implements ReplicationOperations {
    private static final Logger log = LoggerFactory.getLogger(ReplicationOperationsImpl.class);
    private final ClientContext context;

    public ReplicationOperationsImpl(ClientContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    @Override
    public void addPeer(String name, String replicaType) throws AccumuloException, AccumuloSecurityException {
        Objects.requireNonNull(name);
        Objects.requireNonNull(replicaType);
        this.context.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + name, replicaType);
    }

    @Override
    public void removePeer(String name) throws AccumuloException, AccumuloSecurityException {
        Objects.requireNonNull(name);
        this.context.instanceOperations().removeProperty(Property.REPLICATION_PEERS.getKey() + name);
    }

    @Override
    public void drain(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Objects.requireNonNull(tableName);
        Set<String> wals = this.referencedFiles(tableName);
        this.drain(tableName, wals);
    }

    @Override
    public void drain(String tableName, Set<String> wals) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Objects.requireNonNull(tableName);
        TInfo tinfo = TraceUtil.traceInfo();
        TCredentials rpcCreds = this.context.rpcCreds();
        boolean drained = false;
        while (!drained) {
            drained = this.getMasterDrain(tinfo, rpcCreds, tableName, wals);
            if (drained) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted", e);
            }
        }
    }

    protected boolean getMasterDrain(TInfo tinfo, TCredentials rpcCreds, String tableName, Set<String> wals) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        return MasterClient.execute(this.context, client -> client.drainReplicationTable(tinfo, rpcCreds, tableName, wals));
    }

    protected TableId getTableId(AccumuloClient client, String tableName) throws TableNotFoundException {
        TableOperations tops = client.tableOperations();
        if (!client.tableOperations().exists(tableName)) {
            throw new TableNotFoundException(null, tableName, null);
        }
        String tableId = null;
        while (tableId == null) {
            tableId = tops.tableIdMap().get(tableName);
            if (tableId != null) continue;
            UtilWaitThread.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
        }
        return TableId.of(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> referencedFiles(String tableName) throws TableNotFoundException {
        Objects.requireNonNull(tableName);
        log.debug("Collecting referenced files for replication of table {}", (Object)tableName);
        TableId tableId = this.getTableId(this.context, tableName);
        log.debug("Found id of {} for name {}", (Object)tableId, (Object)tableName);
        BatchScanner metaBs = this.context.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 4);
        metaBs.setRanges(Collections.singleton(MetadataSchema.TabletsSection.getRange(tableId)));
        metaBs.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        HashSet<String> wals = new HashSet<String>();
        try {
            for (Map.Entry<Key, Value> entry : metaBs) {
                LogEntry logEntry = LogEntry.fromKeyValue(entry.getKey(), entry.getValue());
                wals.add(new Path(logEntry.filename).toString());
            }
        }
        finally {
            metaBs.close();
        }
        metaBs = this.context.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 4);
        metaBs.setRanges(Collections.singleton(MetadataSchema.ReplicationSection.getRange()));
        metaBs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            Text buffer = new Text();
            for (Map.Entry<Key, Value> entry : metaBs) {
                if (!tableId.equals(MetadataSchema.ReplicationSection.getTableId(entry.getKey()))) continue;
                MetadataSchema.ReplicationSection.getFile(entry.getKey(), buffer);
                wals.add(buffer.toString());
            }
        }
        finally {
            metaBs.close();
        }
        return wals;
    }
}

