/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.NamespaceOperationsHelper;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.ServerClient;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceOperationsImpl
extends NamespaceOperationsHelper {
    private final ClientContext context;
    private TableOperationsImpl tableOps;
    private static final Logger log = LoggerFactory.getLogger(TableOperations.class);

    public NamespaceOperationsImpl(ClientContext context, TableOperationsImpl tableOps) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
        this.tableOps = tableOps;
    }

    @Override
    public SortedSet<String> list() {
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Fetching list of namespaces...", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        TreeSet<String> namespaces = new TreeSet<String>(Namespaces.getNameToIdMap(this.context).keySet());
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Fetched {} namespaces in {}", new Object[]{Thread.currentThread().getId(), namespaces.size(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return namespaces;
    }

    @Override
    public boolean exists(String namespace) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Checking if namespace {} exists", (Object)Thread.currentThread().getId(), (Object)namespace);
            timer = new OpTimer().start();
        }
        boolean exists = Namespaces.namespaceNameExists(this.context, namespace);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Checked existance of {} in {}", new Object[]{Thread.currentThread().getId(), exists, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return exists;
    }

    @Override
    public void create(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        try {
            this.doNamespaceFateOperation(FateOperation.NAMESPACE_CREATE, Arrays.asList(ByteBuffer.wrap(namespace.getBytes(StandardCharsets.UTF_8))), Collections.emptyMap(), namespace);
        }
        catch (NamespaceNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void delete(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        NamespaceId namespaceId = Namespaces.getNamespaceId(this.context, namespace);
        if (namespaceId.equals(Namespace.ACCUMULO.id()) || namespaceId.equals(Namespace.DEFAULT.id())) {
            Credentials credentials = this.context.getCredentials();
            log.debug("{} attempted to delete the {} namespace", (Object)credentials.getPrincipal(), (Object)namespaceId);
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.UNSUPPORTED_OPERATION);
        }
        if (Namespaces.getTableIds(this.context, namespaceId).size() > 0) {
            throw new NamespaceNotEmptyException(namespaceId.canonical(), namespace, null);
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(namespace.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doNamespaceFateOperation(FateOperation.NAMESPACE_DELETE, args, opts, namespace);
        }
        catch (NamespaceExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void rename(String oldNamespaceName, String newNamespaceName) throws AccumuloSecurityException, NamespaceNotFoundException, AccumuloException, NamespaceExistsException {
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(oldNamespaceName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newNamespaceName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        this.doNamespaceFateOperation(FateOperation.NAMESPACE_RENAME, args, opts, oldNamespaceName);
    }

    @Override
    public void setProperty(String namespace, String property, String value) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        MasterClient.executeNamespace(this.context, client -> client.setNamespaceProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), namespace, property, value));
        this.checkLocalityGroups(namespace, property);
    }

    @Override
    public void removeProperty(String namespace, String property) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        MasterClient.executeNamespace(this.context, client -> client.removeNamespaceProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), namespace, property));
        this.checkLocalityGroups(namespace, property);
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(String namespace) throws AccumuloException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        try {
            return ServerClient.executeRaw(this.context, client -> client.getNamespaceConfiguration(TraceUtil.traceInfo(), this.context.rpcCreds(), namespace)).entrySet();
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public Map<String, String> namespaceIdMap() {
        return Namespaces.getNameToIdMap(this.context).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NamespaceId)e.getValue()).canonical(), (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, TreeMap::new));
    }

    @Override
    public boolean testClassLoad(String namespace, String className, String asTypeName) throws NamespaceNotFoundException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)"className is null");
        Preconditions.checkArgument((asTypeName != null ? 1 : 0) != 0, (Object)"asTypeName is null");
        try {
            return ServerClient.executeRaw(this.context, client -> client.checkNamespaceClass(TraceUtil.traceInfo(), this.context.rpcCreds(), namespace, className, asTypeName));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void attachIterator(String namespace, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        this.testClassLoad(namespace, setting.getIteratorClass(), SortedKeyValueIterator.class.getName());
        super.attachIterator(namespace, setting, scopes);
    }

    @Override
    public int addConstraint(String namespace, String constraintClassName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        this.testClassLoad(namespace, constraintClassName, Constraint.class.getName());
        return super.addConstraint(namespace, constraintClassName);
    }

    private String doNamespaceFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String namespace) throws AccumuloSecurityException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        try {
            return this.tableOps.doFateOperation(op, args, opts, namespace);
        }
        catch (TableExistsException | TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void checkLocalityGroups(String namespace, String propChanged) throws AccumuloException, NamespaceNotFoundException {
        if (LocalityGroupUtil.isLocalityGroupProperty(propChanged)) {
            Iterable<Map.Entry<String, String>> allProps = this.getProperties(namespace);
            try {
                LocalityGroupUtil.checkLocalityGroups(allProps);
            }
            catch (RuntimeException | LocalityGroupUtil.LocalityGroupConfigurationError e) {
                LoggerFactory.getLogger(this.getClass()).warn("Changing '" + propChanged + "' for namespace '" + namespace + "'resulted in bad locality group config. This may be a transient situation since the config spreads over multiple properties. Setting properties in a different order may help. Even though this warning was displayed, the property was updated. Please check your config to ensure consistency.", (Throwable)e);
            }
        }
    }
}

